/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.internal;

import com.agfa.pacs.data.export.internal.IDataSink;
import com.agfa.pacs.logging.ALogger;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.dcm4che3.util.SafeClose;

public class FileSourceDataSink
implements IDataSink {
    private File destinationDirectory;
    private String suffix = null;
    private static final ALogger log = ALogger.getLogger(FileSourceDataSink.class);
    private Map<String, OutputStream> map;
    private Map<String, File> fileMap = null;

    public FileSourceDataSink(File file, String string, Map<String, File> map) {
        this.destinationDirectory = file;
        this.suffix = string;
        this.map = new HashMap<String, OutputStream>();
        this.fileMap = map;
    }

    @Override
    public OutputStream getOutputStream(String string, String[] stringArray) {
        File file;
        block4: {
            try {
                file = this.getFile(string, stringArray);
                file.getParentFile().mkdirs();
                if (file.getParentFile().exists()) break block4;
                return null;
            }
            catch (IOException iOException) {
                log.error("Could not get Output stream", (Throwable)iOException);
                return null;
            }
        }
        if (this.fileMap != null) {
            this.fileMap.put(string, file);
        }
        OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        this.map.put(string, bufferedOutputStream);
        return bufferedOutputStream;
    }

    @Override
    public void closeOutputStream(String string) {
        OutputStream outputStream = this.map.remove(string);
        SafeClose.close((Closeable)outputStream);
    }

    protected File getFile(String string, String[] stringArray) {
        File file = this.destinationDirectory;
        int n = 0;
        while (n < stringArray.length - 1) {
            file = new File(file, stringArray[n]);
            ++n;
        }
        file = new File(file, String.valueOf(stringArray[stringArray.length - 1]) + (this.suffix != null ? "." + this.suffix : ""));
        return file;
    }
}

