/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicom.exporter.image;

import com.agfa.pacs.data.shared.pixel.ImageIOUtils;
import com.agfa.pacs.listtext.dicom.exporter.image.IImageEncoder;
import com.agfa.pacs.logging.ALogger;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import org.w3c.dom.NodeList;

public class DefaultImageEncoder
implements IImageEncoder {
    private static final ALogger log = ALogger.getLogger(DefaultImageEncoder.class);
    private ImageWriter imageWriter;
    private int dpi = 300;

    @Override
    public void encode(File file, BufferedImage bufferedImage) {
        ImageWriteParam imageWriteParam = this.imageWriter.getDefaultWriteParam();
        try {
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);){
                    ImageIOUtils.acquireJAI();
                    try {
                        this.imageWriter.setOutput(fileImageOutputStream);
                        IIOMetadata iIOMetadata = null;
                        iIOMetadata = this.setDpiMetadata(this.imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), imageWriteParam));
                        IIOImage iIOImage = new IIOImage(bufferedImage, null, iIOMetadata);
                        this.imageWriter.write(null, iIOImage, imageWriteParam);
                        fileImageOutputStream.flush();
                    }
                    finally {
                        this.imageWriter.reset();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.error("Could not find file", (Throwable)fileNotFoundException);
                ImageIOUtils.releaseJAI();
            }
            catch (IOException iOException) {
                log.error("Error on initialzing ImageOutputStream", (Throwable)iOException);
                ImageIOUtils.releaseJAI();
            }
        }
        finally {
            ImageIOUtils.releaseJAI();
        }
    }

    private IIOMetadata setDpiMetadata(IIOMetadata iIOMetadata) {
        if (iIOMetadata != null) {
            if (iIOMetadata.isReadOnly()) {
                log.warn("Cannot set DPI metadata, because the metadata is read-only.");
                return iIOMetadata;
            }
            String string = "javax_imageio_1.0";
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(string);
            if (iIOMetadataNode != null) {
                IIOMetadataNode iIOMetadataNode2 = this.getChildNode(iIOMetadataNode, iIOMetadataNode, "Dimension");
                this.setDpiValue(iIOMetadataNode, iIOMetadataNode2, "HorizontalPixelSize");
                this.setDpiValue(iIOMetadataNode, iIOMetadataNode2, "VerticalPixelSize");
                try {
                    iIOMetadata.mergeTree(string, iIOMetadataNode);
                }
                catch (IIOInvalidTreeException iIOInvalidTreeException) {
                    log.error("Error on processing metadata", (Throwable)iIOInvalidTreeException);
                }
            }
        }
        return iIOMetadata;
    }

    private void setDpiValue(IIOMetadataNode iIOMetadataNode, IIOMetadataNode iIOMetadataNode2, String string) {
        String string2 = Float.toString((float)this.dpi / 25.4f);
        this.getChildNode(iIOMetadataNode, iIOMetadataNode2, string).setAttribute("value", string2);
    }

    private IIOMetadataNode getChildNode(IIOMetadataNode iIOMetadataNode, IIOMetadataNode iIOMetadataNode2, String string) {
        IIOMetadataNode iIOMetadataNode3;
        NodeList nodeList = iIOMetadataNode.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            iIOMetadataNode3 = new IIOMetadataNode(string);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        } else {
            iIOMetadataNode3 = (IIOMetadataNode)nodeList.item(0);
        }
        return iIOMetadataNode3;
    }

    @Override
    public void setDpi(int n) {
        this.dpi = n;
    }

    @Override
    public void setCompressionRate(float f) {
        ImageWriteParam imageWriteParam = this.imageWriter.getDefaultWriteParam();
        if (imageWriteParam.canWriteCompressed()) {
            String[] stringArray = imageWriteParam.getCompressionTypes();
            String string = stringArray[0];
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionType(string);
            imageWriteParam.setCompressionQuality(f);
        }
    }

    @Override
    public void setImageWriter(ImageWriter imageWriter) {
        this.imageWriter = imageWriter;
    }
}

