/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicom.exporter.image;

import com.agfa.pacs.data.export.IFileIDsSource;
import com.agfa.pacs.data.export.internal.DefaultImageFileIDsSource;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.listtext.dicom.exporter.image.DefaultImageEncoder;
import com.agfa.pacs.listtext.dicom.exporter.image.IImageEncoder;
import com.agfa.pacs.listtext.dicom.exporter.image.Image;
import com.agfa.pacs.listtext.dicom.exporter.image.JPEGEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class ImageFileWriter
implements IProcessingElement {
    public static final String DPI = "DPI";
    public static final String FILE_MAP = "IMAGE_FILE_MAP";
    public static final String IMAGE_DESTINATION = "IMAGE_DESTINATION";
    public static final String MIME_TYPE = "MIME_TYPE";
    public static final String FILE_SUFFIX = "IMAGE_FILE_SUFFIX";
    public static final String COMPRESSION_RATIO = "COMPRESSION_RATIO";
    public static final String INCLUDE_DEMOGRAPHICS = "INCLUDE_DEMOGRAPHICS";
    public static final String IMAGE_FILEIDSOURCE = "IMAGE_FILEIDSOURCE";
    public static final String IMAGE_FILE_NAME = "IMAGE_FILE_NAME";
    private static final String MIME_JPEG = "image/jpeg";
    private Map<String, File[]> fileMap = null;
    private File destination = null;
    private IFileIDsSource fileIDsSource;
    private String suffix = "jpg";
    private double compression = 0.85;
    private int dotsPerInch = 300;
    private ImageWriter writer;
    private IImageEncoder encoder = null;
    private static final Map<String, Class<? extends IImageEncoder>> mimeTypeMap = new Hashtable<String, Class<? extends IImageEncoder>>();

    static {
        mimeTypeMap.put(MIME_JPEG, JPEGEncoder.class);
        mimeTypeMap.put("image/png", DefaultImageEncoder.class);
    }

    public void finishProcessing() {
    }

    public void cleanUp() {
        this.writer.reset();
        this.writer = null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void prepareProcessing(Properties properties, List<? extends Object> list) throws ProcessingException {
        boolean bl = false;
        if (properties.containsKey(FILE_MAP)) {
            this.fileMap = (Map)properties.get(FILE_MAP);
            bl = true;
        } else {
            this.fileMap = new Hashtable<String, File[]>();
            properties.put(FILE_MAP, this.fileMap);
        }
        if (properties.containsKey(IMAGE_DESTINATION)) {
            this.destination = (File)properties.get(IMAGE_DESTINATION);
            bl = true;
        }
        if (properties.containsKey(COMPRESSION_RATIO)) {
            this.compression = (Double)properties.get(COMPRESSION_RATIO);
        }
        if (properties.containsKey(DPI)) {
            this.dotsPerInch = (Integer)properties.get(DPI);
        }
        String string = MIME_JPEG;
        if (properties.containsKey(MIME_TYPE)) {
            string = (String)properties.get(MIME_TYPE);
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(string);
        this.writer = iterator.next();
        Class<DefaultImageEncoder> clazz = mimeTypeMap.containsKey(string) ? mimeTypeMap.get(string) : DefaultImageEncoder.class;
        try {
            this.encoder = (IImageEncoder)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ProcessingException("Internal error", (Throwable)exception);
        }
        this.encoder.setImageWriter(this.writer);
        this.encoder.setCompressionRate((float)this.compression);
        this.encoder.setDpi(this.dotsPerInch);
        this.suffix = properties.containsKey(FILE_SUFFIX) ? (String)properties.get(FILE_SUFFIX) : this.writer.getOriginatingProvider().getFileSuffixes()[0];
        if (!bl) {
            throw new IllegalArgumentException("No target specified");
        }
        this.fileIDsSource = (IFileIDsSource)properties.get(IMAGE_FILEIDSOURCE);
        if (this.fileIDsSource == null) {
            this.fileIDsSource = new DefaultImageFileIDsSource();
        }
        if (this.fileIDsSource instanceof DefaultImageFileIDsSource && properties.containsKey(IMAGE_FILE_NAME)) {
            ((DefaultImageFileIDsSource)this.fileIDsSource).setNamePrefix(properties.getProperty(IMAGE_FILE_NAME));
        }
    }

    public Object process(Object object) throws ProcessingException {
        if (object instanceof Image) {
            Image image = (Image)object;
            BufferedImage bufferedImage = image.getImage();
            File file = this.getFile(image);
            if (file == null) {
                throw new IllegalArgumentException("No output specified");
            }
            this.encoder.encode(file, bufferedImage);
            return file;
        }
        throw new IllegalArgumentException("Wrong input type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFile(Image image) {
        File file = null;
        String string = image.dataset.getString(524312);
        Map<String, File[]> map = this.fileMap;
        synchronized (map) {
            if (this.destination != null) {
                String[] stringArray = this.fileIDsSource.getFileIDs(image.dataset, image.frameNumber);
                file = this.destination;
                int n = 0;
                while (n < stringArray.length - 1) {
                    file = new File(file, stringArray[n]);
                    ++n;
                }
                file = new File(file, String.valueOf(stringArray[stringArray.length - 1]) + "." + this.suffix);
                File[] fileArray = this.fileMap.get(string);
                if (fileArray == null) {
                    fileArray = new File[image.dataset.getInt(0x280008, 1)];
                    this.fileMap.put(string, fileArray);
                }
                fileArray[image.frameNumber] = file;
            } else {
                file = this.fileMap.get(string)[image.frameNumber];
            }
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    public ProcessingProperty[] queryProperties() {
        ProcessingProperty[] processingPropertyArray = new ProcessingProperty[]{new ProcessingProperty(FILE_MAP, Map.class, null), new ProcessingProperty(IMAGE_DESTINATION, File.class, null), new ProcessingProperty(MIME_TYPE, String.class, null), new ProcessingProperty(FILE_SUFFIX, String.class, null), new ProcessingProperty(COMPRESSION_RATIO, Double.class, null), new ProcessingProperty(IMAGE_FILEIDSOURCE, IFileIDsSource.class, null)};
        return processingPropertyArray;
    }

    public boolean supportsConcurrentProcessing() {
        return false;
    }
}

