/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicom.exporter.image;

import com.agfa.pacs.listtext.dicom.exporter.image.IImageEncoder;
import com.agfa.pacs.logging.ALogger;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class JPEGEncoder
implements IImageEncoder {
    private static final ALogger log = ALogger.getLogger(JPEGEncoder.class);
    private float compressionRate = 1.0f;
    private Integer dpi = 300;

    @Override
    public void encode(File file, BufferedImage bufferedImage) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                jPEGEncodeParam.setDensityUnit(1);
                jPEGEncodeParam.setXDensity(this.dpi.intValue());
                jPEGEncodeParam.setYDensity(this.dpi.intValue());
                jPEGEncodeParam.setQuality(this.compressionRate, false);
                jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
                jPEGImageEncoder.encode(bufferedImage);
                ImageIO.write((RenderedImage)bufferedImage, "jpg", outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ImageFormatException | IOException throwable) {
            log.error("Encoding error" + throwable);
        }
    }

    @Override
    public void setDpi(int n) {
        this.dpi = n;
    }

    @Override
    public void setCompressionRate(float f) {
        this.compressionRate = f;
    }

    @Override
    public void setImageWriter(ImageWriter imageWriter) {
    }
}

