/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.config;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.listtext.config.IWorkstation;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.ComputerName;
import java.awt.Dimension;
import java.awt.Point;
import java.net.URLConnection;
import java.util.Locale;

public class Workstation
implements IWorkstation {
    private Integer screenNumber = null;
    private Dimension mainWindowSize;
    private boolean isMinimized;
    private boolean isMaximized;
    private Point leftUpperCorner;
    private IConfigurationProvider configWindow;
    private static ALogger log = ALogger.getLogger(Workstation.class);

    public Workstation(IConfigurationProvider iConfigurationProvider) {
        this.configWindow = iConfigurationProvider.getNode("listtext.workstation.mainwindow");
        if (this.configWindow.exists("monitorNumber")) {
            this.screenNumber = (int)this.configWindow.getLong("monitorNumber");
        }
        this.isMinimized = this.configWindow.getBoolean("minimized");
        this.isMaximized = this.configWindow.getBoolean("maximized");
        int n = (int)this.configWindow.getLong("width");
        int n2 = (int)this.configWindow.getLong("height");
        if (Math.abs(n2) > 5000 || Math.abs(n) > 5000) {
            n2 = 768;
            n = 1024;
            log.warn("Reset size");
        }
        this.mainWindowSize = new Dimension(n, n2);
        n = (int)this.configWindow.getLong("xleft");
        n2 = (int)this.configWindow.getLong("ytop");
        if (Math.abs(n2) > 5000 || Math.abs(n) > 5000) {
            n2 = 0;
            n = 0;
            log.warn("Reset position");
        }
        this.leftUpperCorner = new Point(n, n2);
        boolean bl = iConfigurationProvider.getBoolean("listtext.workstation.dicom.use_name_as_calling_AET");
        if (bl) {
            this.checkLocalNameInCallingAET();
        }
    }

    @Override
    public Integer getDefaultScreenNumber() {
        return this.screenNumber;
    }

    @Override
    public void setDefaultScreenNumber(int n) {
        if (this.screenNumber == null || n != this.screenNumber) {
            this.screenNumber = n;
            this.configWindow.setLong("monitorNumber", (long)n);
        }
    }

    private void checkLocalNameInCallingAET() {
        String string = ComputerName.getComputerId();
        if (string.length() > 16) {
            string = string.substring(0, 16);
        }
        string = string.toUpperCase(Locale.ENGLISH);
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        IConfigurationProvider iConfigurationProvider2 = iConfigurationProvider.getNode("listtext.dicom.device.config");
        IConfigurationList iConfigurationList = iConfigurationProvider2.getList("NetworkApplicationEntity");
        IConfigurationProvider iConfigurationProvider3 = (IConfigurationProvider)iConfigurationList.iterator().next();
        if (!iConfigurationProvider3.getString("AETitle").equals(string)) {
            iConfigurationProvider3.setString("AETitle", string);
        }
    }

    @Override
    public boolean isMinimized() {
        return this.isMinimized;
    }

    @Override
    public void setMinimized(boolean bl) {
        if (bl != this.isMinimized) {
            this.isMinimized = bl;
            this.configWindow.setBoolean("minimized", bl);
        }
    }

    @Override
    public boolean isMaximized() {
        return this.isMaximized;
    }

    @Override
    public Point getWindowLeftUpperCorner() {
        return this.leftUpperCorner;
    }

    @Override
    public Dimension getMainWindowDimension() {
        return this.mainWindowSize;
    }

    @Override
    public void setMaximized(boolean bl) {
        if (bl != this.isMaximized) {
            this.isMaximized = bl;
            this.configWindow.setBoolean("maximized", bl);
        }
    }

    @Override
    public void setWindowLeftUpperCorner(Point point) {
        if (!point.equals(this.leftUpperCorner)) {
            this.leftUpperCorner = point;
            this.configWindow.setLong("xleft", (long)point.x);
            this.configWindow.setLong("ytop", (long)point.y);
        }
    }

    @Override
    public void setMainWindowDimension(Dimension dimension) {
        if (!dimension.equals(this.mainWindowSize)) {
            this.mainWindowSize = dimension;
            this.configWindow.setLong("width", (long)dimension.width);
            this.configWindow.setLong("height", (long)dimension.height);
        }
    }

    public void authentificateInternetConnection(URLConnection uRLConnection) {
    }
}

