/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class SafeRunner {
    public static void run(ISafeRunnable iSafeRunnable) {
        Assert.isNotNull(iSafeRunnable);
        try {
            iSafeRunnable.run();
        }
        catch (Exception exception) {
            SafeRunner.handleException(iSafeRunnable, exception);
        }
        catch (LinkageError linkageError) {
            SafeRunner.handleException(iSafeRunnable, linkageError);
        }
        catch (AssertionError assertionError) {
            SafeRunner.handleException(iSafeRunnable, (Throwable)((Object)assertionError));
        }
    }

    private static void handleException(ISafeRunnable iSafeRunnable, Throwable throwable) {
        if (!(throwable instanceof OperationCanceledException)) {
            Status status;
            Activator activator = Activator.getDefault();
            String string = null;
            if (activator != null) {
                string = activator.getBundleId(iSafeRunnable);
            }
            if (string == null) {
                string = "org.eclipse.equinox.common";
            }
            String string2 = NLS.bind((String)CommonMessages.meta_pluginProblems, (Object)string);
            if (throwable instanceof CoreException) {
                status = new MultiStatus(string, 2, string2, throwable);
                status.merge(((CoreException)throwable).getStatus());
            } else {
                status = new Status(4, string, 2, string2, throwable);
            }
            if (!RuntimeLog.isEmpty()) {
                RuntimeLog.log(status);
            } else {
                throwable.printStackTrace();
            }
        }
        iSafeRunnable.handleException(throwable);
    }
}

