/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.task;

import com.agfa.pacs.cache.IMemoryAlertListener;
import com.agfa.pacs.cache.MemoryAlertHandler;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.internal.Event;
import com.agfa.pacs.event.internal.task.Task;
import java.lang.ref.SoftReference;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.NotThreadSafe;

public class TaskCache
implements IMemoryAlertListener {
    private static final TaskCache singelton = new TaskCache();
    private static final int PRIMARY_CACHE_MAX_SIZE = 10000;
    @GuardedBy(value="this")
    private final Cache primaryCache = new Cache();
    @GuardedBy(value="this")
    private SoftReference<Cache> additionalCacheRef = new SoftReference<Cache>(new Cache());
    @GuardedBy(value="this")
    private long given = 0L;
    @GuardedBy(value="this")
    private long returned = 0L;
    @GuardedBy(value="this")
    private long additionalCacheRecreated = 0L;
    @GuardedBy(value="this")
    private long additionalCacheClearedByMemoryAlert = 0L;

    public static TaskCache instance() {
        return singelton;
    }

    private TaskCache() {
        MemoryAlertHandler.addMemoryAlertListener((IMemoryAlertListener)this);
    }

    public Task getTask() {
        return this.getTask(null, null);
    }

    public synchronized Task getTask(Event event, IEventListener iEventListener) {
        ++this.given;
        Task task = this.primaryCache.getTask();
        if (task == null) {
            Cache cache = this.additionalCacheRef.get();
            if (cache != null) {
                task = cache.getTask();
            }
            if (task == null) {
                return new Task(event, iEventListener);
            }
        }
        if (task.e != null) {
            throw new IllegalArgumentException("Somebody used a task that was already put back to the task cache.");
        }
        if (task.l != null) {
            throw new IllegalArgumentException("Somebody used a task that was already put back to the task cache.");
        }
        if (task.followUp != null) {
            throw new IllegalArgumentException("Somebody used a task that was already put back to the task cache.");
        }
        task.e = event;
        task.l = iEventListener;
        task.next = null;
        return task;
    }

    public synchronized void putTask(Task task) {
        ++this.returned;
        task.e = null;
        task.l = null;
        task.followUp = null;
        if (this.primaryCache.getSize() < 10000) {
            this.primaryCache.putTask(task);
        } else {
            Cache cache = this.additionalCacheRef.get();
            if (cache == null) {
                ++this.additionalCacheRecreated;
                cache = new Cache();
                this.additionalCacheRef = new SoftReference<Cache>(cache);
            }
            cache.putTask(task);
        }
    }

    public synchronized long memoryAlert(long l, boolean bl) {
        Cache cache = this.additionalCacheRef.get();
        int n = 0;
        if (cache != null) {
            ++this.additionalCacheClearedByMemoryAlert;
            n = cache.getSize();
            this.additionalCacheRef.clear();
        }
        return n * 16;
    }

    public synchronized String toString() {
        int n = 0;
        int n2 = 0;
        Cache cache = this.additionalCacheRef.get();
        if (cache != null) {
            n = cache.getSize();
            n2 = cache.getMaxSize();
        }
        return "TaskCache:\n primary size: " + this.primaryCache.getSize() + " (max: " + this.primaryCache.getMaxSize() + ")\n" + " additional size: " + n + " (max: " + n2 + ")\n" + " given: " + this.given + "\n" + " returned: " + this.returned + " (not returned: " + (this.given - this.returned) + ")\n" + " additional cache cleared by memory alert: " + this.additionalCacheClearedByMemoryAlert + " times\n" + " additional cache recreated: " + this.additionalCacheRecreated + " times";
    }

    @NotThreadSafe
    private static class Cache {
        private Task head = null;
        private int size = 0;
        private int maxSize = 0;

        private Cache() {
        }

        public Task getTask() {
            if (this.head == null) {
                return null;
            }
            Task task = this.head;
            this.head = this.head.next;
            --this.size;
            return task;
        }

        public void putTask(Task task) {
            ++this.size;
            if (this.maxSize < this.size) {
                this.maxSize = this.size;
            }
            task.next = this.head;
            this.head = task;
        }

        public int getSize() {
            return this.size;
        }

        public int getMaxSize() {
            return this.maxSize;
        }
    }
}

