/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import org.eclipse.core.internal.content.BasicDescription;
import org.eclipse.core.internal.content.IContentTypeInfo;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;

public final class ContentDescription
extends BasicDescription {
    private static final String CHARSET_UTF_16 = "UTF-16";
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final byte FLAG_ALL_OPTIONS = 1;
    private static final byte FLAG_IMMUTABLE = 2;
    private byte flags;
    private Object keys;
    private Object values;

    public ContentDescription(QualifiedName[] qualifiedNameArray, IContentTypeInfo iContentTypeInfo) {
        super(iContentTypeInfo);
        if (qualifiedNameArray == IContentDescription.ALL) {
            this.flags = (byte)(this.flags | 1);
            return;
        }
        if (qualifiedNameArray.length > 1) {
            this.keys = qualifiedNameArray;
            this.values = new Object[qualifiedNameArray.length];
        } else if (qualifiedNameArray.length == 1) {
            this.keys = qualifiedNameArray[0];
        }
    }

    private void assertMutable() {
        if ((this.flags & 2) != 0) {
            throw new IllegalStateException("Content description is immutable");
        }
    }

    public String getCharset() {
        byte[] byArray = (byte[])this.getProperty(BYTE_ORDER_MARK);
        if (byArray == BOM_UTF_8) {
            return CHARSET_UTF_8;
        }
        if (byArray == BOM_UTF_16BE || byArray == BOM_UTF_16LE) {
            return CHARSET_UTF_16;
        }
        return (String)this.getProperty(CHARSET);
    }

    private Object getDescribedProperty(QualifiedName qualifiedName) {
        if (this.values == null) {
            return null;
        }
        if (this.keys instanceof QualifiedName) {
            return this.keys.equals(qualifiedName) ? this.values : null;
        }
        QualifiedName[] qualifiedNameArray = (QualifiedName[])this.keys;
        int n = 0;
        while (n < qualifiedNameArray.length) {
            if (qualifiedNameArray[n].equals((Object)qualifiedName)) {
                return ((Object[])this.values)[n];
            }
            ++n;
        }
        return null;
    }

    public Object getProperty(QualifiedName qualifiedName) {
        Object object = this.getDescribedProperty(qualifiedName);
        if (object != null) {
            return object;
        }
        return this.contentTypeInfo.getDefaultProperty(qualifiedName);
    }

    public boolean isRequested(QualifiedName qualifiedName) {
        if ((this.flags & 1) != 0) {
            return true;
        }
        if (this.keys == null) {
            return false;
        }
        if (this.keys instanceof QualifiedName) {
            return this.keys.equals(qualifiedName);
        }
        QualifiedName[] qualifiedNameArray = (QualifiedName[])this.keys;
        int n = 0;
        while (n < qualifiedNameArray.length) {
            if (qualifiedNameArray[n].equals((Object)qualifiedName)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isSet() {
        if (this.keys == null || this.values == null) {
            return false;
        }
        if (this.keys instanceof QualifiedName) {
            return true;
        }
        Object[] objectArray = (Object[])this.values;
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void markImmutable() {
        this.assertMutable();
        this.flags = (byte)(this.flags | 2);
    }

    void setContentTypeInfo(IContentTypeInfo iContentTypeInfo) {
        this.contentTypeInfo = iContentTypeInfo;
    }

    public void setProperty(QualifiedName qualifiedName, Object object) {
        this.assertMutable();
        if (this.keys == null) {
            if ((this.flags & 1) != 0) {
                this.keys = qualifiedName;
                this.values = object;
            }
            return;
        }
        if (this.keys.equals(qualifiedName)) {
            this.values = object;
            return;
        }
        if (this.keys instanceof QualifiedName) {
            if ((this.flags & 1) != 0) {
                this.keys = new QualifiedName[]{(QualifiedName)this.keys, qualifiedName};
                this.values = new Object[]{this.values, object};
            }
            return;
        }
        QualifiedName[] qualifiedNameArray = (QualifiedName[])this.keys;
        int n = 0;
        while (n < qualifiedNameArray.length) {
            if (qualifiedNameArray[n].equals((Object)qualifiedName)) {
                ((Object[])this.values)[n] = object;
                return;
            }
            ++n;
        }
        if ((this.flags & 1) == 0) {
            return;
        }
        n = qualifiedNameArray.length;
        qualifiedNameArray = new QualifiedName[n + 1];
        System.arraycopy(this.keys, 0, qualifiedNameArray, 0, n);
        Object[] objectArray = new Object[n + 1];
        System.arraycopy(this.values, 0, objectArray, 0, n);
        qualifiedNameArray[qualifiedNameArray.length - 1] = qualifiedName;
        objectArray[objectArray.length - 1] = object;
        this.keys = qualifiedNameArray;
        this.values = objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        if (this.keys != null) {
            if (this.keys instanceof QualifiedName) {
                if (this.values != null) {
                    stringBuffer.append(this.keys + "=" + this.values);
                }
            } else {
                QualifiedName[] qualifiedNameArray = (QualifiedName[])this.keys;
                Object[] objectArray = (Object[])this.values;
                boolean bl = false;
                int n = 0;
                while (n < qualifiedNameArray.length) {
                    if (objectArray[n] != null) {
                        stringBuffer.append(qualifiedNameArray[n] + "=" + objectArray[n] + ",");
                        bl = true;
                    }
                    ++n;
                }
                if (bl) {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
            }
        }
        stringBuffer.append("} : ");
        stringBuffer.append(this.contentTypeInfo.getContentType());
        return stringBuffer.toString();
    }
}

