/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeCatalog;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ContentTypeBuilder {
    public static final String PT_CONTENTTYPES = "contentTypes";
    private ContentTypeCatalog catalog;
    private static final IConfigurationElement[] emptyConfArray = new IConfigurationElement[0];

    private static String getUniqueId(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            string2 = String.valueOf(string) + '.' + string2;
        }
        return string2;
    }

    private static QualifiedName parseQualifiedName(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            return new QualifiedName(string, string2);
        }
        if (n == 0 || n == string2.length() - 1) {
            return null;
        }
        string = string2.substring(0, n);
        String string3 = string2.substring(n + 1);
        return new QualifiedName(string, string3);
    }

    private static byte parsePriority(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equals("high")) {
            return 1;
        }
        if (string.equals("low")) {
            return -1;
        }
        if (!string.equals("normal")) {
            return 0;
        }
        return 0;
    }

    protected ContentTypeBuilder(ContentTypeCatalog contentTypeCatalog) {
        this.catalog = contentTypeCatalog;
    }

    private void addFileAssociation(IConfigurationElement iConfigurationElement, ContentType contentType) {
        String[] stringArray = Util.parseItems(iConfigurationElement.getAttributeAsIs("file-names"));
        int n = 0;
        while (n < stringArray.length) {
            contentType.internalAddFileSpec(stringArray[n], 5);
            ++n;
        }
        String[] stringArray2 = Util.parseItems(iConfigurationElement.getAttributeAsIs("file-extensions"));
        int n2 = 0;
        while (n2 < stringArray2.length) {
            contentType.internalAddFileSpec(stringArray2[n2], 9);
            ++n2;
        }
    }

    public void buildCatalog() {
        IConfigurationElement[] iConfigurationElementArray = this.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equals("content-type")) {
                this.registerContentType(iConfigurationElementArray[n]);
            }
            ++n;
        }
        n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equals("file-association")) {
                this.registerFileAssociation(iConfigurationElementArray[n]);
            }
            ++n;
        }
        this.applyPreferences();
    }

    private void applyPreferences() {
        try {
            final ContentTypeCatalog contentTypeCatalog = this.catalog;
            final IEclipsePreferences iEclipsePreferences = contentTypeCatalog.getManager().getPreferences();
            iEclipsePreferences.accept(new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences iEclipsePreferences2) {
                    if (iEclipsePreferences2 == iEclipsePreferences) {
                        return true;
                    }
                    ContentType contentType = contentTypeCatalog.internalGetContentType(iEclipsePreferences2.name());
                    if (contentType != null) {
                        contentType.processPreferences((Preferences)iEclipsePreferences2);
                    }
                    return false;
                }
            });
        }
        catch (BackingStoreException backingStoreException) {
            ContentType.log(ContentMessages.content_errorLoadingSettings, backingStoreException);
        }
    }

    private ContentType createContentType(IConfigurationElement iConfigurationElement) throws CoreException {
        String string;
        String string2 = iConfigurationElement.getContributor().getName();
        String string3 = iConfigurationElement.getAttributeAsIs("id");
        String string4 = iConfigurationElement.getAttribute("name");
        if (string3 == null) {
            this.missingMandatoryAttribute(ContentMessages.content_missingIdentifier, string2);
        }
        String string5 = string3.lastIndexOf(46) == -1 ? String.valueOf(string2) + '.' + string3 : string3;
        if (string4 == null) {
            this.missingMandatoryAttribute(ContentMessages.content_missingName, string5);
        }
        byte by = ContentTypeBuilder.parsePriority(iConfigurationElement.getAttributeAsIs("priority"));
        String[] stringArray = Util.parseItems(iConfigurationElement.getAttributeAsIs("file-names"));
        String[] stringArray2 = Util.parseItems(iConfigurationElement.getAttributeAsIs("file-extensions"));
        String string6 = ContentTypeBuilder.getUniqueId(string2, iConfigurationElement.getAttributeAsIs("base-type"));
        String string7 = ContentTypeBuilder.getUniqueId(string2, iConfigurationElement.getAttributeAsIs("alias-for"));
        IConfigurationElement[] iConfigurationElementArray = null;
        Map<Object, Object> map = null;
        iConfigurationElementArray = iConfigurationElement.getChildren("property");
        if (iConfigurationElementArray.length > 0) {
            map = new HashMap();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string8;
                QualifiedName qualifiedName;
                String string9 = iConfigurationElementArray[n].getAttributeAsIs("default");
                if (string9 == null) {
                    string9 = "";
                }
                if ((qualifiedName = ContentTypeBuilder.parseQualifiedName(string2, string8 = iConfigurationElementArray[n].getAttributeAsIs("name"))) == null) {
                    if (ContentTypeManager.DEBUGGING) {
                        String string10 = NLS.bind((String)ContentMessages.content_invalidProperty, (Object)string8, (Object)ContentTypeBuilder.getUniqueId(string2, string3));
                        ContentType.log(string10, null);
                    }
                } else {
                    map.put(qualifiedName, string9);
                }
                ++n;
            }
        }
        if ((string = iConfigurationElement.getAttributeAsIs("default-charset")) != null) {
            if (map == null) {
                map = Collections.singletonMap(IContentDescription.CHARSET, string);
            } else if (!map.containsKey(IContentDescription.CHARSET)) {
                map.put(IContentDescription.CHARSET, string);
            }
        }
        return ContentType.createContentType(this.catalog, string5, string4, by, stringArray2, stringArray, string6, string7, map, iConfigurationElement);
    }

    protected IConfigurationElement[] getConfigurationElements() {
        IExtensionPoint iExtensionPoint;
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        if (iExtensionRegistry == null) {
            return emptyConfArray;
        }
        IConfigurationElement[] iConfigurationElementArray = emptyConfArray;
        IConfigurationElement[] iConfigurationElementArray2 = emptyConfArray;
        IExtensionPoint iExtensionPoint2 = iExtensionRegistry.getExtensionPoint("org.eclipse.core.runtime", PT_CONTENTTYPES);
        if (iExtensionPoint2 != null) {
            iConfigurationElementArray = iExtensionPoint2.getConfigurationElements();
        }
        if ((iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.core.contenttype", PT_CONTENTTYPES)) != null) {
            iConfigurationElementArray2 = iExtensionPoint.getConfigurationElements();
        }
        IConfigurationElement[] iConfigurationElementArray3 = new IConfigurationElement[iConfigurationElementArray.length + iConfigurationElementArray2.length];
        System.arraycopy(iConfigurationElementArray, 0, iConfigurationElementArray3, 0, iConfigurationElementArray.length);
        System.arraycopy(iConfigurationElementArray2, 0, iConfigurationElementArray3, iConfigurationElementArray.length, iConfigurationElementArray2.length);
        return iConfigurationElementArray3;
    }

    private void missingMandatoryAttribute(String string, String string2) throws CoreException {
        String string3 = NLS.bind((String)string, (Object)string2);
        throw new CoreException((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, string3, null));
    }

    private void registerContentType(IConfigurationElement iConfigurationElement) {
        try {
            ContentType contentType = this.createContentType(iConfigurationElement);
            this.catalog.addContentType(contentType);
        }
        catch (CoreException coreException) {
            RuntimeLog.log((IStatus)coreException.getStatus());
        }
    }

    private void registerFileAssociation(IConfigurationElement iConfigurationElement) {
        String string = ContentTypeBuilder.getUniqueId(iConfigurationElement.getContributor().getName(), iConfigurationElement.getAttribute("content-type"));
        ContentType contentType = this.catalog.internalGetContentType(string);
        if (contentType == null) {
            return;
        }
        this.addFileAssociation(iConfigurationElement, contentType);
    }
}

