/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.internal.content.BasicDescription;
import org.eclipse.core.internal.content.ContentDescription;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeCatalog;
import org.eclipse.core.internal.content.ContentTypeHandler;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.content.ContentTypeSettings;
import org.eclipse.core.internal.content.DefaultDescription;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ContentTypeMatcher
implements IContentTypeMatcher {
    private IScopeContext context;
    private IContentTypeManager.ISelectionPolicy policy;

    public ContentTypeMatcher(IContentTypeManager.ISelectionPolicy iSelectionPolicy, IScopeContext iScopeContext) {
        this.policy = iSelectionPolicy;
        this.context = iScopeContext;
    }

    public IContentType findContentTypeFor(InputStream inputStream, String string) throws IOException {
        ContentTypeCatalog contentTypeCatalog = this.getCatalog();
        IContentType[] iContentTypeArray = contentTypeCatalog.findContentTypesFor(this, inputStream, string);
        return iContentTypeArray.length > 0 ? new ContentTypeHandler((ContentType)iContentTypeArray[0], contentTypeCatalog.getGeneration()) : null;
    }

    public IContentType findContentTypeFor(String string) {
        ContentTypeCatalog contentTypeCatalog = this.getCatalog();
        IContentType[] iContentTypeArray = contentTypeCatalog.findContentTypesFor(this, string);
        return iContentTypeArray.length == 0 ? null : new ContentTypeHandler((ContentType)iContentTypeArray[0], contentTypeCatalog.getGeneration());
    }

    public IContentType[] findContentTypesFor(InputStream inputStream, String string) throws IOException {
        ContentTypeCatalog contentTypeCatalog = this.getCatalog();
        IContentType[] iContentTypeArray = contentTypeCatalog.findContentTypesFor(this, inputStream, string);
        IContentType[] iContentTypeArray2 = new IContentType[iContentTypeArray.length];
        int n = contentTypeCatalog.getGeneration();
        int n2 = 0;
        while (n2 < iContentTypeArray2.length) {
            iContentTypeArray2[n2] = new ContentTypeHandler((ContentType)iContentTypeArray[n2], n);
            ++n2;
        }
        return iContentTypeArray2;
    }

    public IContentType[] findContentTypesFor(String string) {
        ContentTypeCatalog contentTypeCatalog = this.getCatalog();
        IContentType[] iContentTypeArray = contentTypeCatalog.findContentTypesFor(this, string);
        IContentType[] iContentTypeArray2 = new IContentType[iContentTypeArray.length];
        int n = contentTypeCatalog.getGeneration();
        int n2 = 0;
        while (n2 < iContentTypeArray2.length) {
            iContentTypeArray2[n2] = new ContentTypeHandler((ContentType)iContentTypeArray[n2], n);
            ++n2;
        }
        return iContentTypeArray2;
    }

    private ContentTypeCatalog getCatalog() {
        return ContentTypeManager.getInstance().getCatalog();
    }

    public IContentDescription getDescriptionFor(InputStream inputStream, String string, QualifiedName[] qualifiedNameArray) throws IOException {
        return this.getCatalog().getDescriptionFor(this, inputStream, string, qualifiedNameArray);
    }

    public IContentDescription getDescriptionFor(Reader reader, String string, QualifiedName[] qualifiedNameArray) throws IOException {
        return this.getCatalog().getDescriptionFor(this, reader, string, qualifiedNameArray);
    }

    public IScopeContext getContext() {
        return this.context;
    }

    public IContentTypeManager.ISelectionPolicy getPolicy() {
        return this.policy;
    }

    public Collection getDirectlyAssociated(final ContentTypeCatalog contentTypeCatalog, final String string, final int n) {
        final IEclipsePreferences iEclipsePreferences = this.context.getNode("org.eclipse.core.runtime/content-types");
        final HashSet hashSet = new HashSet(3);
        try {
            iEclipsePreferences.accept(new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences iEclipsePreferences2) {
                    if (iEclipsePreferences2 == iEclipsePreferences) {
                        return true;
                    }
                    String[] stringArray = ContentTypeSettings.getFileSpecs((Preferences)iEclipsePreferences2, n);
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].equalsIgnoreCase(string)) {
                            ContentType contentType = contentTypeCatalog.getContentType(iEclipsePreferences2.name());
                            if (contentType == null) break;
                            hashSet.add(contentType);
                            break;
                        }
                        ++n2;
                    }
                    return false;
                }
            });
        }
        catch (BackingStoreException backingStoreException) {
            ContentType.log(ContentMessages.content_errorLoadingSettings, backingStoreException);
        }
        return hashSet == null ? Collections.EMPTY_SET : hashSet;
    }

    public IContentDescription getSpecificDescription(BasicDescription basicDescription) {
        if (basicDescription == null || ContentTypeManager.getInstance().getContext().equals(this.getContext())) {
            return basicDescription;
        }
        if (basicDescription instanceof DefaultDescription) {
            return new DefaultDescription(new ContentTypeSettings((ContentType)basicDescription.getContentTypeInfo(), this.context));
        }
        ((ContentDescription)basicDescription).setContentTypeInfo(new ContentTypeSettings((ContentType)basicDescription.getContentTypeInfo(), this.context));
        return basicDescription;
    }
}

