/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.base;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.dicom.device.config.DicomDeviceConfigurationFactory;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.node.DataInfoNodeProviderFactory;
import com.agfa.pacs.data.shared.node.DataInfoNodeUtilities;
import com.agfa.pacs.data.shared.node.IAETResolver;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.node.config.DataInfoNodeConfigurationFactory;
import com.agfa.pacs.data.shared.node.config.DataInfoNodeConfigurationUtilities;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.listtext.lta.util.SendError;
import com.agfa.pacs.logging.ALogger;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class Base {
    private static final ALogger log = ALogger.getLogger(Base.class);
    private static boolean relevantOn;
    private static boolean useThinArchive;
    private static boolean hasThinArchives;
    private static String issuerMPI;
    private static List<IDataInfoNode> dataInfoNodes;
    private static List<IDataInfoNode> dataInfoNodesUserSearchable;
    private static List<IDataInfoNode> dataInfoNodesServiceSearchable;
    private static IDataInfoNode masterDataNode;
    private static Object monitor;
    private static IConfigurationChangeListener listener;
    public static final String EVENT_PATH_CONFIGAREA = "lta.configarea.ui";
    public static final String EVENT_PATH_LISTAREA_ERROR = "lta.error";
    public static final String EVENT_PATH_MAIN_UI = "lta.ui";
    public static final String EVENT_PATH_MAIN_APP = "lta.app";
    public static final String EVENT_PATH_TEXTAREA = "textarea";
    public static final String EXPORT_NOTIFICATION = "EXPORT_NOTIFICATION";
    public static final String ERROR_NOTIFICATION = "ERROR_NOTIFICATION";
    public static final String STUDY_STATUS_CHANGED = "STUDY_STATUS_CHANGED";
    public static final String LISTAREA_NEXT_PATIENT_REQUEST = "NEXT_PATIENT_REQUEST";
    public static final String LISTAREA_PREVIOUS_PATIENT_REQUEST = "PREVIOUS_PATIENT_REQUEST";
    public static final String APPLICATION_LIST_CONTROL_PANEL = "LTA_LIST_CONTROL_PANEL";
    public static final String APPLICATION_LOGIN = "LTA_LOGIN";
    public static final String APPLICATION_VISIBILITY_REQUEST = "LTA_VISIBILITY_REQUEST";
    public static final String APPLICATION_EXIT = "LTA_EXIT";
    public static final String MAIN_APP_TITLE_CHANGE = "MAIN_APP_TITLE_CHANGE";
    public static final String LISTAREA_WORKLIST_SELECTION_CHANGED = "WORKLIST_SELECTION_CHANGED";
    private static final String TEXTAREA_INIT_REQUEST = "TEXT_AREA_INIT_REQUEST";
    public static final int EVENT_ID_TEXTAREA_INIT_REQUEST;
    public static final String TEXTAREA_INIT_REQUEST_WITH_PATIENT = "TEXT_AREA_INIT_REQUEST_WITH_PATIENT";
    public static final String TEXTAREA_CONTENT_EVENT = "TEXT_AREA_CONTENT_EVENT";
    public static final String LISTAREA_WORKLIST_VERT_SCROLL_EVENT = "WORKLIST_VERTICAL_SCROLL";
    public static final String LISTAREA_WORKLIST_HORZ_SCROLL_EVENT = "WORKLIST_HORIZONTAL_SCROLL";
    public static final String LISTAREA_REFRESH_EXPANDED_WORKLIST = "LISTAREA_REFRESH_EXPANDED_WORKLIST";
    public static final String LISTAREA_EXPAND_WORKLIST_REQUEST = "LISTAREA_EXPAND_WORKLIST_REQUEST";
    public static final String TEXTAREA_CLOSED = "TEXT_AREA_CLOSED";
    public static final String TEXTAREA_STUDY_SELECTION_CHANGE_REQUEST = "TEXT_AREA_STUDY_SELECTION_CHANGE_REQUEST";
    public static final String TEXTAREA_STUDY_SELECTION_CHANGED = "TEXT_AREA_STUDY_SELECTION_CHANGED";
    public static final String LISTAREA_DATAINFO_SELECTION_CHANGED = "DATAINFO_SELECTION_CHANGED";
    public static final String CONFIGAREA_CLOSED = "CONFIGAREA_CLOSED";
    public static final String APPLICATION_CONFIGURE_CONTROL_PANEL = "LTA_CONFIGURE_CONTROL_PANEL";
    public static final String TEXTAREA_CANCEL_INIT_REQUEST = "TEXT_AREA_CANCEL_INIT_REQUEST";
    public static final String SHOW_SCREENSHOT_BUTTON = "SHOW_SCREENSHOW";
    public static final String STUDY_NEARLINE_RETRIEVE_COMPLETED = "STUDY_NEARLINE_RETRIEVE_COMPLETED";
    public static final String RADIOLOGY_LIST_STUDIES_ADDED = "RADIOLOGY_LIST_STUDIES_ADDED";

    static {
        masterDataNode = null;
        monitor = new Object();
        listener = new DatanodeListener();
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        iConfigurationProvider.registerConfigurationChangeListener("listtext.datanode", listener);
        relevantOn = iConfigurationProvider.getBoolean("listtext.load_priors");
        useThinArchive = iConfigurationProvider.getBoolean("listtext.load_from_thin_archive");
        issuerMPI = iConfigurationProvider.getString("listtext.datanode.mpiIssuer");
        DataInfoNodeUtilities.setAETResolver((IAETResolver)new AETResolver());
        EVENT_ID_TEXTAREA_INIT_REQUEST = EventEngineFactory.getInstance().getEventID(TEXTAREA_INIT_REQUEST);
    }

    public static boolean isLoadRelevantPriorsEnabled() {
        return relevantOn;
    }

    public static boolean hasThinArchives() {
        return hasThinArchives;
    }

    public static boolean isUsingThinArchive() {
        return useThinArchive && hasThinArchives && !Product.isReducedVersion();
    }

    public static void setIsUsingThinArchive(boolean bl) {
        if (bl != useThinArchive) {
            useThinArchive = bl;
            ConfigurationProviderFactory.getConfig().setBoolean("listtext.load_from_thin_archive", useThinArchive);
        }
    }

    public static String determineMPI_ID(Attributes attributes) {
        if (attributes != null && issuerMPI != null && !issuerMPI.isEmpty()) {
            String string = attributes.getString(0x100021);
            if (string != null && string.equals(issuerMPI)) {
                return attributes.getString(0x100020);
            }
            Sequence sequence = attributes.getSequence(0x101002);
            if (sequence != null) {
                for (Attributes attributes2 : sequence) {
                    string = attributes2.getString(0x100021);
                    if (string == null || !string.equals(issuerMPI)) continue;
                    return attributes2.getString(0x100020);
                }
            }
        }
        return null;
    }

    public static boolean useTextArea() {
        return ConfigurationProviderFactory.getConfig().getBoolean("listtext.useTextArea");
    }

    public static boolean forceStayInListArea() {
        return ConfigurationProviderFactory.getConfig().getBoolean("listtext.forceStayInListArea");
    }

    public static void setLoadRelevantWith(boolean bl) {
        if (bl != relevantOn) {
            relevantOn = bl;
            ConfigurationProviderFactory.getConfig().setBoolean("listtext.load_priors", bl);
        }
    }

    public static List<IDataInfoNode> getDataNodesUserSearchable() {
        if (dataInfoNodesUserSearchable == null) {
            Base.initDataNodes();
        }
        return dataInfoNodesUserSearchable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDataNodes() {
        Object object = monitor;
        synchronized (object) {
            block16: {
                try {
                    Object object2;
                    Object object3;
                    if (dataInfoNodes != null) {
                        return;
                    }
                    ArrayList<IDataInfoNode> arrayList = new ArrayList<IDataInfoNode>(DataInfoNodeConfigurationFactory.getConfiguration().getDataNodes());
                    if (System.getProperty("config.archive") != null && (object3 = DataInfoNodeConfigurationUtilities.getDataInfoNodeForService((String)(object2 = System.getProperty("config.archive")))) != null) {
                        arrayList.add((IDataInfoNode)object3);
                    }
                    Base.sortDataInfoNodes(arrayList);
                    object2 = new ArrayList();
                    object3 = new ArrayList();
                    ArrayList<IDataInfoNode> arrayList2 = new ArrayList<IDataInfoNode>();
                    IDataInfoNode iDataInfoNode = null;
                    String string = DataInfoNodeConfigurationFactory.getConfiguration().getNameOfMasterArchive();
                    for (IDataInfoNode iDataInfoNode2 : arrayList) {
                        String string2;
                        object2.add(iDataInfoNode2);
                        if (iDataInfoNode2.getName().equals(string)) {
                            iDataInfoNode = iDataInfoNode2;
                        }
                        if (iDataInfoNode2.isUserSearchable() && !iDataInfoNode2.getType().equals("DICOMCACHE")) {
                            object3.add(iDataInfoNode2);
                        }
                        if (iDataInfoNode2.isServicesSearchable() && !(string2 = iDataInfoNode2.getType()).equals("DICOMCACHE") && !string2.equals("DICOMFILE") && !string2.equals("DICOMDIR")) {
                            arrayList2.add(iDataInfoNode2);
                        }
                        if (hasThinArchives || !iDataInfoNode2.getType().equals("AGFADICOMWADO") || (string2 = iDataInfoNode2.getIdentifier().getPropertiesOwner().properties().getProperty("thinSliceArchive")) == null) continue;
                        if (LicenseManager.getInstance().isLicensePresent("THIN_SLICE")) {
                            hasThinArchives = true;
                            continue;
                        }
                        log.warn("Thin slice archive license not available");
                    }
                    if (Product.isInEmergencyMode()) {
                        IDataInfoNode iDataInfoNode2;
                        iDataInfoNode2 = DataInfoNodeProviderFactory.getInstance().getDataNodeProvider("DICOMCACHE");
                        try {
                            IDataInfoNode iDataInfoNode3 = iDataInfoNode2.createDataNode("Cache", new Properties());
                            object3.add(0, iDataInfoNode3);
                            arrayList2.add(0, iDataInfoNode3);
                        }
                        catch (Exception exception) {
                            log.error("Could not access cache data node", (Throwable)exception);
                        }
                    }
                    dataInfoNodes = object2;
                    dataInfoNodesUserSearchable = object3;
                    dataInfoNodesServiceSearchable = arrayList2;
                    masterDataNode = iDataInfoNode;
                    log.info("Configured:" + dataInfoNodes.size() + " nodes:" + Base.outputNodeList(dataInfoNodes));
                    log.info("  user searchable " + dataInfoNodesUserSearchable.size() + ":" + Base.outputNodeList(dataInfoNodesUserSearchable));
                    log.info("  RIS searchable " + dataInfoNodesServiceSearchable.size() + ":" + Base.outputNodeList(dataInfoNodesServiceSearchable));
                    Audit.getInstance().setCallingAET(DicomDeviceConfigurationFactory.getConfiguration().getDefaultAET());
                    if (iDataInfoNode != null) {
                        log.info("Masternode configured.");
                    }
                }
                catch (Exception exception) {
                    SendError.sendErrorMessage(exception);
                    if (!(exception.getCause() instanceof BindException)) break block16;
                    throw new Error("No free Dicom port");
                }
            }
        }
    }

    private static String outputNodeList(List<IDataInfoNode> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IDataInfoNode iDataInfoNode : list) {
            stringBuilder.append(iDataInfoNode.getName()).append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static List<IDataInfoNode> getDataInfoNodes() {
        if (dataInfoNodes == null) {
            Base.initDataNodes();
        }
        return dataInfoNodes;
    }

    public static List<IDataInfoNode> getDataNodesForServices() {
        if (dataInfoNodesServiceSearchable == null) {
            Base.initDataNodes();
        }
        return dataInfoNodesServiceSearchable;
    }

    public static IDataInfoNode getMasterDataNode() {
        if (dataInfoNodes == null) {
            Base.initDataNodes();
        }
        return masterDataNode;
    }

    public static IDataInfoNode getConfiguredDataInfoNodeByName(String string) {
        if (string != null) {
            for (IDataInfoNode iDataInfoNode : Base.getDataInfoNodes()) {
                if (!string.equalsIgnoreCase(iDataInfoNode.getIdentifier().getName())) continue;
                return iDataInfoNode;
            }
        }
        return null;
    }

    public static IDataInfoNode getConfiguredDataInfoNodeByAET(String string) {
        if (string != null) {
            for (IDataInfoNode iDataInfoNode : Base.getDataInfoNodes()) {
                IDicomNode iDicomNode = null;
                if (iDataInfoNode instanceof IDicomNode) {
                    iDicomNode = (IDicomNode)iDataInfoNode;
                } else if (iDataInfoNode.getIdentifier() instanceof IDicomNode) {
                    iDicomNode = (IDicomNode)iDataInfoNode.getIdentifier();
                }
                if (iDicomNode == null || !string.equals(iDicomNode.getCalledAET())) continue;
                return iDataInfoNode;
            }
        }
        return null;
    }

    public static void sortDataInfoNodes(List<IDataInfoNode> list) {
        Collections.sort(list, DatanodeByOrderIdComparator.INSTANCE);
    }

    public static IDataInfoNode createDataInfoNode(IDataProviderIdentifier iDataProviderIdentifier) {
        try {
            IDataInfoNode iDataInfoNode = DataInfoNodeUtilities.createDataInfoNode((IDataProviderIdentifier)iDataProviderIdentifier);
            IDataInfoNode iDataInfoNode2 = Base.getConfiguredDataInfoNodeByName(iDataProviderIdentifier.getName());
            if (iDataInfoNode2 != null) {
                iDataInfoNode.setOrderId(iDataInfoNode2.getOrderId());
            }
            iDataInfoNode.setUserSearchable(true);
            return iDataInfoNode;
        }
        catch (Exception exception) {
            SendError.sendErrorMessage(exception);
            return null;
        }
    }

    private static synchronized void resetDataInfoNodesInt() {
        dataInfoNodes = null;
        dataInfoNodesUserSearchable = null;
        dataInfoNodesServiceSearchable = null;
        masterDataNode = null;
    }

    private static class AETResolver
    implements IAETResolver {
        private AETResolver() {
        }

        public IDicomNode resolveAET(String string) {
            List<IDataInfoNode> list = Base.getDataInfoNodes();
            for (IDataInfoNode iDataInfoNode : list) {
                if (!(iDataInfoNode.getIdentifier() instanceof IDicomNode) || !((IDicomNode)iDataInfoNode.getIdentifier()).getCalledAET().equalsIgnoreCase(string)) continue;
                return (IDicomNode)iDataInfoNode.getIdentifier();
            }
            return null;
        }
    }

    private static enum DatanodeByOrderIdComparator implements Comparator<IDataInfoNode>
    {
        INSTANCE;


        @Override
        public int compare(IDataInfoNode iDataInfoNode, IDataInfoNode iDataInfoNode2) {
            return Integer.compare(iDataInfoNode.getOrderId(), iDataInfoNode2.getOrderId());
        }
    }

    private static class DatanodeListener
    implements IConfigurationChangeListener {
        private DatanodeListener() {
        }

        public void configurationChanged(String string) {
            Base.resetDataInfoNodesInt();
        }
    }
}

