/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.integration.dicomsend.impl;

import com.agfa.pacs.data.dicom.device.config.DicomDeviceConfigurationFactory;
import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.SimpleDicomNode;
import com.agfa.pacs.data.shared.store.ISendNode;
import com.agfa.pacs.listtext.lta.store.StoreUtils;
import java.text.Collator;

public class DicomSendNode
implements ISendNode {
    private String name;
    private String host;
    private String calledAET;
    private int port;
    private String commitAET = null;
    private Integer commitPort = null;
    private String callingAET;
    private boolean isSecure;
    private boolean closeImmediately;
    public boolean useCMove = false;
    public final boolean supportsMPPS;
    public final boolean supportsDicomStorageCommitment;

    public DicomSendNode(String string, IDicomNode iDicomNode) {
        this.name = string;
        this.host = iDicomNode.getHost();
        this.port = iDicomNode.getPort();
        this.calledAET = iDicomNode.getCalledAET();
        this.callingAET = iDicomNode.getCallingAET();
        this.isSecure = iDicomNode.isEnabled(NodeProperty.Secure);
        this.supportsMPPS = iDicomNode.isEnabled(NodeProperty.MPPS);
        this.supportsDicomStorageCommitment = iDicomNode.isEnabled(NodeProperty.DicomStorageCommitment);
    }

    public DicomSendNode(String string, String string2, String string3, String string4, int n, String string5, Integer n2, boolean bl, boolean bl2) {
        this(string, string2, string3, string4, n, string5, n2, bl, bl2, true, true);
    }

    public DicomSendNode(String string, String string2, String string3, String string4, int n, String string5, Integer n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string;
        this.host = string2;
        this.calledAET = string3;
        this.port = n;
        this.commitAET = string5;
        if (string5 != null && string5.length() == 0) {
            this.commitAET = null;
        }
        this.commitPort = n2;
        this.callingAET = string4;
        this.isSecure = bl;
        this.closeImmediately = bl2;
        this.supportsMPPS = bl3;
        this.supportsDicomStorageCommitment = bl4;
        if (this.callingAET != null) {
            DicomDeviceConfigurationFactory.getConfiguration().registerAssociationAcceptorAE(string4);
        }
    }

    public DicomSendNode clone(String string) {
        DicomSendNode dicomSendNode = new DicomSendNode(string, this.host, this.calledAET, this.callingAET, this.port, this.commitAET, this.commitPort, this.isSecure, this.closeImmediately, this.supportsMPPS, this.supportsDicomStorageCommitment);
        dicomSendNode.setUseCMove(this.useCMove);
        return dicomSendNode;
    }

    public IDicomNode getCommitmentNode() {
        String string = this.commitAET == null ? this.calledAET : this.commitAET;
        int n = this.commitPort == null ? this.port : this.commitPort;
        return new SimpleDicomNode(this.host, n, string, null, this.isSecure, true);
    }

    public String toString() {
        return this.name;
    }

    public boolean useCMove() {
        return this.useCMove;
    }

    public void setUseCMove(boolean bl) {
        this.useCMove = bl;
    }

    public String getCalledAET() {
        return this.calledAET;
    }

    public String getCallingAET() {
        return this.callingAET;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof ISendNode) {
            ISendNode iSendNode = (ISendNode)object;
            if (!this.name.equals(iSendNode.getName())) {
                return false;
            }
            if (!this.calledAET.equals(iSendNode.getCalledAET())) {
                return false;
            }
            if (this.port != iSendNode.getPort()) {
                return false;
            }
            return this.host.equals(iSendNode.getHost());
        }
        return false;
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n ^= this.calledAET.hashCode();
        n ^= this.host.hashCode();
        return n ^= this.port;
    }

    public int compareTo(ISendNode iSendNode) {
        return Collator.getInstance().compare(this.name, iSendNode.getName());
    }

    public boolean isEnabled(NodeProperty nodeProperty) {
        switch (nodeProperty) {
            case Secure: {
                return this.isSecure;
            }
            case KeepAlive: {
                return !this.closeImmediately;
            }
            case DicomStorageCommitment: {
                return this.supportsDicomStorageCommitment;
            }
            case MPPS: {
                return this.supportsMPPS;
            }
            case AuthenticationSupported: {
                IDicomNode iDicomNode = StoreUtils.findSourceDicomNode(StoreUtils.findSourceForTarget(this));
                return iDicomNode != null ? iDicomNode.isEnabled(NodeProperty.AuthenticationSupported) : false;
            }
        }
        return false;
    }
}

