/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.integration.dicomsend.impl;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.store.ISendNode;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.integration.dicomsend.IDicomStoreConfiguration;
import com.agfa.pacs.listtext.integration.dicomsend.impl.DicomSendNode;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DicomStoreConfiguration
implements IDicomStoreConfiguration {
    private static final ALogger log = ALogger.getLogger(DicomStoreConfiguration.class);
    private final String ROOT = "listtext.service";
    private IConfigurationProvider provider = ConfigurationProviderFactory.getConfig().getNode("listtext.service");
    private List<ISendNode> sendNodes = null;
    private HashMap<String, String> mapping = null;
    private IConfigurationChangeListener listener = new ConfigNotifier();

    public DicomStoreConfiguration() {
        ConfigurationProviderFactory.getConfig().registerConfigurationChangeListener("listtext.service.dicomsend", this.listener);
        ConfigurationProviderFactory.getConfig().registerConfigurationChangeListener("listtext.service.storeMapping", this.listener);
    }

    @Override
    public synchronized ISendNode getSendNode(String string) {
        if (this.sendNodes == null) {
            this.initTables();
        }
        for (ISendNode iSendNode : this.sendNodes) {
            if (!iSendNode.getName().equals(string)) continue;
            return iSendNode;
        }
        return null;
    }

    @Override
    public String[] resolveSourceNodes(String string) {
        assert (string != null) : "Resolving source node failed: send node is null!";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
            if (!string.equals(entry.getValue())) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public synchronized ISendNode getPreferedNode(IDataInfoSource iDataInfoSource) {
        ISendNode iSendNode;
        String string;
        String string2;
        if (iDataInfoSource == null) {
            return null;
        }
        if (this.sendNodes == null) {
            this.initTables();
        }
        if (this.mapping.containsKey(string2 = iDataInfoSource.getIdentifier().getName())) {
            string = this.mapping.get(string2);
            iSendNode = this.getSendNode(string);
            if (iSendNode != null) {
                return iSendNode;
            }
            log.info("Mapped Dicom Send Target not found:" + string);
        }
        if (this.mapping.containsKey("ANY")) {
            string = this.mapping.get("ANY");
            iSendNode = this.getSendNode(string);
            if (iSendNode != null) {
                return iSendNode;
            }
            log.info("Mapped Dicom Send Target not found:" + string);
        }
        if ((string = iDataInfoSource.getIdentifier()) instanceof ISendNode) {
            return (ISendNode)string;
        }
        if (string instanceof IDicomNode) {
            return new DicomSendNode(iDataInfoSource.getIdentifier().getName(), (IDicomNode)string);
        }
        return null;
    }

    private synchronized boolean initTables() {
        HashMap<String, String> hashMap;
        ArrayList<ISendNode> arrayList;
        try {
            String string;
            arrayList = new ArrayList<ISendNode>();
            IConfigurationList iConfigurationList = this.provider.getList("dicomsend");
            for (IConfigurationProvider iConfigurationProvider : iConfigurationList) {
                try {
                    string = iConfigurationProvider.getString("host");
                    int n = (int)iConfigurationProvider.getLong("port");
                    String string2 = iConfigurationProvider.getString("calledAET");
                    String string3 = iConfigurationProvider.getString("description");
                    String string4 = null;
                    if (iConfigurationProvider.exists("callingAET")) {
                        string4 = iConfigurationProvider.getString("callingAET");
                    }
                    if (string4 != null && string4.length() == 0) {
                        string4 = null;
                    }
                    String string5 = null;
                    if (iConfigurationProvider.exists("commitAET")) {
                        string5 = iConfigurationProvider.getString("commitAET");
                    }
                    Integer n2 = null;
                    if (iConfigurationProvider.exists("commitPort")) {
                        n2 = (int)iConfigurationProvider.getLong("commitPort");
                    }
                    boolean bl = false;
                    if (iConfigurationProvider.exists("secure")) {
                        bl = iConfigurationProvider.getBoolean("secure");
                    }
                    boolean bl2 = false;
                    if (iConfigurationProvider.exists("close_on_each")) {
                        bl2 = iConfigurationProvider.getBoolean("close_on_each");
                    }
                    boolean bl3 = false;
                    if (iConfigurationProvider.exists("use_cmove")) {
                        bl3 = iConfigurationProvider.getBoolean("use_cmove");
                    }
                    DicomSendNode dicomSendNode = new DicomSendNode(string3, string, string2, string4, n, string5, n2, bl, bl2);
                    dicomSendNode.setUseCMove(bl3);
                    arrayList.add(dicomSendNode);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            arrayList.addAll(Base.getDataInfoNodes().stream().filter(iDataInfoNode -> "EIWADO".equals(iDataInfoNode.getType()) && iDataInfoNode.getIdentifier() instanceof ISendNode).map(iDataInfoNode -> (ISendNode)iDataInfoNode.getIdentifier()).collect(Collectors.toList()));
            hashMap = new HashMap<String, String>();
            iConfigurationList = this.provider.getList("storeMapping");
            for (IConfigurationProvider iConfigurationProvider : iConfigurationList) {
                string = iConfigurationProvider.getString("query");
                String string6 = iConfigurationProvider.getString("store");
                hashMap.put(string, string6);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Could not read Dicom Send/Store configuration", (Throwable)illegalArgumentException);
            return false;
        }
        this.mapping = hashMap;
        Collections.sort(arrayList);
        this.sendNodes = arrayList;
        return true;
    }

    @Override
    public synchronized List<ISendNode> getDicomSendNodes() {
        if (this.sendNodes == null) {
            this.initTables();
        }
        return new ArrayList<ISendNode>(this.sendNodes);
    }

    @Override
    public List<String> getSendNodesForConfig(IConfigurationProvider iConfigurationProvider) {
        IConfigurationList iConfigurationList = iConfigurationProvider.getList("listtext.service.dicomsend");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IConfigurationProvider iConfigurationProvider2 : iConfigurationList) {
            if (!iConfigurationProvider2.exists("description")) continue;
            arrayList.add(iConfigurationProvider2.getString("description"));
        }
        arrayList.addAll(Base.getDataInfoNodes().stream().filter(iDataInfoNode -> "EIWADO".equals(iDataInfoNode.getType()) && iDataInfoNode.getIdentifier() instanceof ISendNode).map(iDataInfoNode -> ((ISendNode)iDataInfoNode.getIdentifier()).getName()).collect(Collectors.toList()));
        return arrayList;
    }

    @Override
    public boolean update() {
        return this.initTables();
    }

    private class ConfigNotifier
    implements IConfigurationChangeListener {
        private ConfigNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configurationChanged(String string) {
            DicomStoreConfiguration dicomStoreConfiguration = DicomStoreConfiguration.this;
            synchronized (dicomStoreConfiguration) {
                log.debug("Configuration change detected, trying to reread the config");
                DicomStoreConfiguration.this.sendNodes = null;
                DicomStoreConfiguration.this.mapping = null;
            }
        }
    }
}

