/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.integration.dirwatcher;

import com.agfa.integration.IDesktopIntegrationListener;
import com.agfa.integration.IntegrationFrameworkFactory;
import com.agfa.integration.ext.ICommandMessage;
import com.agfa.pacs.base.dirwatcher.IDirectoryWatcher;
import com.agfa.pacs.base.dirwatcher.IDirectoryWatcherListener;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.store.ISendNode;
import com.agfa.pacs.data.shared.store.StoreProviderFactory;
import com.agfa.pacs.listtext.base.AddDataInfoToList;
import com.agfa.pacs.listtext.integration.dirwatcher.FileDataSource;
import com.agfa.pacs.listtext.lta.store.StoreUtils;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.TempDirectoryProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;

public abstract class AbstractDirectoryScanner {
    private static final ALogger log = ALogger.getLogger(AbstractDirectoryScanner.class);
    private final File dir;
    private IDirectoryWatcherListener listener;
    private Map<String, IDataInfo> importedObjects = new Hashtable<String, IDataInfo>();
    private IDirectoryWatcher.WatcherAction action;
    private ISendNode sendNode;

    public AbstractDirectoryScanner(String string, IDirectoryWatcherListener iDirectoryWatcherListener, IDirectoryWatcher.WatcherAction watcherAction, ISendNode iSendNode) {
        this.dir = new File(string);
        if (!this.dir.exists() && !this.dir.mkdirs()) {
            log.warn("couldnt create directory");
        }
        this.action = watcherAction;
        this.sendNode = iSendNode;
        this.listener = iDirectoryWatcherListener;
    }

    protected File[] getFiles() {
        File[] fileArray = this.dir.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    protected String getDirectoryPath() {
        return this.dir.getAbsolutePath();
    }

    protected void handleNewFiles(List<File> list) {
        block15: {
            ArrayList<IObjectInfo> arrayList;
            block16: {
                UIDType uIDType;
                arrayList = new ArrayList<IObjectInfo>();
                for (File object2 : list) {
                    try {
                        Object exception = null;
                        uIDType = null;
                        try (DicomInputStream dicomInputStream = new DicomInputStream(object2);){
                            dicomInputStream.setAddBulkDataReferences(true);
                            Attributes attributes = dicomInputStream.readFileMetaInformation();
                            Attributes attributes2 = dicomInputStream.readDataset(-1, -1);
                            boolean bl = this.listener.newFileFound(object2, attributes2);
                            if (!bl) continue;
                            this.listener.performTagCoercion(attributes2);
                            arrayList.addAll(this.performAction(this.action, attributes, attributes2, this.sendNode));
                            if (object2.delete()) continue;
                            log.warn("Problem deleting file " + object2);
                        }
                        catch (Throwable throwable) {
                            if (exception == null) {
                                exception = throwable;
                            } else if (exception != throwable) {
                                ((Throwable)exception).addSuppressed(throwable);
                            }
                            throw exception;
                        }
                    }
                    catch (Exception exception) {
                        log.error("Error handling new file", (Throwable)exception);
                    }
                }
                if (arrayList.isEmpty()) break block15;
                if (this.action != IDirectoryWatcher.WatcherAction.Open) break block16;
                AddDataInfoToList addDataInfoToList = new AddDataInfoToList(arrayList, IDesktopIntegrationListener.AddOption.AddTo);
                IntegrationFrameworkFactory.getInstance().queueCommand((ICommandMessage)addDataInfoToList);
                for (IObjectInfo iObjectInfo : arrayList) {
                    uIDType = UIDUtilities.getBaseType((String)iObjectInfo.getSOPClassUID());
                    if (uIDType != UIDType.StructuredReport) continue;
                    StoreProviderFactory.getInstance().getStoreProvider().store(arrayList, this.sendNode, null);
                }
                break block15;
            }
            if (this.action != IDirectoryWatcher.WatcherAction.SaveOpen) break block15;
            AddDataInfoToList addDataInfoToList = new AddDataInfoToList(arrayList, IDesktopIntegrationListener.AddOption.AddTo);
            IntegrationFrameworkFactory.getInstance().queueCommand((ICommandMessage)addDataInfoToList);
            try {
                IObjectInfo iObjectInfo;
                iObjectInfo = StoreProviderFactory.getInstance().getStoreProvider().store(arrayList, this.sendNode, null);
                iObjectInfo.waitUntilFinished();
            }
            catch (Exception exception) {
                log.error("Storing error", (Throwable)exception);
            }
        }
    }

    private List<IObjectInfo> performAction(IDirectoryWatcher.WatcherAction watcherAction, Attributes attributes, Attributes attributes2, ISendNode iSendNode) {
        try {
            UIDType uIDType = UIDUtilities.getBaseType((String)attributes2.getString(524310));
            if (uIDType != UIDType.Image) {
                watcherAction = IDirectoryWatcher.WatcherAction.Save;
            }
            switch (watcherAction) {
                case Save: {
                    StoreUtils.storeObjects((IDicomNode)iSendNode, attributes2);
                    return Collections.emptyList();
                }
                case Open: 
                case SaveOpen: {
                    File file = TempDirectoryProvider.createTemporaryFile((String)"watch", (String)"");
                    Throwable throwable = null;
                    Object var10_9 = null;
                    try (DicomOutputStream dicomOutputStream = new DicomOutputStream(file);){
                        dicomOutputStream.writeDataset(attributes, attributes2);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    file.deleteOnExit();
                    IObjectInfo iObjectInfo = FileDataSource.getDataInfo(file, attributes2, this.importedObjects, watcherAction == IDirectoryWatcher.WatcherAction.Open);
                    List list = DataInfoUtilities.getLevel((IDataInfo)iObjectInfo, IObjectInfo.class);
                    return list;
                }
            }
        }
        catch (Exception exception) {
            log.error("Could not perform default action", (Throwable)exception);
        }
        return Collections.emptyList();
    }

    protected boolean isDicom(BufferedInputStream bufferedInputStream) throws Exception {
        bufferedInputStream.mark(0);
        byte[] byArray = new byte[132];
        if (bufferedInputStream.read(byArray) < 4) {
            return false;
        }
        if ("DICM".equals(new String(byArray, 0, 4))) {
            return true;
        }
        return "DICM".equals(new String(byArray, 128, 4));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("Directory scanner on '");
        stringBuilder.append(this.dir.getAbsolutePath());
        stringBuilder.append("' performing ");
        stringBuilder.append(this.action);
        return stringBuilder.toString();
    }
}

