/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.integration.dirwatcher;

import com.agfa.pacs.base.dirwatcher.IDirectoryWatcher;
import com.agfa.pacs.base.dirwatcher.IDirectoryWatcherListener;
import com.agfa.pacs.data.shared.store.ISendNode;
import com.agfa.pacs.listtext.integration.dirwatcher.SimpleDirectoryScanner;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractDirectoryWatcher<T>
implements IDirectoryWatcher {
    public static final long SCAN_INTERVAL = 3500L;
    private static final ALogger log = ALogger.getLogger(AbstractDirectoryWatcher.class);
    protected final Map<IDirectoryWatcherListener, T> map = new LinkedHashMap<IDirectoryWatcherListener, T>();

    public synchronized void addWatcher(String string, IDirectoryWatcher.WatcherAction watcherAction, IDirectoryWatcherListener iDirectoryWatcherListener, ISendNode iSendNode) {
        new Thread(() -> {
            try {
                T t = this.createDirectoryScanner(string, watcherAction, iDirectoryWatcherListener, iSendNode);
                log.info("Added Directory watcher for directory:" + string);
                this.map.put(iDirectoryWatcherListener, t);
                this.notifyDirectoryScannerAdded(t);
            }
            catch (IOException iOException) {
                log.error("Directory watcher cannot be started for directory: " + string, (Throwable)iOException);
            }
        }, "InitDirWatcher").start();
    }

    public void scanOnce(String string, IDirectoryWatcher.WatcherAction watcherAction, IDirectoryWatcherListener iDirectoryWatcherListener, ISendNode iSendNode) {
        SimpleDirectoryScanner simpleDirectoryScanner = new SimpleDirectoryScanner(string, iDirectoryWatcherListener, watcherAction, iSendNode, false);
        simpleDirectoryScanner.performCheck(3500L);
    }

    public synchronized boolean removeWatcher(IDirectoryWatcherListener iDirectoryWatcherListener) {
        T t = this.map.remove(iDirectoryWatcherListener);
        if (t == null) {
            return false;
        }
        log.info("Remove Directory watcher for directory:" + t.toString());
        this.notifyDirectoryScannerRemoved(t);
        return true;
    }

    protected abstract T createDirectoryScanner(String var1, IDirectoryWatcher.WatcherAction var2, IDirectoryWatcherListener var3, ISendNode var4) throws IOException;

    protected abstract void notifyDirectoryScannerAdded(T var1);

    protected abstract void notifyDirectoryScannerRemoved(T var1);
}

