/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.StorageCommit;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.listtext.dicomstoragecommitment.IStorageCommitmentListener;
import com.agfa.pacs.listtext.dicomstoragecommitment.ReferencedInstance;
import com.agfa.pacs.listtext.dicomstoragecommitment.StorageCommitmentHandler;
import com.agfa.pacs.listtext.dicomstoragecommitment.StorageCommitmentManager;
import com.agfa.pacs.listtext.dicomstoragecommitment.StorageCommitmentRequest;
import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class StorageCommitment {
    protected static final ALogger log = ALogger.getLogger(StorageCommitment.class);
    private static final StorageCommitment instance = new StorageCommitment();
    private List<AbstractStorageCommitHandler> openTransaction = new Vector<AbstractStorageCommitHandler>();

    public static StorageCommitment getInstance() {
        return instance;
    }

    private StorageCommitment() {
    }

    public void checkStorageCommit(AbstractStorageCommitHandler abstractStorageCommitHandler) {
        this.openTransaction.add(abstractStorageCommitHandler);
        abstractStorageCommitHandler.run();
    }

    protected List<String> getOpenTransactions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            try {
                arrayList.clear();
                for (AbstractStorageCommitHandler abstractStorageCommitHandler : this.openTransaction) {
                    arrayList.add(abstractStorageCommitHandler.toString());
                }
            }
            catch (RuntimeException runtimeException) {
                continue;
            }
            break;
        }
        return arrayList;
    }

    public static void showCommitFailed(String string) {
        String string2 = String.valueOf(Messages.getString("StorageCommitment.StorageCommitmentFailedTitle")) + "\n " + string;
        if (Product.isHeadless()) {
            log.warn(string2);
        } else {
            JOptionPane.showMessageDialog(null, string2, Messages.getString("StorageCommitment.StorageCommitmentFailed"), 0);
        }
    }

    public static abstract class AbstractStorageCommitHandler
    implements Runnable,
    IStorageCommitmentListener {
        protected List<ReferencedInstance> objs = new ArrayList<ReferencedInstance>();
        protected IDicomNode commitNode;
        private String name;
        protected StorageCommitment stcommit;

        public AbstractStorageCommitHandler(String string, List<ReferencedInstance> list, IDicomNode iDicomNode, StorageCommitment storageCommitment) {
            this.name = String.valueOf(string) + " " + DateTimeUtils.dateTime2String((Date)new Date());
            this.objs = list;
            this.commitNode = iDicomNode;
            this.stcommit = storageCommitment;
        }

        @Override
        public void run() {
            StorageCommitmentRequest storageCommitmentRequest = new StorageCommitmentRequest();
            storageCommitmentRequest.referencedInstances().addAll(this.objs);
            try {
                StorageCommitmentHandler storageCommitmentHandler = StorageCommitmentManager.getInstance().createStorageCommitmentHandler(storageCommitmentRequest);
                storageCommitmentHandler.addListener((IStorageCommitmentListener)this);
                storageCommitmentHandler.requestCommit(this.commitNode);
            }
            catch (DicomException dicomException) {
                log.error("Dicom error on commit", (Throwable)dicomException);
                this.failure();
                return;
            }
        }

        public void resultAvailable(StorageCommitmentHandler storageCommitmentHandler) {
            boolean bl;
            boolean bl2 = bl = storageCommitmentHandler.getResultStatus() == 1;
            if (!bl) {
                this.failureImpl();
            } else {
                this.successImpl();
            }
        }

        public String toString() {
            return String.valueOf(Messages.getString("StorageCommitment.Transaction")) + " " + this.name + Messages.getString("StorageCommitment.with") + this.objs.size() + Messages.getString("StorageCommitment.NumberOfDicomSendObj");
        }

        private void failureImpl() {
            try {
                try {
                    log.error("STORAGE COMMITMENT[FAILURE] " + this.toString());
                    this.failure();
                }
                catch (Exception exception) {
                    log.error("Storage commit handling failed", (Throwable)exception);
                    this.stcommit.openTransaction.remove(this);
                    this.commitNode = null;
                    this.objs.clear();
                    this.objs = null;
                }
            }
            finally {
                this.stcommit.openTransaction.remove(this);
                this.commitNode = null;
                this.objs.clear();
                this.objs = null;
            }
        }

        private void successImpl() {
            try {
                try {
                    log.info("STORAGE COMMITMENT[SUCCESS] " + this.toString());
                    this.success();
                }
                catch (Exception exception) {
                    log.error("Storage commit handling failed", (Throwable)exception);
                    this.stcommit.openTransaction.remove(this);
                    this.commitNode = null;
                    this.objs.clear();
                    this.objs = null;
                }
            }
            finally {
                this.stcommit.openTransaction.remove(this);
                this.commitNode = null;
                this.objs.clear();
                this.objs = null;
            }
        }

        protected abstract void failure();

        protected abstract void success();
    }
}

