/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.StorageCommit;

import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.ListenerSynchronizationFactory;
import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.listtext.lta.StorageCommit.StorageCommitment;
import java.util.List;
import javax.swing.JOptionPane;

public class StorageShutdownHook
implements IEventListener {
    private boolean wasShutdown = false;
    private IListenerSynchronization sync = ListenerSynchronizationFactory.getInstance();

    public IListenerSynchronization getSync() {
        return this.sync;
    }

    public boolean handleEvent(IEvent iEvent) {
        if (iEvent.getEventID() == ApplicationManagement.APP_PREPARE_SHUTDOWN) {
            if (this.wasShutdown) {
                return false;
            }
            List<String> list = StorageCommitment.getInstance().getOpenTransactions();
            this.wasShutdown = true;
            if (list.size() > 0) {
                StorageCommitment.log.error("ON SHUTDOWN " + list.size() + " COMMIT TRANSACTION");
                StringBuilder stringBuilder = new StringBuilder(Messages.getString("StorageShutdownHook.OpenTransactions"));
                for (String string : list) {
                    StorageCommitment.log.error("OPEN COMMIT FOR " + string);
                    stringBuilder.append('\n').append(string);
                }
                JOptionPane.showMessageDialog(null, stringBuilder, Messages.getString("StorageShutdownHook.OpenCommitmentTitle"), 2);
            } else {
                StorageCommitment.log.info("No open Commitment transactions open");
            }
        }
        return false;
    }
}

