/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.datafinder;

import com.agfa.pacs.listtext.lta.datafinder.DataFinderFactory;
import com.agfa.pacs.listtext.lta.datafinder.IDataFinder;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class DataFinderFactoryEclipseImpl
extends DataFinderFactory {
    private Collection<IDataFinder> finders = new TreeSet<IDataFinder>(new DataFinderComparator());

    public DataFinderFactoryEclipseImpl() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.listtext.integration.DataFinder");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
                throw new IllegalStateException("No data finder implementation found");
            }
            try {
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n4];
                    IDataFinder iDataFinder = (IDataFinder)iConfigurationElement.createExecutableExtension("class");
                    this.finders.add(iDataFinder);
                    ++n4;
                }
            }
            catch (CoreException coreException) {
                ALogger.getLogger((String)"Factory").error("DataFinder instantiation failed!", (Throwable)coreException);
            }
            ++n2;
        }
    }

    @Override
    protected List<IDataFinder> getDataFindersInt() {
        return new ArrayList<IDataFinder>(this.finders);
    }

    private static class DataFinderComparator
    implements Comparator<IDataFinder> {
        private DataFinderComparator() {
        }

        @Override
        public int compare(IDataFinder iDataFinder, IDataFinder iDataFinder2) {
            return Integer.compare(iDataFinder2.getPriority(), iDataFinder.getPriority());
        }
    }
}

