/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.deletion;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.store.StoreUtils;
import com.agfa.pacs.listtext.lta.util.referencedobject.KeyObjectAttributes;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class DeletionUtils {
    private DeletionUtils() {
    }

    public static boolean deleteStudy(IStudyInfo iStudyInfo) {
        boolean bl = DeletionUtils.deleteData(DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, IObjectInfo.class));
        if (bl) {
            Audit.getInstance().logStudiesDeleted(DataInfoUtilities.forAuditing(Collections.singletonList(iStudyInfo)));
        }
        return bl;
    }

    public static boolean deleteSeries(ISeriesInfo iSeriesInfo) {
        return DeletionUtils.deleteInstances(DataInfoUtilities.getLevel((IDataInfo)iSeriesInfo, IObjectInfo.class));
    }

    public static boolean deleteInstances(List<IObjectInfo> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        boolean bl = DeletionUtils.deleteData(list);
        if (bl) {
            Audit.getInstance().logInstancesDeleted(DataInfoUtilities.forAuditing(list));
        }
        return bl;
    }

    public static boolean deleteInstance(IStudyInfo iStudyInfo, IDataInfoSource iDataInfoSource, String string, String string2, String string3) {
        boolean bl = StoreUtils.storeObjects(iDataInfoSource, DeletionUtils.compileDeletionKeyObject(iStudyInfo, string, string2, string3));
        if (bl) {
            Audit.getInstance().logInstancesDeleted(DataInfoUtilities.forAuditing(Collections.singletonList(iStudyInfo)));
        }
        return bl;
    }

    private static boolean deleteData(List<IObjectInfo> list) {
        return StoreUtils.storeObjects(list.get(0).getSource(), DeletionUtils.compileDeletionKeyObject(list));
    }

    private static Attributes compileDeletionKeyObject(List<IObjectInfo> list) {
        KeyObjectAttributes keyObjectAttributes = new KeyObjectAttributes(ReferringObjectType.REJECTED_FOR_QUALITY_REASONS, list.get(0).getSeries().getStudy());
        for (IObjectInfo iObjectInfo : list) {
            keyObjectAttributes.insertReference(iObjectInfo.getSOPClassUID(), iObjectInfo.getSOPInstanceUID(), iObjectInfo.getSeriesUID(), iObjectInfo.getStudyUID(), null);
        }
        return keyObjectAttributes.toDataset();
    }

    private static Attributes compileDeletionKeyObject(IStudyInfo iStudyInfo, String string, String string2, String string3) {
        KeyObjectAttributes keyObjectAttributes = new KeyObjectAttributes(ReferringObjectType.REJECTED_FOR_QUALITY_REASONS, iStudyInfo);
        keyObjectAttributes.insertReference(string3, string2, string, iStudyInfo.getStudyUID(), null);
        return keyObjectAttributes.toDataset();
    }
}

