/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter;

import com.agfa.pacs.data.shared.filter.FilterModifiers;
import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.listtext.lta.filter.AbstractFilterEntryType;
import com.agfa.pacs.listtext.lta.filter.FilterSelectionSets;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IFilterEntry;
import com.agfa.pacs.listtext.lta.filter.IFilterEntryType;
import com.agfa.pacs.listtext.lta.filter.advanced.IClientSideFilterEntryType;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.DateUtils;

public class FilterEntryTypes {
    private static final ALogger log = ALogger.getLogger(FilterEntryTypes.class);
    public static final IFilterEntryType instanceEquals = new Equals();
    public static final IFilterEntryType instanceEqualsIgnoreCase = new EqualsIgnoreCase();
    public static final IFilterEntryType instanceStartsWith = new StartsWith();
    public static final IFilterEntryType instanceEndsWith = new EndsWith();
    public static final IFilterEntryType instanceStartsWithIgnoreCase = new StartsWithIgnoreCase();
    public static final IFilterEntryType instanceEndsWithIgnoreCase = new EndsWithIgnoreCase();
    public static final IFilterEntryType instanceContains = new Contains();
    public static final IFilterEntryType instanceContainsIgnoreCase = new ContainsIgnoreCase();
    public static final IFilterEntryType instanceRange = new Range();
    public static final IFilterEntryType instanceNamed = new Named();
    public static final IFilterEntryType instanceToday = new Today();
    public static final IFilterEntryType instanceDaysOld = new DaysOld();
    public static final IFilterEntryType instancePhonetics = new Phonetics();
    public static final IFilterEntryType instanceIdeographics = new Ideographics();
    public static final IFilterEntryType instanceOlderThen = new MoreThenYearsOld();
    public static final IFilterEntryType instanceYoungerThen = new LessThenYearsOld();
    public static final IFilterEntryType instanceCodeEquals = new CodeEquals();
    public static final IFilterEntryType instanceCallingAETEquals = new CallingAETEquals();
    public static final IFilterEntryType instanceMultiEqualsIgnoreCase = new MultiEqualsIgnoreCase();
    public static final IFilterEntryType instanceDateTimeRange = new DateTimeRange();
    public static final IFilterEntryType instanceDicomStatusEquals = new DicomStatusEquals();
    public static final IFilterEntryType instanceYesterdayTodayTime = new YesterdayTodayTime();
    public static final IFilterEntryType instanceLastXHoursTime = new HoursOld();
    public static final IFilterEntryType instanceYesterdayTime = new YesterdayTime();
    public static final IFilterEntryType instanceTodayTime = new TodayTime();
    public static final IFilterEntryType instanceNDayTime = new NDayTime();
    public static final IFilterEntryType instanceUntilPreviousScheduledDate = new UntilPreviousScheduledDate();
    public static final IFilterEntryType instanceKeywordSearch = new KeywordSearch();
    public static final List<IFilterEntryType> types = Arrays.asList(instanceEquals, instanceStartsWith, instanceStartsWithIgnoreCase, instanceEndsWith, instanceEndsWithIgnoreCase, instanceContains, instanceContainsIgnoreCase, instanceRange, instanceNamed, instanceToday, instanceDaysOld, instanceIdeographics, instancePhonetics, instanceOlderThen, instanceYoungerThen, instanceCodeEquals, instanceMultiEqualsIgnoreCase, instanceDateTimeRange, instanceDicomStatusEquals, instanceYesterdayTime, instanceYesterdayTodayTime, instanceLastXHoursTime, instanceTodayTime, instanceEqualsIgnoreCase, instanceNDayTime, instanceUntilPreviousScheduledDate, instanceCallingAETEquals, instanceKeywordSearch);
    private static final List<IFilterEntryType> standardStringTypes = Arrays.asList(instanceNamed, instanceEquals, instanceEqualsIgnoreCase, instanceStartsWith, instanceStartsWithIgnoreCase, instanceEndsWith, instanceEndsWithIgnoreCase, instanceContains, instanceContainsIgnoreCase);

    public static boolean isInStandardStringGroup(IFilterEntryType iFilterEntryType) {
        return standardStringTypes.contains(iFilterEntryType);
    }

    private static String dateToDicomDate(Date date) {
        return DateUtils.formatDA(null, (Date)date);
    }

    private static class CallingAETEquals
    extends Equals
    implements IClientSideFilterEntryType {
        private CallingAETEquals() {
            super(null, null);
        }

        @Override
        public void modifyDataset(IFilterEntry iFilterEntry, Attributes attributes, FilterModifiers filterModifiers) {
            String string = iFilterEntry.getSearchStrings()[0];
            String[] stringArray = attributes.getStrings("dcm4che/archive", 4390932);
            if (stringArray != null && stringArray.length > 0 && this.isORMatchEnabled(filterModifiers)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(stringArray));
                arrayList.add(string);
                StringBuilder stringBuilder = new StringBuilder();
                Iterator iterator = arrayList.iterator();
                stringBuilder.append((String)iterator.next());
                while (iterator.hasNext()) {
                    stringBuilder.append("\\").append((String)iterator.next());
                }
                string = stringBuilder.toString();
            }
            attributes.setString("dcm4che/archive", 4390932, VR.AE, string);
        }

        @Override
        public String getCode() {
            return "src_aet_equals";
        }
    }

    private static class CodeEquals
    extends AbstractFilterEntryType {
        private CodeEquals() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.CodeIs");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            throw new IllegalArgumentException("Not supported");
        }

        @Override
        public String getCode() {
            return "code_equals";
        }
    }

    protected static class Contains
    extends AbstractFilterEntryType {
        protected Contains() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Contains");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray == null || stringArray.length == 0) {
                return "*";
            }
            if (stringArray[0].equals("*")) {
                return stringArray[0];
            }
            return "*" + stringArray[0] + "*";
        }

        @Override
        public String getCode() {
            return "contains";
        }
    }

    protected static class ContainsIgnoreCase
    extends AbstractFilterEntryType {
        protected ContainsIgnoreCase() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Contains");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray == null || stringArray.length == 0) {
                return "*";
            }
            return "*" + stringArray[0].toUpperCase(Locale.getDefault()) + "*";
        }

        @Override
        public String getCode() {
            return "contains_ignore_case";
        }
    }

    private static class DateTimeRange
    implements IFilterEntryType {
        private DateTimeRange() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.DateTimeRange");
        }

        @Override
        public boolean supportsORMatch() {
            return false;
        }

        @Override
        public String getCode() {
            return "date_time_range";
        }

        @Override
        public void modifyDataset(IFilterEntry iFilterEntry, Attributes attributes, FilterModifiers filterModifiers) {
            String[] stringArray = iFilterEntry.getSearchStrings();
            if (stringArray == null || stringArray.length <= 1) {
                return;
            }
            TimeZone timeZone = null;
            Date date = DateUtils.parseDT(timeZone, (String)stringArray[0], (boolean)false, (DatePrecision)new DatePrecision());
            Date date2 = DateUtils.parseDT(timeZone, (String)stringArray[1], (boolean)false, (DatePrecision)new DatePrecision());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date2);
            calendar2.set(13, 59);
            calendar2.set(14, 999);
            String string = DateUtils.formatDA(timeZone, (Date)calendar.getTime());
            String string2 = DateUtils.formatDA(timeZone, (Date)calendar2.getTime());
            String string3 = DateUtils.formatTM(timeZone, (Date)calendar.getTime());
            String string4 = DateUtils.formatTM(timeZone, (Date)calendar2.getTime());
            int n = 524320;
            int n2 = 524336;
            if (iFilterEntry.getCriterion().getTag() == 4194885) {
                n = 0x400244;
                n2 = 4194885;
            } else if (iFilterEntry.getCriterion().getTag() == 4194897) {
                n = 4194896;
                n2 = 4194897;
            }
            FilterUtilities.putValue((Object)(String.valueOf(string) + "-" + string2), n, attributes);
            FilterUtilities.putValue((Object)(String.valueOf(string3) + "-" + string4), n2, attributes);
        }
    }

    private static class DaysOld
    extends AbstractFilterEntryType {
        private DaysOld() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.MaximumDaysOld");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            Date date;
            Date date2 = date = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (date == null) {
                date = new Date();
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            Integer n = stringArray == null || stringArray.length == 0 ? Integer.valueOf(0) : Integer.parseInt(stringArray[0]);
            gregorianCalendar.add(5, -n.intValue());
            return String.valueOf(FilterEntryTypes.dateToDicomDate(gregorianCalendar.getTime())) + "-" + FilterEntryTypes.dateToDicomDate(date);
        }

        @Override
        public String getCode() {
            return "days_old";
        }
    }

    private static class DicomStatusEquals
    implements IClientSideFilterEntryType {
        private DicomStatusEquals() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Is");
        }

        @Override
        public boolean supportsORMatch() {
            return false;
        }

        @Override
        public void modifyDataset(IFilterEntry iFilterEntry, Attributes attributes, FilterModifiers filterModifiers) {
            String string = iFilterEntry.getSearchStrings()[0];
            if (string != null && string.length() > 0 && !string.equalsIgnoreCase(FilterSelectionSets.StudyStatusSelectionSet.UNREPORTED_ITEM.getValue())) {
                attributes.setString(3276810, VR.CS, iFilterEntry.getSearchStrings()[0]);
            }
        }

        @Override
        public String getCode() {
            return "dicom_status_equals";
        }
    }

    private static class EndsWith
    extends AbstractFilterEntryType {
        private EndsWith() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.EndsWith");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray == null || stringArray.length == 0) {
                return "*";
            }
            return "*" + stringArray[0];
        }

        @Override
        public String getCode() {
            return "end_with";
        }
    }

    private static class EndsWithIgnoreCase
    extends AbstractFilterEntryType {
        private EndsWithIgnoreCase() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.EndsWith");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray == null || stringArray.length == 0) {
                return "*";
            }
            return "*" + stringArray[0].toUpperCase(Locale.getDefault());
        }

        @Override
        public String getCode() {
            return "end_with_ignore_case";
        }
    }

    private static class Equals
    extends AbstractFilterEntryType {
        private Equals() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Is");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray == null || stringArray.length == 0) {
                return "*";
            }
            if (stringArray.length == 1) {
                return stringArray[0];
            }
            StringBuilder stringBuilder = new StringBuilder(stringArray[0].length() * stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                stringBuilder.append(stringArray[n]).append('\\');
                ++n;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }

        @Override
        public boolean supportsORMatch() {
            return true;
        }

        @Override
        public String getCode() {
            return "equals";
        }

        /* synthetic */ Equals(Equals equals, Equals equals2) {
            this();
        }
    }

    private static class EqualsIgnoreCase
    extends AbstractFilterEntryType {
        private EqualsIgnoreCase() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Is");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray == null || stringArray.length == 0) {
                return "*";
            }
            return stringArray[0].toUpperCase(Locale.getDefault());
        }

        @Override
        public boolean supportsORMatch() {
            return true;
        }

        @Override
        public String getCode() {
            return "equalsIgnoreCase";
        }
    }

    private static class HoursOld
    implements IFilterEntryType {
        private HoursOld() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.LastXHours");
        }

        @Override
        public void modifyDataset(IFilterEntry iFilterEntry, Attributes attributes, FilterModifiers filterModifiers) {
            Date date;
            String[] stringArray = iFilterEntry.getSearchStrings();
            Integer n = stringArray == null || stringArray.length != 1 ? 1 : Integer.parseInt(stringArray[0].trim());
            Date date2 = date = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (date == null) {
                date = new Date();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(11, -n.intValue());
            String string = DateUtils.formatDA(null, (Date)calendar.getTime());
            String string2 = DateUtils.formatDA(null, (Date)date);
            String string3 = DateUtils.formatTM(null, (Date)calendar.getTime());
            String string4 = DateUtils.formatTM(null, (Date)date);
            FilterUtilities.putValue((Object)(String.valueOf(string) + '-' + string2), 524320, attributes);
            FilterUtilities.putValue((Object)(String.valueOf(string3) + '-' + string4), 524336, attributes);
        }

        @Override
        public String getCode() {
            return "last_x_hours";
        }

        @Override
        public boolean supportsORMatch() {
            return false;
        }
    }

    protected static class Ideographics
    extends AbstractFilterEntryType {
        protected Ideographics() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Ideographics");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            String string = null;
            if (stringArray.length == 1) {
                string = "*=" + stringArray[0];
            }
            if (stringArray.length >= 2) {
                string = "*=" + stringArray[0] + "^" + stringArray[1];
            }
            log.info("Ideographics search for:" + string);
            return string;
        }

        @Override
        public String getCode() {
            return "ideographics";
        }
    }

    protected static class KeywordSearch
    extends ContainsIgnoreCase
    implements IClientSideFilterEntryType {
        protected KeywordSearch() {
        }

        @Override
        public String getCode() {
            return "keyword";
        }
    }

    private static class LessThenYearsOld
    extends AbstractFilterEntryType {
        private LessThenYearsOld() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.YoungerThen");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            Date date;
            Date date2 = date = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (date == null) {
                date = new Date();
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            Integer n = stringArray == null || stringArray.length == 0 ? Integer.valueOf(0) : Integer.parseInt(stringArray[0]);
            gregorianCalendar.add(1, -n.intValue());
            return String.valueOf(FilterEntryTypes.dateToDicomDate(gregorianCalendar.getTime())) + "-" + FilterEntryTypes.dateToDicomDate(date);
        }

        @Override
        public String getCode() {
            return "max_years_old";
        }
    }

    private static class MoreThenYearsOld
    extends AbstractFilterEntryType {
        private MoreThenYearsOld() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.OlderThen");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            Date date;
            Date date2 = date = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (date == null) {
                date = new Date();
            }
            Integer n = stringArray == null || stringArray.length == 0 ? Integer.valueOf(0) : Integer.parseInt(stringArray[0]);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(1, -n.intValue());
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date);
            calendar2.set(1, 1800);
            return String.valueOf(FilterEntryTypes.dateToDicomDate(calendar2.getTime())) + "-" + FilterEntryTypes.dateToDicomDate(calendar.getTime());
        }

        @Override
        public String getCode() {
            return "min_years_old";
        }
    }

    private static class MultiEqualsIgnoreCase
    extends AbstractFilterEntryType {
        private MultiEqualsIgnoreCase() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Is");
        }

        @Override
        public Object convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            String[] stringArray2 = new String[]{"*"};
            if (stringArray != null && stringArray.length > 0) {
                stringArray2 = stringArray[0].toUpperCase(Locale.getDefault()).split(",");
            }
            if (!this.isORMatchEnabled(filterModifiers) || stringArray2.length == 0) {
                return stringArray2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = Arrays.asList(stringArray2).iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append("\\").append(iterator.next());
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean supportsORMatch() {
            return true;
        }

        @Override
        public String getCode() {
            return "multi_equals_ignore_case";
        }
    }

    private static class NDayTime
    implements IFilterEntryType {
        protected Integer dayEnd = 0;
        protected Integer daysStart = null;

        private NDayTime() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterEntryTypes.NDaysBefore");
        }

        @Override
        public String getCode() {
            return "nday_time";
        }

        @Override
        public boolean supportsORMatch() {
            return false;
        }

        @Override
        public void modifyDataset(IFilterEntry iFilterEntry, Attributes attributes, FilterModifiers filterModifiers) {
            Date date;
            String[] stringArray = iFilterEntry.getSearchStrings();
            if (stringArray == null || stringArray.length <= 1) {
                return;
            }
            if (stringArray.length == 3) {
                this.daysStart = Integer.parseInt(stringArray[2]);
            }
            Date date2 = date = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (date == null) {
                date = new Date();
            }
            TimeZone timeZone = null;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(DateUtils.parseDT(timeZone, (String)stringArray[0], (boolean)false, (DatePrecision)new DatePrecision()));
            calendar.set(13, 0);
            calendar.set(14, 0);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(DateUtils.parseDT(timeZone, (String)stringArray[1], (boolean)false, (DatePrecision)new DatePrecision()));
            calendar2.set(13, 59);
            calendar2.set(14, 999);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.setTime(date);
            if (this.daysStart != 0) {
                calendar3.add(6, -this.daysStart.intValue());
            }
            Calendar calendar4 = Calendar.getInstance();
            calendar4.setTime(date);
            if (this.dayEnd != 0) {
                calendar4.add(6, -this.dayEnd.intValue());
            }
            String string = DateUtils.formatDA(timeZone, (Date)calendar3.getTime());
            String string2 = DateUtils.formatDA(timeZone, (Date)calendar4.getTime());
            String string3 = DateUtils.formatTM(timeZone, (Date)calendar.getTime());
            String string4 = DateUtils.formatTM(timeZone, (Date)calendar2.getTime());
            FilterUtilities.putValue((Object)(String.valueOf(string) + '-' + string2), 524320, attributes);
            FilterUtilities.putValue((Object)(String.valueOf(string3) + '-' + string4), 524336, attributes);
        }

        /* synthetic */ NDayTime(NDayTime nDayTime, NDayTime nDayTime2) {
            this();
        }
    }

    protected static class Named
    extends AbstractFilterEntryType {
        protected Named() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.IsCalled");
        }

        private String createFilter(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                return "*";
            }
            if (stringArray[0] != null && !stringArray[0].endsWith("*")) {
                stringArray[0] = String.valueOf(stringArray[0]) + "*";
            }
            if (stringArray.length > 1 && stringArray[1] != null && !stringArray[1].endsWith("*")) {
                stringArray[1] = String.valueOf(stringArray[1]) + "*";
            }
            if (stringArray.length == 1) {
                return stringArray[0];
            }
            if (stringArray.length == 2 && stringArray[1] != null && stringArray[1].equals("*")) {
                return stringArray[0];
            }
            if (stringArray.length >= 2) {
                if (stringArray[1] == null || stringArray[1].length() == 0) {
                    return stringArray[0];
                }
                if (stringArray[0].length() == 0) {
                    return stringArray[1];
                }
                return String.valueOf(stringArray[0]) + "^" + stringArray[1];
            }
            return "*";
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            return this.createFilter(stringArray);
        }

        @Override
        public String getCode() {
            return "named";
        }

        @Override
        public boolean supportsORMatch() {
            return true;
        }
    }

    protected static class Phonetics
    extends AbstractFilterEntryType {
        protected Phonetics() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Phonetics");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            String string = null;
            if (stringArray.length == 1) {
                string = "*=*=" + stringArray[0];
            }
            if (stringArray.length >= 2) {
                string = "*=*=" + stringArray[0] + "^" + stringArray[1];
            }
            log.info("Ideographics search for:" + string);
            return string;
        }

        @Override
        public String getCode() {
            return "phonetics";
        }
    }

    private static class Range
    extends AbstractFilterEntryType {
        private Range() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.InRange");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray == null || stringArray.length <= 1) {
                return "*";
            }
            try {
                TimeZone timeZone = null;
                Date date = DateUtils.parseDT(timeZone, (String)stringArray[0], (boolean)false, (DatePrecision)new DatePrecision());
                Date date2 = DateUtils.parseDT(timeZone, (String)stringArray[1], (boolean)false, (DatePrecision)new DatePrecision());
                if (date.before(date2)) {
                    return Range.getSearchString(stringArray[0], stringArray[1]);
                }
                return Range.getSearchString(stringArray[1], stringArray[0]);
            }
            catch (Exception exception) {
                return Range.getSearchString(stringArray[0], stringArray[1]);
            }
        }

        private static String getSearchString(String string, String string2) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append('-');
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }

        @Override
        public String getCode() {
            return "range";
        }
    }

    private static class StartsWith
    extends AbstractFilterEntryType {
        private StartsWith() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.StartsWith");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray == null || stringArray.length == 0) {
                return "*";
            }
            return String.valueOf(stringArray[0]) + "*";
        }

        @Override
        public String getCode() {
            return "starts_with";
        }
    }

    private static class StartsWithIgnoreCase
    extends AbstractFilterEntryType {
        private StartsWithIgnoreCase() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.StartsWith");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray == null || stringArray.length == 0) {
                return "*";
            }
            return String.valueOf(stringArray[0].toUpperCase(Locale.getDefault())) + "*";
        }

        @Override
        public String getCode() {
            return "starts_with_ignore_case";
        }
    }

    private static class Today
    extends AbstractFilterEntryType {
        private Today() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Today");
        }

        @Override
        public String convertToDicom(String[] stringArray, FilterModifiers filterModifiers) {
            Date date;
            Date date2 = date = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (date == null) {
                date = new Date();
            }
            return FilterEntryTypes.dateToDicomDate(date);
        }

        @Override
        public String getCode() {
            return "today";
        }
    }

    private static class TodayTime
    extends NDayTime {
        public TodayTime() {
            super(null, null);
            this.daysStart = 0;
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Today");
        }

        @Override
        public String getCode() {
            return "today_time";
        }
    }

    private static class UntilPreviousScheduledDate
    implements IFilterEntryType {
        private UntilPreviousScheduledDate() {
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.UntilPreviousScheduledDate");
        }

        @Override
        public String getCode() {
            return "previous_scheduled_date";
        }

        @Override
        public boolean supportsORMatch() {
            return false;
        }

        @Override
        public void modifyDataset(IFilterEntry iFilterEntry, Attributes attributes, FilterModifiers filterModifiers) {
            Date date;
            Date date2;
            Date date3 = date2 = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (date2 == null) {
                date2 = new Date();
            }
            Date date4 = date = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.PreviousDemoDate) : null;
            if (date == null) {
                date = new Date();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date2);
            TimeZone timeZone = null;
            String string = DateUtils.formatDA(timeZone, (Date)calendar.getTime());
            String string2 = DateUtils.formatDA(timeZone, (Date)calendar2.getTime());
            String string3 = DateUtils.formatTM(timeZone, (Date)calendar.getTime());
            String string4 = DateUtils.formatTM(timeZone, (Date)calendar.getTime());
            FilterUtilities.putValue((Object)(String.valueOf(string) + "-" + string2), 524320, attributes);
            FilterUtilities.putValue((Object)(String.valueOf(string3) + "-" + string4), 524336, attributes);
        }
    }

    private static class YesterdayTime
    extends NDayTime {
        public YesterdayTime() {
            super(null, null);
            this.dayEnd = 1;
            this.daysStart = 1;
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Yesterday");
        }

        @Override
        public String getCode() {
            return "yesterday_time";
        }
    }

    private static class YesterdayTodayTime
    extends NDayTime {
        public YesterdayTodayTime() {
            super(null, null);
            this.daysStart = 1;
        }

        @Override
        public String toString() {
            return Messages.getString("FilterTypes.Yesterday-Today");
        }

        @Override
        public String getCode() {
            return "yesterday_today_time";
        }
    }
}

