/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter;

import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.search.ISearchHandler;
import com.agfa.pacs.listtext.lta.search.ISearchThread;
import com.agfa.pacs.listtext.lta.search.SearchHandler;
import com.agfa.pacs.listtext.lta.search.SearchHandlerListener;
import com.agfa.pacs.listtext.lta.search.SearchThread;
import com.agfa.pacs.logging.ALogger;
import java.util.List;

public class FilterHelper {
    private static final ALogger log = ALogger.getLogger(FilterHelper.class);

    public static void performSyncSearch(IFilter iFilter, IDataInfoSource iDataInfoSource, SearchHandlerListener searchHandlerListener) {
        SearchHandler searchHandler = new SearchHandler();
        searchHandler.addDataInfoSource(iDataInfoSource);
        searchHandler.search(iFilter, searchHandlerListener, false);
    }

    public static IDataInfo performSyncSearch(IPersistantFilter iPersistantFilter, IDataInfoSource iDataInfoSource) {
        SearchHandler searchHandler = new SearchHandler();
        searchHandler.addDataInfoSource(iDataInfoSource);
        MySearchListener mySearchListener = new MySearchListener();
        searchHandler.search(iPersistantFilter, mySearchListener, false);
        return mySearchListener.getRoot();
    }

    public static IDataInfo performSyncSearch(IPersistantFilter iPersistantFilter, List<? extends IDataInfoSource> list) {
        SearchHandler searchHandler = new SearchHandler();
        for (IDataInfoSource object2 : list) {
            searchHandler.addDataInfoSource(object2);
        }
        MySearchListener mySearchListener = new MySearchListener();
        SearchThread searchThread = new SearchThread(searchHandler, list, iPersistantFilter, mySearchListener, "DesktopIntegration");
        searchThread.run();
        return searchThread.getResult();
    }

    private static class MySearchListener
    implements SearchHandlerListener {
        private IDataInfo root = null;

        private MySearchListener() {
        }

        public IDataInfo getRoot() {
            return this.root;
        }

        @Override
        public void searchFailure(ISearchHandler iSearchHandler, ISearchThread iSearchThread, IDataInfoSource iDataInfoSource, Throwable throwable) {
            log.error("Filter search failed", throwable);
        }

        @Override
        public void searchFinished(ISearchHandler iSearchHandler, ISearchThread iSearchThread) {
        }

        @Override
        public void searchStarted(ISearchHandler iSearchHandler, ISearchThread iSearchThread) {
        }

        @Override
        public void searchSuccess(ISearchHandler iSearchHandler, ISearchThread iSearchThread, IDataInfoSource iDataInfoSource, IDataInfo iDataInfo) {
            this.root = iDataInfo;
        }
    }
}

