/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter;

import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.listtext.lta.filter.IFilterSelectionSet;
import com.agfa.pacs.listtext.lta.filter.IFilterSelectionSetItem;
import com.agfa.pacs.listtext.lta.util.DicomStudyStatus;
import com.agfa.pacs.listtext.lta.util.Modality;

public class FilterSelectionSets {
    public static final IFilterSelectionSet MODALITY_SELECTION_SET = FilterSelectionSets.createSelectionSet(Modality.valuesConfigured().toArray(new Modality[0]));
    public static final IFilterSelectionSet PATIENT_SEX_SELECTION_SET = new PatientSexSelectionSet();
    public static final StudyStatusSelectionSet STUDY_STATUS_SELECTION_SET = new StudyStatusSelectionSet();
    public static final YesNoSelectionSet YES_NO_SELECTION_SET = new YesNoSelectionSet();
    public static final ClinicalTrialSeriesDescriptionSelectionSet CLINICAL_TRIAL_SERIES_DECRIPTION_SELECTION_SET = new ClinicalTrialSeriesDescriptionSelectionSet();

    public static IFilterSelectionSet createSelectionSet(final IFilterSelectionSetItem[] iFilterSelectionSetItemArray) {
        if (iFilterSelectionSetItemArray != null) {
            return new IFilterSelectionSet(){

                @Override
                public IFilterSelectionSetItem[] getSelectionItems() {
                    return iFilterSelectionSetItemArray;
                }
            };
        }
        return null;
    }

    public static IFilterSelectionSet createSelectionSet(Object[] objectArray) {
        if (objectArray != null) {
            IFilterSelectionSetItem[] iFilterSelectionSetItemArray = new IFilterSelectionSetItem[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                final String string = objectArray[n].toString();
                iFilterSelectionSetItemArray[n] = new IFilterSelectionSetItem(){

                    @Override
                    public String toString() {
                        return string;
                    }

                    @Override
                    public String getValue() {
                        return string;
                    }

                    @Override
                    public boolean isMyCode(Object object) {
                        return string.equals(object);
                    }
                };
                ++n;
            }
            return FilterSelectionSets.createSelectionSet(iFilterSelectionSetItemArray);
        }
        return null;
    }

    public static final class ClinicalTrialSeriesDescriptionSelectionSet
    implements IFilterSelectionSet {
        public static final IFilterSelectionSetItem EMPTY_ITEM = new IFilterSelectionSetItem(){

            @Override
            public boolean isMyCode(Object object) {
                return object instanceof String && this.getValue().equalsIgnoreCase((String)object);
            }

            @Override
            public String getValue() {
                return "";
            }

            @Override
            public String toString() {
                return Messages.getString("FilterSelectionSet.ClinicalTrialSeriesDescription.Empty");
            }
        };
        public static final IFilterSelectionSetItem CLINICAL_TRIAL_ITEM = new IFilterSelectionSetItem(){

            @Override
            public boolean isMyCode(Object object) {
                return object instanceof String && this.getValue().equalsIgnoreCase((String)object);
            }

            @Override
            public String getValue() {
                return "IMPAX_ForResearch";
            }

            @Override
            public String toString() {
                return Messages.getString("FilterSelectionSet.ClinicalTrialSeriesDescription.ClinicalTrial");
            }
        };

        @Override
        public IFilterSelectionSetItem[] getSelectionItems() {
            return new IFilterSelectionSetItem[]{EMPTY_ITEM, CLINICAL_TRIAL_ITEM};
        }
    }

    public static final class PatientSexSelectionSet
    implements IFilterSelectionSet {
        public static final IFilterSelectionSetItem MALE_ITEM = new IFilterSelectionSetItem(){

            @Override
            public boolean isMyCode(Object object) {
                return object instanceof String && "M".equalsIgnoreCase((String)object);
            }

            @Override
            public String getValue() {
                return "M";
            }

            @Override
            public String toString() {
                return Messages.getString("FilterSelectionSet.Sex.Male");
            }
        };
        public static final IFilterSelectionSetItem FEMALE_ITEM = new IFilterSelectionSetItem(){

            @Override
            public boolean isMyCode(Object object) {
                return object instanceof String && "F".equalsIgnoreCase((String)object);
            }

            @Override
            public String getValue() {
                return "F";
            }

            @Override
            public String toString() {
                return Messages.getString("FilterSelectionSet.Sex.Female");
            }
        };
        public static final IFilterSelectionSetItem OTHER_ITEM = new IFilterSelectionSetItem(){

            @Override
            public boolean isMyCode(Object object) {
                return object instanceof String && "O".equalsIgnoreCase((String)object);
            }

            @Override
            public String getValue() {
                return "O";
            }

            @Override
            public String toString() {
                return Messages.getString("FilterSelectionSet.Sex.Other");
            }
        };

        @Override
        public IFilterSelectionSetItem[] getSelectionItems() {
            return new IFilterSelectionSetItem[]{MALE_ITEM, FEMALE_ITEM, OTHER_ITEM};
        }
    }

    public static final class StudyStatusSelectionSet
    implements IFilterSelectionSet {
        public static final IFilterSelectionSetItem REPORTED_ITEM = new StudyStatusFilterSelection(DicomStudyStatus.DicomStudyStatusEnum.Read);
        public static final IFilterSelectionSetItem UNREPORTED_ITEM = new StudyStatusFilterSelection(DicomStudyStatus.DicomStudyStatusEnum.Unread);
        public static final IFilterSelectionSetItem REPORTING_ITEM = new StudyStatusFilterSelection(DicomStudyStatus.DicomStudyStatusEnum.Reading);

        @Override
        public IFilterSelectionSetItem[] getSelectionItems() {
            return new IFilterSelectionSetItem[]{UNREPORTED_ITEM, REPORTED_ITEM, REPORTING_ITEM};
        }

        public static final class StudyStatusFilterSelection
        implements IFilterSelectionSetItem {
            private DicomStudyStatus.DicomStudyStatusEnum status;

            public StudyStatusFilterSelection(DicomStudyStatus.DicomStudyStatusEnum dicomStudyStatusEnum) {
                this.status = dicomStudyStatusEnum;
            }

            @Override
            public boolean isMyCode(Object object) {
                return DicomStudyStatus.fromString((String)object).getState() == this.status;
            }

            @Override
            public String getValue() {
                return this.status.getDicom();
            }

            @Override
            public String toString() {
                return this.status.toString();
            }
        }
    }

    public static final class YesNoSelectionSet
    implements IFilterSelectionSet {
        public static final IFilterSelectionSetItem YES_ITEM = new IFilterSelectionSetItem(){

            @Override
            public boolean isMyCode(Object object) {
                return object instanceof String && "YES".equalsIgnoreCase((String)object);
            }

            @Override
            public String getValue() {
                return "YES";
            }

            @Override
            public String toString() {
                return Messages.getString("FilterSelectionSet.YesNo.Yes");
            }
        };
        public static final IFilterSelectionSetItem NO_ITEM = new IFilterSelectionSetItem(){

            @Override
            public boolean isMyCode(Object object) {
                return object instanceof String && "NO".equalsIgnoreCase((String)object);
            }

            @Override
            public String getValue() {
                return "NO";
            }

            @Override
            public String toString() {
                return Messages.getString("FilterSelectionSet.YesNo.No");
            }
        };

        @Override
        public IFilterSelectionSetItem[] getSelectionItems() {
            return new IFilterSelectionSetItem[]{YES_ITEM, NO_ITEM};
        }
    }
}

