/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter;

import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.filter.FilterModifiers;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IFilterListener;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.filter.ISimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.SimpleFilterEntry;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleFilter
implements IPersistantFilter,
Cloneable {
    private static final ALogger log = ALogger.getLogger(SimpleFilter.class);
    private List<ISimpleFilterEntry> searchEntries = new ArrayList<ISimpleFilterEntry>();
    private List<IFilterListener> listener = new ArrayList<IFilterListener>();
    private FilterModifiers modifiers = this.createDefaultModifiers();
    private String name;
    private Level expandLevel = null;
    private Level cutLevel = null;
    private boolean modified;

    public SimpleFilter() {
        this("Filter Name");
    }

    public SimpleFilter(String string) {
        this.name = string;
        this.modified = false;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public Level getLeafLevel() {
        if (this.searchEntries.isEmpty() || this.allSearchFilterEntriesDisabled()) {
            return Level.Patient;
        }
        Level level = Level.Patient;
        for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
            if (!iSimpleFilterEntry.isEnabled() || iSimpleFilterEntry.getLevel().getLevel() <= level.getLevel()) continue;
            level = iSimpleFilterEntry.getLevel();
        }
        return level;
    }

    public Level getRootLevel() {
        if (this.searchEntries.isEmpty() || this.allSearchFilterEntriesDisabled()) {
            return Level.Patient;
        }
        Level level = Level.Object;
        for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
            if (!iSimpleFilterEntry.isEnabled() || iSimpleFilterEntry.getLevel().getLevel() >= level.getLevel()) continue;
            level = iSimpleFilterEntry.getLevel();
        }
        return level;
    }

    @Override
    public void setFilterName(String string) {
        this.name = string;
        this.modified = true;
    }

    public FilterModifiers getHints() {
        return this.modifiers;
    }

    public void setHints(FilterModifiers filterModifiers) {
        this.modifiers = filterModifiers;
    }

    public void addEntry(ISimpleFilterEntry iSimpleFilterEntry) {
        if (iSimpleFilterEntry != null && !this.searchEntries.contains(iSimpleFilterEntry)) {
            this.searchEntries.add(iSimpleFilterEntry);
            this.modified = true;
            this.fireSearchEntryAdded(iSimpleFilterEntry);
        }
    }

    public void removeEntry(ISimpleFilterEntry iSimpleFilterEntry) {
        if (this.searchEntries.contains(iSimpleFilterEntry)) {
            this.searchEntries.remove(iSimpleFilterEntry);
            this.modified = true;
            this.fireSearchEntryRemoved(iSimpleFilterEntry);
        }
    }

    @Override
    public void removeAllEntries() {
        this.searchEntries.clear();
        this.modified = true;
        this.fireAllSearchEntriesRemoved();
    }

    public void setEntries(List<ISimpleFilterEntry> list) {
        this.searchEntries = list;
    }

    public List<ISimpleFilterEntry> getEntries() {
        return this.searchEntries;
    }

    @Override
    public String getFilterName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String debug() {
        return this.getAsDicomObject().toString();
    }

    @Override
    public boolean isEmpty() {
        Attributes attributes = new Attributes();
        Boolean bl = (Boolean)this.getModifierValue(FilterModifiers.SemanticPNMatchingRequested);
        try {
            this.putModifierValue(FilterModifiers.SemanticPNMatchingRequested, false);
            for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
                if (!iSimpleFilterEntry.isEnabled()) continue;
                iSimpleFilterEntry.getType().modifyDataset(iSimpleFilterEntry, attributes, this.modifiers);
            }
        }
        finally {
            this.putModifierValue(FilterModifiers.SemanticPNMatchingRequested, bl);
        }
        return attributes.isEmpty();
    }

    public Attributes getAsDicomObject() {
        Attributes attributes = new Attributes();
        for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
            if (!iSimpleFilterEntry.isEnabled()) continue;
            iSimpleFilterEntry.getType().modifyDataset(iSimpleFilterEntry, attributes, this.modifiers);
        }
        if (this.searchEntries.isEmpty()) {
            FilterUtilities.putValue((Object)"*", 0x100010, attributes);
        }
        return attributes;
    }

    public List<Attributes> getLevel(Level level) {
        Attributes attributes = new Attributes();
        for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
            if (!iSimpleFilterEntry.isEnabled() || iSimpleFilterEntry.getLevel() != level) continue;
            iSimpleFilterEntry.getType().modifyDataset(iSimpleFilterEntry, attributes, this.modifiers);
        }
        return Collections.singletonList(attributes);
    }

    @Override
    public SimpleFilter cloneFilter() {
        SimpleFilter simpleFilter = new SimpleFilter();
        simpleFilter.name = this.name != null ? String.valueOf(this.name) : "";
        for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
            simpleFilter.searchEntries.add((ISimpleFilterEntry)iSimpleFilterEntry.clone());
        }
        if (this.modifiers != null) {
            simpleFilter.setHints(this.modifiers.copy());
        }
        return simpleFilter;
    }

    public void insert(SimpleFilter simpleFilter) {
        for (ISimpleFilterEntry iSimpleFilterEntry : simpleFilter.getEntries()) {
            this.addEntry(iSimpleFilterEntry);
        }
    }

    public Level getExpandLevel() {
        return this.expandLevel;
    }

    public Level getCutLevel() {
        return this.cutLevel;
    }

    @Override
    public void setExpandLevel(Level level) {
        this.expandLevel = level;
        this.modified = true;
    }

    @Override
    public void setMinLevel(Level level) {
        this.setExpandLevel(level);
    }

    public Level getMinLevel() {
        return this.getExpandLevel();
    }

    @Override
    public void setCutLevel(Level level) {
        this.cutLevel = level;
        this.modified = true;
    }

    public <T> T getModifierValue(FilterModifiers.IFilterModifier<T> iFilterModifier) {
        return (T)this.modifiers.getModifierValue(iFilterModifier);
    }

    public <T> void putModifierValue(FilterModifiers.IFilterModifier<T> iFilterModifier, T t) {
        this.modifiers.putModifierValue(iFilterModifier, t);
    }

    public FilterModifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public void addFilterListener(IFilterListener iFilterListener) {
        if (iFilterListener != null && !this.listener.contains(iFilterListener)) {
            this.listener.add(iFilterListener);
        }
    }

    @Override
    public void removeFilterListener(IFilterListener iFilterListener) {
        if (iFilterListener != null && this.listener.contains(iFilterListener)) {
            this.listener.remove(iFilterListener);
        }
    }

    @Override
    public void save(IConfigurationProvider iConfigurationProvider) throws IOException {
        this.saveXML(iConfigurationProvider);
    }

    @Override
    public void init(IConfigurationProvider iConfigurationProvider) throws IOException {
        if (iConfigurationProvider == null) {
            throw new IOException("Configuration Provider is null!");
        }
        try {
            boolean bl = iConfigurationProvider.exists("simpleFilterXML");
            if (bl) {
                this.initXML(iConfigurationProvider);
            } else {
                this.initLegacy(iConfigurationProvider);
            }
            this.modified = false;
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    @Override
    public String toXML() throws Exception {
        StringBuilder stringBuilder = new StringBuilder(96);
        stringBuilder.append("<simpleFilter ");
        stringBuilder.append("filter_name=\"");
        stringBuilder.append(this.name);
        stringBuilder.append("\" filter_type=\"S\" filter_minimum_level=\"-1\" cut_level=\"");
        stringBuilder.append(this.cutLevel != null ? this.cutLevel.getLevel() : -1);
        stringBuilder.append("\" expand_level=\"");
        stringBuilder.append(this.expandLevel != null ? this.expandLevel.getLevel() : -1);
        stringBuilder.append("\">");
        if (this.searchEntries != null) {
            for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
                if (!this.shouldSaveEntry(iSimpleFilterEntry)) continue;
                stringBuilder.append(iSimpleFilterEntry.saveToXML());
            }
        }
        stringBuilder.append("</simpleFilter>");
        return stringBuilder.toString();
    }

    private void saveXML(IConfigurationProvider iConfigurationProvider) throws IOException {
        try {
            ConfigUtilities.saveToConfigAsXML_UTF16((IConfigurationProvider)iConfigurationProvider, (String)"simpleFilterXML", (String)this.toXML());
            this.modified = false;
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    private String getAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public void initXML(Node node) throws Exception {
        int n;
        Node node2 = node instanceof Document ? ((Document)node).getDocumentElement() : node;
        String string = this.getAttribute(node2, "filter_name");
        String string2 = this.getAttribute(node2, "cut_level");
        String string3 = this.getAttribute(node2, "expand_level");
        int n2 = string2 == null ? -1 : Integer.parseInt(string2);
        int n3 = n = string3 == null ? -1 : Integer.parseInt(string3);
        if (n2 >= 0) {
            this.setCutLevel(Level.get((int)n2));
        }
        if (n >= 0) {
            this.setExpandLevel(Level.get((int)n));
        }
        this.setFilterName(string);
        this.removeAllEntries();
        NodeList nodeList = node2.getChildNodes();
        if (nodeList != null) {
            int n4 = 0;
            while (n4 < nodeList.getLength()) {
                try {
                    Node node3 = nodeList.item(n4);
                    SimpleFilterEntry simpleFilterEntry = new SimpleFilterEntry();
                    simpleFilterEntry.initFromXML(node3);
                    this.addEntry(simpleFilterEntry);
                }
                catch (Exception exception) {
                    log.error("Reading/Creating filter entry failed. Skipped!", (Throwable)exception);
                }
                ++n4;
            }
        }
        this.modified = false;
    }

    private void initXML(IConfigurationProvider iConfigurationProvider) throws IOException {
        try {
            this.initXML(ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)iConfigurationProvider, (String)"simpleFilterXML"));
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            iOException.setStackTrace(exception.getStackTrace());
            throw iOException;
        }
    }

    @Deprecated
    public void initLegacy(IConfigurationProvider iConfigurationProvider) throws IOException {
        if (iConfigurationProvider == null) {
            throw new IOException("Configuration Provider is null!");
        }
        try {
            String string = iConfigurationProvider.exists("filter_name") ? iConfigurationProvider.getString("filter_name") : "default";
            ArrayList<SimpleFilterEntry> arrayList = new ArrayList<SimpleFilterEntry>();
            IConfigurationList iConfigurationList = iConfigurationProvider.getList("filter_entries");
            for (IConfigurationProvider object : iConfigurationList) {
                SimpleFilterEntry simpleFilterEntry = new SimpleFilterEntry();
                simpleFilterEntry.init(object);
                arrayList.add(simpleFilterEntry);
            }
            this.setFilterName(string);
            this.removeAllEntries();
            for (ISimpleFilterEntry iSimpleFilterEntry : arrayList) {
                this.addEntry(iSimpleFilterEntry);
            }
            this.modified = false;
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    private boolean shouldSaveEntry(ISimpleFilterEntry iSimpleFilterEntry) {
        String[] stringArray;
        if (iSimpleFilterEntry != null && (stringArray = iSimpleFilterEntry.getSearchStrings()) != null && stringArray.length > 0) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (string != null && string.length() > 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected FilterModifiers createDefaultModifiers() {
        FilterModifiers filterModifiers = new FilterModifiers();
        try {
            filterModifiers.putModifierValue(FilterUtilities.NoMatchForNoValue, (Object)ConfigurationProviderFactory.getConfig().getBoolean("listtext.search.noMatchForNoValue"));
        }
        catch (Exception exception) {
            log.error("Initializing default filter modifiers failed!", (Throwable)exception);
        }
        return filterModifiers;
    }

    private boolean allSearchFilterEntriesDisabled() {
        boolean bl = true;
        for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
            if (!iSimpleFilterEntry.isEnabled()) continue;
            bl = false;
        }
        return bl;
    }

    private void fireSearchEntryAdded(ISimpleFilterEntry iSimpleFilterEntry) {
        for (IFilterListener iFilterListener : this.listener) {
            iFilterListener.searchEntriesChanged(this);
        }
    }

    private void fireSearchEntryRemoved(ISimpleFilterEntry iSimpleFilterEntry) {
        for (IFilterListener iFilterListener : this.listener) {
            iFilterListener.searchEntriesChanged(this);
        }
    }

    private void fireAllSearchEntriesRemoved() {
        for (IFilterListener iFilterListener : this.listener) {
            iFilterListener.allSearchEntriesRemoved(this);
        }
    }

    @Override
    public IRootInfo filterOnClient(IRootInfo iRootInfo, boolean bl, boolean bl2) {
        throw new UnsupportedOperationException("Method not implemented.");
    }
}

