/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter;

import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.lta.filter.FilterEntryCriterion;
import com.agfa.pacs.listtext.lta.filter.FilterEntryTypes;
import com.agfa.pacs.listtext.lta.filter.FilterEntryTypesFactory;
import com.agfa.pacs.listtext.lta.filter.IFilterEntry;
import com.agfa.pacs.listtext.lta.filter.IFilterEntryType;
import com.agfa.pacs.listtext.lta.filter.ISimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionFactory;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import java.io.IOException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleFilterEntry
implements ISimpleFilterEntry {
    private FilterEntryCriterion searchCriterion;
    private IFilterEntryType searchType;
    private String[] searchStrings;
    private Level level;
    private boolean enabled;
    private boolean modified;

    public SimpleFilterEntry(Level level, FilterEntryCriterion filterEntryCriterion, IFilterEntryType iFilterEntryType, String[] stringArray) {
        this.searchCriterion = filterEntryCriterion;
        this.searchType = iFilterEntryType;
        this.searchStrings = stringArray;
        this.level = level;
        this.enabled = true;
        this.modified = false;
    }

    public SimpleFilterEntry() {
        this(Level.Patient, null, FilterEntryTypes.instanceEquals, null);
    }

    @Override
    public FilterEntryCriterion getCriterion() {
        return this.searchCriterion;
    }

    @Override
    public IFilterEntryType getType() {
        return this.searchType;
    }

    @Override
    public String[] getSearchStrings() {
        return this.searchStrings;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.searchCriterion.toString()).append(' ').append(this.searchType);
        String[] stringArray = this.searchStrings;
        int n = this.searchStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            stringBuilder.append(' ').append(string);
            ++n2;
        }
        return stringBuilder.toString();
    }

    @Override
    public IFilterEntry clone() {
        SimpleFilterEntry simpleFilterEntry = new SimpleFilterEntry(this.level, this.searchCriterion, this.searchType, this.searchStrings != null ? (String[])this.searchStrings.clone() : null);
        simpleFilterEntry.setEnabled(this.enabled);
        return simpleFilterEntry;
    }

    @Override
    public void setType(IFilterEntryType iFilterEntryType) {
        if (iFilterEntryType != null && iFilterEntryType != this.searchType) {
            this.searchType = iFilterEntryType;
            if (!FilterEntryTypes.isInStandardStringGroup(iFilterEntryType)) {
                this.searchStrings = null;
            }
            this.modified = true;
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.modified = true;
    }

    @Override
    public void setSearchStrings(String[] stringArray) {
        this.searchStrings = stringArray == null ? new String[0] : stringArray;
        this.modified = true;
    }

    @Override
    public void init(IConfigurationProvider iConfigurationProvider) throws IOException {
        if (iConfigurationProvider == null) {
            throw new IOException("Configuration Provider is null!");
        }
        try {
            int n = (int)iConfigurationProvider.getLong("criterion_tag");
            this.searchType = FilterEntryTypesFactory.getFilterEntryTypeForCode(iConfigurationProvider.getString("search_type"));
            this.searchCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion((int)iConfigurationProvider.getLong("criterion_tag"));
            this.level = Level.get((int)DicomTagDictionaryFactory.getDictionary().getLevelOfSearchTag(n));
            if (iConfigurationProvider.exists("search_string")) {
                this.setSearchStrings(new String[]{iConfigurationProvider.getString("search_string")});
            } else if (iConfigurationProvider.exists("search_strings1")) {
                String string = iConfigurationProvider.getString("search_strings1");
                this.setSearchStrings(string.split(";", -1));
            }
            this.modified = false;
        }
        catch (Exception exception) {
            throw (IOException)new IOException(exception.getMessage()).initCause(exception);
        }
    }

    @Override
    public void save(IConfigurationProvider iConfigurationProvider) throws IOException {
        try {
            iConfigurationProvider.setString("search_type", this.getType().getCode());
            iConfigurationProvider.setLong("criterion_tag", (long)this.getCriterion().getTag());
            String[] stringArray = this.getSearchStrings();
            if (stringArray != null && stringArray.length > 0) {
                if (stringArray.length == 1) {
                    iConfigurationProvider.setString("search_string", stringArray[0]);
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = 0;
                    while (n < stringArray.length) {
                        stringBuilder.append(stringArray[n]);
                        if (n + 1 < stringArray.length) {
                            stringBuilder.append(';');
                        }
                        ++n;
                    }
                    iConfigurationProvider.setString("search_strings1", stringBuilder.toString());
                }
            }
            this.modified = false;
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    @Override
    public String saveToXML() throws IOException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<entry ");
            stringBuilder.append("search_type=\"");
            stringBuilder.append(this.getType().getCode());
            stringBuilder.append("\" criterion_tag=\"");
            stringBuilder.append(this.getCriterion().getTag());
            stringBuilder.append("\">");
            if (this.searchStrings != null) {
                String[] stringArray = this.searchStrings;
                int n = this.searchStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    stringBuilder.append("<searchstring>");
                    if (string != null) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append("</searchstring>");
                    ++n2;
                }
            }
            stringBuilder.append("</entry>");
            this.modified = false;
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    @Override
    public void initFromXML(Node node) throws IOException {
        try {
            String string = node.getAttributes().getNamedItem("criterion_tag").getNodeValue();
            String string2 = node.getAttributes().getNamedItem("search_type").getNodeValue();
            NodeList nodeList = node.getChildNodes();
            this.searchType = FilterEntryTypesFactory.getFilterEntryTypeForCode(string2);
            this.searchCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(Integer.valueOf(string));
            this.level = Level.get((int)DicomTagDictionaryFactory.getDictionary().getLevelOfSearchTag(Integer.valueOf(string)));
            if (nodeList != null && nodeList.getLength() > 0) {
                this.searchStrings = new String[nodeList.getLength()];
                int n = 0;
                while (n < nodeList.getLength()) {
                    this.searchStrings[n] = nodeList.item(n).getTextContent();
                    ++n;
                }
            } else {
                this.searchStrings = null;
            }
            this.modified = false;
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }
}

