/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter.dicom;

import com.agfa.pacs.listtext.lta.filter.FilterEntryCriterion;
import com.agfa.pacs.listtext.lta.filter.FilterSelectionSets;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionAS;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionDA;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionDT;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionFD;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionFL;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionLong;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionPN;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionSelection;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionString;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionTM;
import com.agfa.pacs.listtext.lta.filter.dicom.customfields.DicomCustomField;
import com.agfa.pacs.listtext.lta.filter.dicom.customfields.DicomCustomFields;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;

public class DicomSearchCriterionFactory {
    private static DicomSearchCriterionFactory instance = new DicomSearchCriterionFactory();

    private DicomSearchCriterionFactory() {
    }

    public static DicomSearchCriterionFactory getInstance() {
        return instance;
    }

    public FilterEntryCriterion createSearchCriterion(int n) {
        String string;
        VR vR = ElementDictionary.vrOf((int)n, null);
        DicomCustomField dicomCustomField = DicomCustomFields.getDefaultInstance().findField(n);
        if (dicomCustomField != null) {
            string = dicomCustomField.getName();
            if (dicomCustomField.hasSelectionSet()) {
                return new DicomSearchCriterionSelection(n, vR, string, dicomCustomField.getSelectionSet());
            }
        } else {
            string = DicomTagDictionaryFactory.getLocaleDictionary().getNameForTag(n);
        }
        switch (n) {
            case 0x100040: {
                return new DicomSearchCriterionSelection(n, vR, string, FilterSelectionSets.PATIENT_SEX_SELECTION_SET);
            }
            case 524384: {
                return new DicomSearchCriterionSelection(n, vR, string, FilterSelectionSets.MODALITY_SELECTION_SET);
            }
            case 524385: {
                return new DicomSearchCriterionSelection(n, vR, string, FilterSelectionSets.MODALITY_SELECTION_SET);
            }
            case 3276810: {
                return new DicomSearchCriterionSelection(n, vR, string, FilterSelectionSets.STUDY_STATUS_SELECTION_SET);
            }
            case 1179762: {
                return new DicomSearchCriterionSelection(n, vR, string, FilterSelectionSets.CLINICAL_TRIAL_SERIES_DECRIPTION_SELECTION_SET);
            }
        }
        if (vR.code() == VR.AE.code()) {
            return new DicomSearchCriterionString(n, vR, string);
        }
        if (vR.code() == VR.AS.code()) {
            return new DicomSearchCriterionAS(n, vR, string);
        }
        if (vR.code() == VR.CS.code()) {
            return new DicomSearchCriterionString(n, vR, string);
        }
        if (vR.code() == VR.DA.code()) {
            return new DicomSearchCriterionDA(n, vR, string);
        }
        if (vR.code() == VR.DS.code()) {
            return new DicomSearchCriterionString(n, vR, string);
        }
        if (vR.code() == VR.DT.code()) {
            return new DicomSearchCriterionDT(n, vR, string);
        }
        if (vR.code() == VR.FL.code()) {
            return new DicomSearchCriterionFL(n, vR, string);
        }
        if (vR.code() == VR.FD.code()) {
            return new DicomSearchCriterionFD(n, vR, string);
        }
        if (vR.code() == VR.IS.code()) {
            return new DicomSearchCriterionString(n, vR, string);
        }
        if (vR.code() == VR.LO.code()) {
            return new DicomSearchCriterionString(n, vR, string);
        }
        if (vR.code() == VR.LT.code()) {
            return new DicomSearchCriterionString(n, vR, string);
        }
        if (vR.code() == VR.PN.code()) {
            return new DicomSearchCriterionPN(n, vR, string);
        }
        if (vR.code() == VR.SH.code()) {
            return new DicomSearchCriterionString(n, vR, string);
        }
        if (vR.code() == VR.SL.code()) {
            return new DicomSearchCriterionLong(n, vR, string, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (vR.code() == VR.SS.code()) {
            return new DicomSearchCriterionLong(n, vR, string, -32768L, 32767L);
        }
        if (vR.code() == VR.ST.code()) {
            return new DicomSearchCriterionString(n, vR, string);
        }
        if (vR.code() == VR.TM.code()) {
            return new DicomSearchCriterionTM(n, vR, string);
        }
        if (vR.code() == VR.UL.code()) {
            return new DicomSearchCriterionLong(n, vR, string, 0L, 0xFFFFFFFFL);
        }
        if (vR.code() == VR.US.code()) {
            return new DicomSearchCriterionLong(n, vR, string, 0L, 65535L);
        }
        if (vR.code() == VR.UT.code()) {
            return new DicomSearchCriterionString(n, vR, string);
        }
        if (vR.code() == VR.UI.code()) {
            return new DicomSearchCriterionString(n, vR, string);
        }
        return null;
    }
}

