/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter.dicom.customfields;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.lta.filter.IFilterSelectionSet;
import com.agfa.pacs.listtext.lta.filter.IFilterSelectionSetItem;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class DicomCustomField {
    private int tag;
    private String name;
    private Level level;
    private IFilterSelectionSet selectionSet;

    public DicomCustomField(int n, String string, Level level, IFilterSelectionSet iFilterSelectionSet) {
        assert (n > 0) : "Creating custom dicom field failed: tag is <= 0";
        assert (string != null) : "Creating custom dicom field failed: name is null!";
        assert (level != null) : "Creating custom dicom field failed: level is null!";
        this.tag = n;
        this.name = string;
        this.level = level;
        this.selectionSet = iFilterSelectionSet;
    }

    public DicomCustomField(int n, String string, Level level) {
        this(n, string, level, null);
    }

    public static DicomCustomField createDefault() {
        return new DicomCustomField(0x100010, DicomTagDictionaryFactory.getLocaleDictionary().getNameForTag(0x100010), Level.Patient);
    }

    public int getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setTag(int n) {
        assert (n >= 0) : "Setting custom dicom field tag failed: Tag is < 0!";
        this.tag = n;
    }

    public void setName(String string) {
        assert (string != null) : "Setting custom dicom field name failed: Name is null!";
        this.name = string;
    }

    public void setLevel(Level level) {
        assert (level != null) : "Setting custom dicom field level failed: Level is null!";
        this.level = level;
    }

    public boolean hasSelectionSet() {
        if (this.selectionSet != null) {
            IFilterSelectionSetItem[] iFilterSelectionSetItemArray = this.selectionSet.getSelectionItems();
            return iFilterSelectionSetItemArray != null && iFilterSelectionSetItemArray.length > 0;
        }
        return false;
    }

    public IFilterSelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    public void setSelectionSet(IFilterSelectionSet iFilterSelectionSet) {
        this.selectionSet = iFilterSelectionSet;
    }

    public static IFilterSelectionSet createFilterSelectionSet(String string) throws Exception {
        CustomFilterSelectionSet customFilterSelectionSet = new CustomFilterSelectionSet();
        customFilterSelectionSet.addEncodedItems(string);
        return customFilterSelectionSet;
    }

    public static String encodeItems(IFilterSelectionSet iFilterSelectionSet) {
        IFilterSelectionSetItem[] iFilterSelectionSetItemArray;
        if (iFilterSelectionSet != null && (iFilterSelectionSetItemArray = iFilterSelectionSet.getSelectionItems()) != null && iFilterSelectionSetItemArray.length > 0) {
            Iterator<IFilterSelectionSetItem> iterator = Arrays.asList(iFilterSelectionSetItemArray).iterator();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(DicomCustomField.encodeItem(iterator.next()));
            while (iterator.hasNext()) {
                stringBuilder.append(";");
                stringBuilder.append(DicomCustomField.encodeItem(iterator.next()));
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static DicomCustomField createFromNode(Node node) throws Exception {
        String string = node.getAttributes().getNamedItem("tag").getNodeValue();
        String string2 = node.getAttributes().getNamedItem("name").getNodeValue();
        String string3 = node.getAttributes().getNamedItem("level").getNodeValue();
        IFilterSelectionSet iFilterSelectionSet = null;
        if (node.getAttributes().getNamedItem("selection-set") != null) {
            iFilterSelectionSet = DicomCustomField.createFilterSelectionSet(node.getAttributes().getNamedItem("selection-set").getNodeValue());
        }
        return new DicomCustomField(Integer.valueOf(string), string2, Level.valueOf((String)string3), iFilterSelectionSet);
    }

    public String toXML() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<field ");
        stringBuilder.append("tag=\"");
        stringBuilder.append(this.tag);
        stringBuilder.append("\" name=\"");
        stringBuilder.append(this.name);
        stringBuilder.append("\" level=\"");
        stringBuilder.append(this.level.name());
        if (this.hasSelectionSet()) {
            stringBuilder.append("\" selection-set=\"");
            stringBuilder.append(DicomCustomField.encodeItems(this.selectionSet));
        }
        stringBuilder.append("\"/>");
        return stringBuilder.toString();
    }

    private static String encodeItem(IFilterSelectionSetItem iFilterSelectionSetItem) {
        String string;
        String string2 = iFilterSelectionSetItem.getValue();
        if (string2.equals(string = iFilterSelectionSetItem.toString())) {
            return string2;
        }
        return "(" + string2 + "," + string + ")";
    }

    private static class CustomFilterSelectionSet
    implements IFilterSelectionSet {
        private List<IFilterSelectionSetItem> items = new ArrayList<IFilterSelectionSetItem>();

        @Override
        public IFilterSelectionSetItem[] getSelectionItems() {
            return this.items.toArray(new IFilterSelectionSetItem[this.items.size()]);
        }

        public void addItem(String string, String string2) {
            this.items.add(new CustomFilterSelectionSetItem(string, string2));
        }

        public void addItem(String string) {
            this.addItem(string, string);
        }

        public void addEncodedItem(String string) throws Exception {
            if (string != null) {
                if (string.contains(",")) {
                    String[] stringArray = string.split(",");
                    String string2 = stringArray[0].startsWith("(") ? stringArray[0].substring(1) : stringArray[0];
                    String string3 = stringArray[1].endsWith(")") ? stringArray[1].substring(0, stringArray[1].length() - 1) : stringArray[1];
                    this.addItem(string2, string3);
                } else {
                    String string4 = string;
                    if (string4.startsWith("(")) {
                        string4 = string4.substring(1);
                    }
                    if (string4.endsWith(")")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    this.addItem(string4);
                }
            }
        }

        public void addEncodedItems(String string) throws Exception {
            try {
                String[] stringArray;
                String[] stringArray2 = stringArray = string.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray2[n2];
                    this.addEncodedItem(string2);
                    ++n2;
                }
            }
            catch (Exception exception) {
                this.items.clear();
                throw exception;
            }
        }
    }

    private static class CustomFilterSelectionSetItem
    implements IFilterSelectionSetItem {
        private String displayedValue;
        private String dicomValue;

        public CustomFilterSelectionSetItem(String string, String string2) {
            this.dicomValue = string;
            this.displayedValue = string2;
        }

        @Override
        public String getValue() {
            return this.dicomValue;
        }

        @Override
        public String toString() {
            return this.displayedValue;
        }

        @Override
        public boolean isMyCode(Object object) {
            return false;
        }
    }
}

