/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter.dicom.customfields;

import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.listtext.lta.filter.dicom.customfields.DicomCustomField;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DicomCustomFields {
    private static final ALogger log = ALogger.getLogger(DicomCustomFields.class);
    private static final String CONFIG_PATH = "listtext.customDicomTags";
    private static DicomCustomFields defaultInstance = null;
    private List<DicomCustomField> fields;
    private IConfigurationProvider cp;

    private DicomCustomFields(IConfigurationProvider iConfigurationProvider) {
        assert (iConfigurationProvider != null) : "Creating dicom custom fields failed: configuration-provider is null!";
        this.fields = new ArrayList<DicomCustomField>();
        this.cp = iConfigurationProvider;
        this.initFromConfig();
    }

    public static synchronized DicomCustomFields getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DicomCustomFields(ConfigurationProviderFactory.getConfig());
        }
        return defaultInstance;
    }

    public static DicomCustomFields createInstance(IConfigurationProvider iConfigurationProvider) {
        return new DicomCustomFields(iConfigurationProvider);
    }

    public int getSize() {
        return this.fields.size();
    }

    public Iterable<DicomCustomField> getFields() {
        return this.fields;
    }

    public boolean hasFieldOfTag(int n) {
        return this.findField(n) != null;
    }

    public DicomCustomField findField(int n) {
        for (DicomCustomField dicomCustomField : this.fields) {
            if (n != dicomCustomField.getTag()) continue;
            return dicomCustomField;
        }
        return null;
    }

    public DicomCustomField getFieldAt(int n) {
        return this.fields.get(n);
    }

    public void addField(DicomCustomField dicomCustomField) {
        assert (dicomCustomField != null) : "Adding custom dicom tag failed: Field is null!";
        if (!this.fields.contains(dicomCustomField)) {
            this.fields.add(dicomCustomField);
        }
    }

    public void removeField(DicomCustomField dicomCustomField) {
        assert (dicomCustomField != null) : "Removing custom dicom tag failed: Field is null!";
        this.fields.remove(dicomCustomField);
    }

    public void removeAllFields() {
        this.fields.clear();
    }

    public void modified() {
        this.saveToConfig();
    }

    public boolean isInherited() {
        String string = this.cp.getRole();
        String string2 = this.cp.getRole(CONFIG_PATH);
        if (string2 != null) {
            if (string == null) {
                return string2.isEmpty();
            }
            return !string.equals(string2);
        }
        return false;
    }

    public void resetToRole() {
        if (this.cp.exists(CONFIG_PATH)) {
            this.cp.removeValue(CONFIG_PATH);
        }
        this.cp.storeAllConfiguration();
        this.cp.updateCache(CONFIG_PATH);
        this.initFromConfig();
    }

    protected void initFromConfig() {
        block5: {
            this.fields.clear();
            try {
                Document document = ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)this.cp, (String)CONFIG_PATH);
                NodeList nodeList = document.getElementsByTagName("field");
                if (nodeList == null) break block5;
                int n = 0;
                while (n < nodeList.getLength()) {
                    try {
                        this.addField(DicomCustomField.createFromNode(nodeList.item(n)));
                    }
                    catch (Exception exception) {
                        log.error("Initializing dicom custom field from config failed! Skipped...");
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                log.error("Initializing dicom custom fields from config failed! Using empty list...", (Throwable)exception);
            }
        }
    }

    protected void saveToConfig() {
        try {
            if (this.fields == null || this.fields.isEmpty()) {
                if (this.cp.exists(CONFIG_PATH)) {
                    this.cp.removeValue(CONFIG_PATH);
                    this.cp.storeAllConfiguration();
                    this.cp.updateCache(CONFIG_PATH);
                    this.initFromConfig();
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<list>");
                for (DicomCustomField dicomCustomField : this.fields) {
                    stringBuilder.append(dicomCustomField.toXML());
                }
                stringBuilder.append("</list>");
                ConfigUtilities.saveToConfigAsXML_UTF16((IConfigurationProvider)this.cp, (String)CONFIG_PATH, (String)stringBuilder.toString());
            }
        }
        catch (Exception exception) {
            log.error("Saving custom dicom fields to config failed!", (Throwable)exception);
        }
    }
}

