/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.findcache;

import com.agfa.pacs.data.dicom.comm.DicomCFindConst;
import com.agfa.pacs.data.shared.lw.DataInfoFactoryProvider;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoFactory;
import com.agfa.pacs.data.shared.lw.IDataInfoRetriever;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.findcache.IFindCache;
import com.agfa.pacs.logging.ALogger;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.json.Json;
import javax.json.stream.JsonParser;
import org.apache.commons.collections4.CollectionUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.json.JSONReader;

public class WadoRSFindCache
implements IFindCache {
    private static final ALogger LOGGER = ALogger.getLogger(WadoRSFindCache.class);
    private IDataInfoFactory diFact = DataInfoFactoryProvider.getInstance();
    private static final String CACHE_ADDRESS = "Cache/studies/";

    @Override
    public List<IObjectInfo> expandStudy(IStudyInfo iStudyInfo) throws Throwable {
        String string = iStudyInfo.getSource().getIdentifier().getType();
        if (string.equals("AGFADICOMWADO")) {
            String string2 = iStudyInfo.getSource().getIdentifier().getPropertiesOwner().properties().getProperty("wadoURI");
            string2 = string2.replace("wado", CACHE_ADDRESS);
            IDataInfoRetriever iDataInfoRetriever = iStudyInfo.getSource().getRetriever();
            List<Attributes> list = this.fetchJson(iStudyInfo.getKey(), string2);
            if (list == null || list.isEmpty()) {
                LOGGER.info("Study not found in cache {}", (Object)iStudyInfo.getKey());
                return null;
            }
            if (!this.isValid(iStudyInfo, list)) {
                LOGGER.info("Found not valid cache entry:{}", (Object)iStudyInfo.getKey());
                return null;
            }
            LOGGER.info("Found valid cache entry:{}", (Object)iStudyInfo.getKey());
            return this.createSeries(iStudyInfo, list, iDataInfoRetriever);
        }
        return null;
    }

    private boolean isValid(IStudyInfo iStudyInfo, List<Attributes> list) {
        Set set;
        Attributes attributes = list.get(0);
        if (!iStudyInfo.getAttributes().equalValues(attributes, null, 2101768)) {
            LOGGER.info("Different number of objects {},{}", (Object)attributes.getInt(2101768, 0), (Object)iStudyInfo.getInt(2101768));
            return false;
        }
        Set set2 = IDWithIssuer.pidsOf((Attributes)iStudyInfo.getPatient().getAttributes());
        if (!CollectionUtils.containsAny((Collection)set2, (Collection)(set = IDWithIssuer.pidsOf((Attributes)attributes)))) {
            LOGGER.info("No match on patient IDs");
            return false;
        }
        if (!Objects.equals(iStudyInfo.getStudyUID(), attributes.getString(0x20000D))) {
            LOGGER.info("Study UID differ");
            return false;
        }
        try {
            PersonName personName = new PersonName(iStudyInfo.getPatient().getAttributes().getString(0x100010), true);
            PersonName personName2 = new PersonName(attributes.getString(0x100010), true);
            if (!Objects.equals(personName, personName2)) {
                LOGGER.info("Patient name differ: {},{}", (Object)personName, (Object)personName2);
                return false;
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Error on parsing names", (Throwable)exception);
            return false;
        }
        return true;
    }

    private List<IObjectInfo> createSeries(IStudyInfo iStudyInfo, List<Attributes> list, IDataInfoRetriever iDataInfoRetriever) throws Throwable {
        HashMap<String, IDataInfo> hashMap = new HashMap<String, IDataInfo>();
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>(1024);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType methodType = MethodType.methodType(Void.TYPE, ILoadableInfo.class, Attributes.class);
        MethodHandle methodHandle = lookup.findVirtual(iDataInfoRetriever.getClass(), "setLocations", methodType);
        for (Attributes attributes : list) {
            int n;
            Attributes attributes2;
            String string = attributes.getString(0x20000E);
            IDataInfo iDataInfo = (IDataInfo)hashMap.get(string);
            if (iDataInfo == null) {
                attributes2 = new Attributes(attributes, DicomCFindConst.SERIES_TAGS);
                int[][] nArray = DicomCFindConst.SERIES_NESTED_TAGS;
                int n2 = DicomCFindConst.SERIES_NESTED_TAGS.length;
                n = 0;
                while (n < n2) {
                    int[] nArray2 = nArray[n];
                    attributes2.addSelected(attributes, new int[]{nArray2[0]});
                    ++n;
                }
                iDataInfo = this.diFact.createSeriesInfo(iStudyInfo, attributes2, string);
                iStudyInfo.addChild(iDataInfo);
                methodHandle.invoke(iDataInfoRetriever, iDataInfo, null);
                hashMap.put(string, iDataInfo);
            }
            int[] nArray = DicomCFindConst.SERIES_MERGED_TAGS;
            n = DicomCFindConst.SERIES_MERGED_TAGS.length;
            int n3 = 0;
            while (n3 < n) {
                int n4 = nArray[n3];
                attributes.remove(n4);
                ++n3;
            }
            attributes2 = this.diFact.createObjectInfo((ISeriesInfo)iDataInfo, attributes, attributes.getString(524312));
            iDataInfo.addChild((IDataInfo)attributes2);
            methodHandle.invoke(iDataInfoRetriever, (IObjectInfo)attributes2, null);
            arrayList.add((IObjectInfo)attributes2);
        }
        iStudyInfo.resetChildren();
        iStudyInfo.addChildren(hashMap.values());
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Attributes> fetchJson(String string, String string2) throws Exception {
        URL uRL = new URL(String.valueOf(string2) + string + "/metadata");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.connect();
        int n = httpURLConnection.getResponseCode();
        if (n != 200) return null;
        String string3 = httpURLConnection.getHeaderField("content-type");
        if (string3 == null) {
            return null;
        }
        String[] stringArray = string3.split(";");
        Charset charset = Charset.defaultCharset();
        if (stringArray.length > 1) {
            charset = Charset.forName(stringArray[1].split("=")[1]);
        }
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(new BufferedInputStream(httpURLConnection.getInputStream(), 65536));
                try {
                    List<Attributes> list;
                    block18: {
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)gZIPInputStream, charset);
                        try {
                            JsonParser jsonParser = Json.createParser((Reader)inputStreamReader);
                            JSONReader jSONReader = new JSONReader(jsonParser);
                            JSonCallback jSonCallback = new JSonCallback();
                            jSONReader.readDatasets((JSONReader.Callback)jSonCallback);
                            list = jSonCallback.getResult();
                            return list;
                        }
                        finally {
                            if (inputStreamReader == null) break block18;
                            inputStreamReader.close();
                        }
                    }
                    if (gZIPInputStream != null) {
                        gZIPInputStream.close();
                    }
                    httpURLConnection.disconnect();
                    return list;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (gZIPInputStream == null) throw throwable;
                    gZIPInputStream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            httpURLConnection.disconnect();
            throw throwable;
        }
    }

    private static class JSonCallback
    implements JSONReader.Callback {
        private List<Attributes> result = new ArrayList<Attributes>(2048);

        private JSonCallback() {
        }

        public void onDataset(Attributes attributes, Attributes attributes2) {
            if (attributes != null) {
                attributes2.addSelected(attributes, new int[]{131088});
            }
            this.result.add(attributes2);
        }

        public List<Attributes> getResult() {
            return this.result;
        }
    }
}

