/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.priors;

import com.agfa.pacs.base.util.PatientMergeUtilities;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.DataInfoNodeUtilities;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.listtext.lta.filter.FilterEntryCriterion;
import com.agfa.pacs.listtext.lta.filter.FilterEntryTypes;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.filter.SimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedFilter;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionFactory;
import com.agfa.pacs.listtext.lta.priors.IPriorsHook;
import com.agfa.pacs.listtext.lta.priors.IRelevancyListener;
import com.agfa.pacs.listtext.lta.search.ISearchHandler;
import com.agfa.pacs.listtext.lta.search.ISearchThread;
import com.agfa.pacs.listtext.lta.search.SearchHandler;
import com.agfa.pacs.listtext.lta.search.SearchHandlerListener;
import com.agfa.pacs.listtext.lta.util.SendError;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;

public abstract class AbstractPriorsHook
implements IPriorsHook {
    private static final ALogger log = ALogger.getLogger(AbstractPriorsHook.class);
    protected String cacheKey = null;
    protected IRootInfo cachedResult = null;
    private List<String> notSearchedDataNodeTypes = new ArrayList<String>();

    public AbstractPriorsHook() {
        this.notSearchedDataNodeTypes.add("DICOMFILE");
        this.notSearchedDataNodeTypes.add("DICOMDIR");
        this.notSearchedDataNodeTypes.add("IMPAXEE");
        this.notSearchedDataNodeTypes.add("DICOMCACHE");
    }

    @Override
    public Cancelable startAnotherSearch(List<IStudyInfo> list, List<IRelevancyListener> list2, IDataInfoNode iDataInfoNode) {
        List list3 = DataInfoUtilities.getLevel(list, IPatientInfo.class);
        IPatientInfo iPatientInfo = (IPatientInfo)list3.get(0);
        IPersistantFilter iPersistantFilter = FilterUtilities.getEverythingForPatient(iPatientInfo);
        iPersistantFilter.setExpandLevel(Level.Study);
        SearchHandler searchHandler = new SearchHandler();
        searchHandler.setSourcesPresorted(true);
        if (iDataInfoNode != null) {
            searchHandler.addDataInfoSource((IDataInfoSource)iDataInfoNode);
        } else {
            for (IDataInfoNode object2 : Base.getDataInfoNodes()) {
                String string = object2.getType();
                if (this.notSearchedDataNodeTypes.contains(string)) continue;
                searchHandler.addDataInfoSource((IDataInfoSource)object2);
            }
        }
        PriorSearchHandler priorSearchHandler = new PriorSearchHandler(list, list.get(0).getPatient(), list2, false);
        Cancelable cancelable = searchHandler.search(iPersistantFilter, priorSearchHandler);
        priorSearchHandler.setCancelSearch(cancelable);
        return priorSearchHandler;
    }

    @Override
    public Cancelable startMPISearch(IStudyInfo iStudyInfo, List<IRelevancyListener> list, IDataInfoNode iDataInfoNode) {
        Object object;
        List list2 = DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, IPatientInfo.class);
        IPatientInfo iPatientInfo = (IPatientInfo)list2.get(0);
        String string = iPatientInfo.getAttributes().getString(0x100020, null);
        String string2 = iPatientInfo.getAttributes().getString(0x100021, null);
        AdvancedFilter advancedFilter = new AdvancedFilter("MPI");
        if (string != null) {
            object = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100020);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, (FilterEntryCriterion)object, FilterEntryTypes.instanceEquals, new String[]{string}));
        }
        if (string2 != null) {
            object = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100021);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, (FilterEntryCriterion)object, FilterEntryTypes.instanceEquals, new String[]{string2}));
        }
        advancedFilter.setExpandLevel(Level.Study);
        object = new SearchHandler();
        ((SearchHandler)object).addDataInfoSource((IDataInfoSource)iDataInfoNode);
        PriorSearchHandler priorSearchHandler = new PriorSearchHandler(Collections.singletonList(iStudyInfo), iStudyInfo.getPatient(), list, true);
        Cancelable cancelable = ((SearchHandler)object).search(advancedFilter, priorSearchHandler);
        priorSearchHandler.setCancelSearch(cancelable);
        return priorSearchHandler;
    }

    private ArchiveType getArchiveType(IDataInfoSource iDataInfoSource) {
        if (iDataInfoSource == null) {
            return ArchiveType.NotSearchable;
        }
        if (iDataInfoSource.getIdentifier().getType().equals("DICOMPS")) {
            return ArchiveType.NotSearchable;
        }
        if (iDataInfoSource.getIdentifier().getType().equals("DICOMCACHE")) {
            return ArchiveType.NotSearchable;
        }
        String string = iDataInfoSource.getIdentifier().getPropertiesOwner().properties().getProperty("closeImmediately");
        if (string != null && Boolean.parseBoolean(string)) {
            return ArchiveType.Dicom;
        }
        return ArchiveType.Agfa;
    }

    @Override
    public Cancelable findWholePatient(IPatientInfo iPatientInfo, List<IRelevancyListener> list) {
        IDataInfoSource iDataInfoSource = iPatientInfo.getSource();
        ArchiveType archiveType = this.getArchiveType(iDataInfoSource);
        IPersistantFilter iPersistantFilter = FilterUtilities.getEverythingForPatient(iPatientInfo);
        if (archiveType == ArchiveType.Agfa) {
            iPersistantFilter.setExpandLevel(Level.Series);
        }
        return this.search(iPersistantFilter, iDataInfoSource, new PriorSearchHandler(iPatientInfo, list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PriorSearchHandler search(IFilter iFilter, IDataInfoSource iDataInfoSource, PriorSearchHandler priorSearchHandler) {
        IDataInfoNode iDataInfoNode2;
        String string = String.valueOf(iFilter.toString()) + iDataInfoSource.toString();
        IRootInfo iRootInfo = null;
        Object object = this;
        synchronized (object) {
            if (Objects.equals(this.cacheKey, string)) {
                log.info("Cache hit, on prior search");
                iRootInfo = this.cachedResult;
                this.cachedResult = null;
                this.cacheKey = null;
            }
        }
        if (iRootInfo != null) {
            priorSearchHandler.searchSuccess(null, null, null, (IDataInfo)iRootInfo);
            priorSearchHandler.searchFinished(null, new DummySearchThread(iRootInfo));
            return priorSearchHandler;
        }
        priorSearchHandler.setCacheKey(string);
        log.info("Cache miss, on prior search");
        object = new SearchHandler();
        ((SearchHandler)object).addDataInfoSource(DataInfoNodeUtilities.cloneIfPossible((IDataInfoSource)iDataInfoSource));
        ((SearchHandler)object).setSourcesPresorted(true);
        for (IDataInfoNode iDataInfoNode2 : this.getAdditionalNodes()) {
            ((SearchHandler)object).addDataInfoSource((IDataInfoSource)iDataInfoNode2);
        }
        iDataInfoNode2 = ((SearchHandler)object).search(iFilter, priorSearchHandler);
        priorSearchHandler.setCancelSearch((Cancelable)iDataInfoNode2);
        return priorSearchHandler;
    }

    @Override
    public Cancelable startSearch(List<IStudyInfo> list, List<IRelevancyListener> list2) {
        List list3 = DataInfoUtilities.getLevel(list, IPatientInfo.class);
        IPatientInfo iPatientInfo = (IPatientInfo)list3.get(0);
        IDataInfoSource iDataInfoSource = list.get(0).getSource();
        ArchiveType archiveType = this.getArchiveType(iDataInfoSource);
        if (archiveType != ArchiveType.NotSearchable) {
            IPersistantFilter iPersistantFilter = FilterUtilities.getEverythingForPatient(iPatientInfo);
            if (archiveType == ArchiveType.Agfa) {
                iPersistantFilter.setExpandLevel(Level.Series);
            }
            return this.search(iPersistantFilter, iDataInfoSource, new PriorSearchHandler(list, list.get(0).getPatient(), list2, false));
        }
        for (IRelevancyListener iRelevancyListener : list2) {
            LinkedList<IStudyInfo> linkedList = new LinkedList<IStudyInfo>(list);
            iRelevancyListener.studiesFound(iPatientInfo.getKey(), linkedList);
            iRelevancyListener.relevantFound(iPatientInfo.getKey(), list.get(0).getStudyUID(), Collections.emptyList());
            iRelevancyListener.searchFinished(iPatientInfo.getKey(), list.get(0).getStudyUID(), false);
        }
        return null;
    }

    private List<IDataInfoNode> getAdditionalNodes() {
        if (this.isSearchInAllNodes()) {
            return Base.getDataInfoNodes();
        }
        IDataInfoNode iDataInfoNode = this.getAdditionalSearchNode();
        if (iDataInfoNode == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(iDataInfoNode);
    }

    protected abstract boolean isSearchInAllNodes();

    protected abstract IDataInfoNode getAdditionalSearchNode();

    private List<IStudyInfo> removeAll(List<IStudyInfo> list, List<IStudyInfo> list2) {
        IStudyInfo iStudyInfo2;
        HashSet<String> hashSet = new HashSet<String>(list2.size());
        for (IStudyInfo iStudyInfo2 : list2) {
            hashSet.add(iStudyInfo2.getKey());
        }
        iStudyInfo2 = list.listIterator();
        while (iStudyInfo2.hasNext()) {
            if (!hashSet.contains(((IStudyInfo)iStudyInfo2.next()).getKey())) continue;
            iStudyInfo2.remove();
        }
        return list;
    }

    protected abstract List<IStudyInfo> getRelevantPriors(List<IStudyInfo> var1, IStudyInfo var2);

    private static enum ArchiveType {
        Agfa,
        Dicom,
        NotSearchable;

    }

    private static class DummySearchThread
    implements ISearchThread {
        private IRootInfo root;

        public DummySearchThread(IRootInfo iRootInfo) {
            this.root = iRootInfo;
        }

        @Override
        public boolean isRunning() {
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public IRootInfo getResult() {
            return this.root;
        }
    }

    private class PriorSearchHandler
    implements SearchHandlerListener,
    Cancelable {
        private List<IRelevancyListener> listeners;
        private String mainStudyKey;
        private String patientKey;
        private String issuerOfPatientID = null;
        private List<IStudyInfo> baseStudies;
        private Cancelable searchCancel = null;
        private boolean isCanceled = false;
        private boolean coercePatientName = false;
        private IPatientInfo patient = null;
        private boolean evaluateRelevancy = true;
        private String cacheKey = null;

        public PriorSearchHandler(List<IStudyInfo> list, IPatientInfo iPatientInfo, List<IRelevancyListener> list2, boolean bl) {
            this.mainStudyKey = list.isEmpty() ? null : list.get(0).getKey();
            this.patientKey = iPatientInfo.getKey();
            this.issuerOfPatientID = iPatientInfo.getString(0x100021);
            if (bl) {
                this.patient = iPatientInfo;
            }
            this.coercePatientName = bl;
            this.baseStudies = list;
            this.listeners = list2;
        }

        public void setCacheKey(String string) {
            this.cacheKey = string;
        }

        public PriorSearchHandler(IPatientInfo iPatientInfo, List<IRelevancyListener> list) {
            this(Collections.emptyList(), iPatientInfo, list, false);
            this.evaluateRelevancy = false;
        }

        void setCancelSearch(Cancelable cancelable) {
            this.searchCancel = cancelable;
        }

        public void cancel() {
            this.isCanceled = true;
            if (this.searchCancel != null) {
                this.searchCancel.cancel();
            }
            this.searchCancel = null;
            for (IRelevancyListener iRelevancyListener : this.listeners) {
                iRelevancyListener.searchFinished(this.patientKey, this.mainStudyKey, true);
            }
        }

        @Override
        public void searchStarted(ISearchHandler iSearchHandler, ISearchThread iSearchThread) {
        }

        @Override
        public void searchFinished(ISearchHandler iSearchHandler, ISearchThread iSearchThread) {
            List list = this.getWholePatient(iSearchThread);
            if (this.evaluateRelevancy) {
                IStudyInfo iStudyInfo = this.getMainStudy();
                if (iStudyInfo != null) {
                    list = AbstractPriorsHook.this.removeAll(list, Collections.singletonList(iStudyInfo));
                }
                List<IStudyInfo> list2 = Collections.emptyList();
                if (iStudyInfo != null) {
                    list2 = AbstractPriorsHook.this.getRelevantPriors(list, this.baseStudies.get(0));
                }
                if (!this.isCanceled) {
                    for (IRelevancyListener iRelevancyListener : this.listeners) {
                        iRelevancyListener.relevantFound(this.patientKey, this.mainStudyKey, list2);
                    }
                    this.searchCancel = null;
                    for (IRelevancyListener iRelevancyListener : this.listeners) {
                        iRelevancyListener.searchFinished(this.patientKey, this.mainStudyKey, false);
                    }
                }
            }
            this.searchCancel = null;
        }

        @Override
        public void searchSuccess(ISearchHandler iSearchHandler, ISearchThread iSearchThread, IDataInfoSource iDataInfoSource, IDataInfo iDataInfo) {
            if (!this.coercePatientName) {
                List list = DataInfoUtilities.getLevel((IDataInfo)iDataInfo, IPatientInfo.class);
                for (IPatientInfo iPatientInfo : list) {
                    if (CompareUtils.equals((Object)iPatientInfo.getString(0x100021), (Object)this.issuerOfPatientID)) continue;
                    iDataInfo.removeChild((IDataInfo)iPatientInfo);
                }
            }
            new Sender(iDataInfo).start();
        }

        @Override
        public void searchFailure(ISearchHandler iSearchHandler, ISearchThread iSearchThread, IDataInfoSource iDataInfoSource, Throwable throwable) {
            if (Base.getMasterDataNode() != null) {
                SendError.sendPixManagerError(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<IStudyInfo> getWholePatient(ISearchThread iSearchThread) {
            Object object;
            IRootInfo iRootInfo = iSearchThread.getResult();
            if (iRootInfo == null) {
                return Collections.emptyList();
            }
            if (this.cacheKey != null) {
                object = AbstractPriorsHook.this;
                synchronized (object) {
                    if (!Objects.equals(AbstractPriorsHook.this.cacheKey, this.cacheKey)) {
                        AbstractPriorsHook.this.cacheKey = this.cacheKey;
                        AbstractPriorsHook.this.cachedResult = DataInfoUtilities.getRoot((IDataInfo)((IDataInfo)DataInfoUtilities.cloneData(Collections.singletonList(iRootInfo), (boolean)true).get(0)));
                    }
                }
            }
            if ((object = DataInfoUtilities.getLevel((IDataInfo)iRootInfo, IPatientInfo.class)).isEmpty()) {
                return Collections.emptyList();
            }
            List list = DataInfoUtilities.getLevel((Collection)object, IStudyInfo.class);
            return new Vector<IStudyInfo>(list);
        }

        private IStudyInfo getMainStudy() {
            if (this.baseStudies.isEmpty()) {
                return null;
            }
            return this.baseStudies.get(0);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Messages.getString("AbstractPriorsHook.SearchingIn"));
            stringBuilder.append(' ');
            if (AbstractPriorsHook.this.isSearchInAllNodes()) {
                stringBuilder.append(Messages.getString("AbstractPriorsHook.AllNodes"));
            } else {
                IStudyInfo iStudyInfo = this.getMainStudy();
                if (iStudyInfo != null) {
                    stringBuilder.append(iStudyInfo.getSource().getIdentifier().getName());
                }
                if (AbstractPriorsHook.this.getAdditionalSearchNode() != null) {
                    stringBuilder.append(' ');
                    stringBuilder.append(Messages.getString("AbstractPriorsHook.and"));
                    stringBuilder.append(' ');
                    stringBuilder.append(AbstractPriorsHook.this.getAdditionalSearchNode().getName());
                }
            }
            return stringBuilder.toString();
        }

        public boolean isRunning() {
            return this.searchCancel != null;
        }

        private class Sender
        extends Thread {
            private IDataInfo root;

            public Sender(IDataInfo iDataInfo) {
                this.root = iDataInfo;
            }

            @Override
            public void run() {
                List list = DataInfoUtilities.getLevel((IDataInfo)this.root, IStudyInfo.class);
                if (PriorSearchHandler.this.coercePatientName) {
                    PatientMergeUtilities.addMPIStudiesToPatient((IPatientInfo)PriorSearchHandler.this.patient, (List)list);
                }
                for (IRelevancyListener iRelevancyListener : PriorSearchHandler.this.listeners) {
                    ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>(list);
                    iRelevancyListener.studiesFound(PriorSearchHandler.this.patientKey, arrayList);
                }
            }
        }
    }
}

