/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.search;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.DataInfoNodeUtilities;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.lta.datafinder.IDataFinder;
import com.agfa.pacs.listtext.lta.filter.FilterEntryCriterion;
import com.agfa.pacs.listtext.lta.filter.FilterEntryTypes;
import com.agfa.pacs.listtext.lta.filter.FilterHelper;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.filter.SimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedFilter;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionFactory;
import com.agfa.pacs.listtext.lta.search.SearchHandler;
import com.agfa.pacs.listtext.lta.search.SearchThread;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class SearchDataFinder
implements IDataFinder {
    private static final ALogger log = ALogger.getLogger(SearchDataFinder.class);
    public static final String DATA_FINDER_TYPE = "SEARCH";

    @Override
    public String getType() {
        return DATA_FINDER_TYPE;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private AdvancedFilter buildFilter(String string, String string2, String string3, String string4) {
        FilterEntryCriterion filterEntryCriterion;
        AdvancedFilter advancedFilter = new AdvancedFilter("Search for study");
        if (string != null) {
            filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100020);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string}));
        }
        if (string2 != null) {
            filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100021);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string2}));
        }
        if (string3 != null) {
            filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000D);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Study, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string3}));
        }
        if (string4 != null) {
            filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(524368);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Study, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string4}));
        }
        return advancedFilter;
    }

    private List<IStudyInfo> performSearch(AdvancedFilter advancedFilter, boolean bl) {
        Collection<IDataInfoNode> collection = this.getSearchNodes(bl);
        return this.performSearch(advancedFilter, collection);
    }

    private List<IStudyInfo> performSearch(AdvancedFilter advancedFilter, boolean bl, boolean bl2) {
        List<Object> list = this.performSearch(advancedFilter, bl);
        if (bl2) {
            list = list.stream().filter(this::isImageStudy).collect(Collectors.toList());
        }
        return list;
    }

    private List<IStudyInfo> performSearch(AdvancedFilter advancedFilter, Collection<? extends IDataInfoSource> collection) {
        IDataInfoNode iDataInfoNode = Base.getMasterDataNode();
        for (IDataInfoSource iDataInfoSource : collection) {
            SearchHandler searchHandler = new SearchHandler();
            searchHandler.addDataInfoSource(iDataInfoSource);
            Cancelable cancelable = searchHandler.search(advancedFilter, null, false);
            IRootInfo iRootInfo = ((SearchThread)cancelable).getResult();
            if (iRootInfo == null || iRootInfo.children().isEmpty()) continue;
            if (iDataInfoSource == iDataInfoNode) {
                this.handleMPIOverRIS((IDataInfo)iRootInfo, iDataInfoNode);
            }
            return DataInfoUtilities.getLevel((IDataInfo)iRootInfo, IStudyInfo.class);
        }
        return Collections.emptyList();
    }

    @Override
    public List<IStudyInfo> findStudies(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        if (string3 == null && string4 == null) {
            return null;
        }
        List<IStudyInfo> list = Collections.emptyList();
        AdvancedFilter advancedFilter = null;
        if (string3 != null) {
            advancedFilter = this.buildFilter(string, string2, string3, null);
            list = this.performSearch(advancedFilter, bl, bl2);
        }
        if (CollectionUtils.isEmpty(list) && string4 != null && string != null && !(advancedFilter = this.buildFilter(string, string2, null, string4)).isEmpty()) {
            list = this.performSearch(advancedFilter, bl, bl2);
        }
        return list;
    }

    private boolean isImageStudy(IStudyInfo iStudyInfo) {
        String[] stringArray;
        String[] stringArray2 = stringArray = iStudyInfo.getAttributes().getStrings(524385);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (!string.equals("PR") && !string.equals("SR")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void handleMPIOverRIS(IDataInfo iDataInfo, IDataInfoNode iDataInfoNode) {
        List list = DataInfoUtilities.getLevel((IDataInfo)iDataInfo, IPatientInfo.class);
        for (IPatientInfo iPatientInfo : list) {
            Attributes attributes = iPatientInfo.getAttributes();
            IPersistantFilter iPersistantFilter = FilterUtilities.getEverythingForPatient(attributes.getString(0x100020, null), attributes.getString(0x100021, null));
            List list2 = DataInfoUtilities.getLevel((IDataInfo)FilterHelper.performSyncSearch(iPersistantFilter, (IDataInfoSource)iDataInfoNode), IPatientInfo.class);
            if (list2.size() == 1) {
                IPatientInfo iPatientInfo2 = (IPatientInfo)list2.get(0);
                if (CompareUtils.equals((Object)iPatientInfo2.getAttributes().getString(0x100020, null), (Object)attributes.getString(0x100020, null)) && CompareUtils.equals((Object)iPatientInfo2.getAttributes().getString(0x100021, null), (Object)attributes.getString(0x100021, null))) {
                    Sequence sequence = iPatientInfo2.getAttributes().getSequence(0x101002);
                    attributes.setValue(0x101002, VR.SQ, (Object)sequence);
                    continue;
                }
                log.warn("Incorrect patient returned from MPI");
                continue;
            }
            log.warn("Multiple patient returned from MPI");
        }
    }

    @Override
    public List<IStudyInfo> findStudy(String string, List<IDataInfoSource> list) {
        if (string == null) {
            return Collections.emptyList();
        }
        AdvancedFilter advancedFilter = null;
        advancedFilter = this.buildFilter(null, null, string, null);
        return this.performSearch(advancedFilter, list);
    }

    private Collection<IDataInfoNode> getSearchNodes(boolean bl) {
        return DataInfoNodeUtilities.getSearchNodes(Base.getDataNodesForServices(), (boolean)bl);
    }
}

