/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.search;

import com.agfa.pacs.data.shared.filter.FilterTag;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.lta.search.ISearchHandler;
import com.agfa.pacs.listtext.lta.search.SearchHandlerListener;
import com.agfa.pacs.listtext.lta.search.SearchThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SearchHandler
implements ISearchHandler {
    private Map<String, IDataInfoSource> dataInfoSources = new LinkedHashMap<String, IDataInfoSource>();
    private boolean sourcesPresorted = false;

    @Override
    public void addDataInfoSource(IDataInfoSource iDataInfoSource) {
        if (!this.dataInfoSources.containsKey(iDataInfoSource.toString())) {
            this.dataInfoSources.put(iDataInfoSource.toString(), iDataInfoSource);
        }
    }

    @Override
    public void removeDataInfoSource(IDataInfoSource iDataInfoSource) {
        this.dataInfoSources.remove(iDataInfoSource.toString());
    }

    @Override
    public void removeAllDataInfoSources() {
        this.dataInfoSources.clear();
    }

    @Override
    public List<IDataInfoSource> getDataInfoSources() {
        return new ArrayList<IDataInfoSource>(this.dataInfoSources.values());
    }

    @Override
    public Cancelable search(IFilter iFilter, SearchHandlerListener searchHandlerListener, boolean bl) {
        SearchThread searchThread = new SearchThread(this, this.dataInfoSources.values(), iFilter, searchHandlerListener, this.getName());
        searchThread.setSourcesPresorted(this.sourcesPresorted);
        if (bl) {
            searchThread.start();
        } else {
            searchThread.run();
        }
        return searchThread;
    }

    @Override
    public Cancelable search(IFilter iFilter, SearchHandlerListener searchHandlerListener) {
        return this.search(iFilter, searchHandlerListener, true);
    }

    private String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.dataInfoSources.isEmpty()) {
            return stringBuilder.toString();
        }
        Iterator<IDataInfoSource> iterator = this.dataInfoSources.values().iterator();
        IDataInfoSource iDataInfoSource = iterator.next();
        stringBuilder.append(iDataInfoSource);
        while (iterator.hasNext()) {
            iDataInfoSource = iterator.next();
            stringBuilder.append(", ").append(iDataInfoSource.toString());
        }
        return stringBuilder.toString();
    }

    public List<FilterTag> getCommonSearchFilterTags() {
        if (this.dataInfoSources.isEmpty()) {
            return null;
        }
        ArrayList arrayList = null;
        for (IDataInfoSource iDataInfoSource : this.dataInfoSources.values()) {
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.addAll(iDataInfoSource.getSearchTags());
                continue;
            }
            arrayList.retainAll(iDataInfoSource.getSearchTags());
        }
        return arrayList;
    }

    public List<FilterTag> getAllSearchFilterTags() {
        if (this.dataInfoSources.isEmpty()) {
            return null;
        }
        ArrayList<FilterTag> arrayList = new ArrayList<FilterTag>();
        for (IDataInfoSource iDataInfoSource : this.dataInfoSources.values()) {
            List list = iDataInfoSource.getSearchTags();
            for (FilterTag filterTag : list) {
                if (arrayList.contains(filterTag)) continue;
                arrayList.add(filterTag);
            }
        }
        return arrayList;
    }

    public void setSourcesPresorted(boolean bl) {
        this.sourcesPresorted = bl;
    }

    public List<FilterTag> getCommonResultFilterTags() {
        if (this.dataInfoSources.isEmpty()) {
            return null;
        }
        ArrayList arrayList = null;
        for (IDataInfoSource iDataInfoSource : this.dataInfoSources.values()) {
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.addAll(iDataInfoSource.getResultTags());
                continue;
            }
            arrayList.retainAll(iDataInfoSource.getResultTags());
        }
        return arrayList;
    }

    public List<FilterTag> getAllResultFilterTags() {
        if (this.dataInfoSources.isEmpty()) {
            return null;
        }
        ArrayList<FilterTag> arrayList = new ArrayList<FilterTag>();
        for (IDataInfoSource iDataInfoSource : this.dataInfoSources.values()) {
            List list = iDataInfoSource.getResultTags();
            for (FilterTag filterTag : list) {
                if (arrayList.contains(filterTag)) continue;
                arrayList.add(filterTag);
            }
        }
        return arrayList;
    }
}

