/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.search;

import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.filter.FilterModifiers;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.DataInfoFactoryProvider;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.QueryCancelException;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.exceptionhandler.ExceptionHandlerFactory;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.ISimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedFilter;
import com.agfa.pacs.listtext.lta.filter.advanced.IAdvancedFilterEntry;
import com.agfa.pacs.listtext.lta.search.ISearchHandler;
import com.agfa.pacs.listtext.lta.search.ISearchThread;
import com.agfa.pacs.listtext.lta.search.SearchHandlerListener;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.dcm4che3.data.VR;

public class SearchThread
implements Cancelable,
ISearchThread,
Runnable {
    private static final ALogger log = ALogger.getLogger(SearchThread.class);
    private static final DataNodeSorter sorter = new DataNodeSorter();
    private IFilter filter;
    private SearchHandlerListener listener;
    private String name;
    private List<IDataInfoSource> dataInfoSources;
    private ISearchHandler searchHandler;
    private boolean sourcesPresorted = false;
    private IRootInfo result;
    private boolean running;

    public SearchThread(ISearchHandler iSearchHandler, Collection<? extends IDataInfoSource> collection, IFilter iFilter, SearchHandlerListener searchHandlerListener, String string) {
        this.searchHandler = iSearchHandler;
        this.dataInfoSources = new ArrayList<IDataInfoSource>(collection);
        Iterator<? extends IDataInfoSource> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
        this.filter = iFilter;
        this.listener = searchHandlerListener;
        this.name = string;
    }

    public String getName() {
        return "Search:" + this.name;
    }

    public void start() {
        new Thread((Runnable)this, this.getName()).start();
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public IRootInfo getResult() {
        return this.result;
    }

    public void setSourcesPresorted(boolean bl) {
        this.sourcesPresorted = bl;
    }

    public void notifySearchStarted() {
        if (this.listener != null) {
            this.listener.searchStarted(this.searchHandler, this);
        }
    }

    public void notifySearchFinished() {
        if (this.listener != null) {
            this.listener.searchFinished(this.searchHandler, this);
        }
    }

    public void notifySearchSuccess(IDataInfoSource iDataInfoSource, IDataInfo iDataInfo) {
        if (this.listener != null) {
            this.listener.searchSuccess(this.searchHandler, this, iDataInfoSource, iDataInfo);
        }
    }

    public void notifySearchFailure(IDataInfoSource iDataInfoSource, Throwable throwable) {
        ExceptionHandlerFactory.getInstance().handleException(throwable);
        if (this.listener != null) {
            this.listener.searchFailure(this.searchHandler, this, iDataInfoSource, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        List<IDataInfoSource> list = this.dataInfoSources;
        synchronized (list) {
            try {
                this.result = DataInfoFactoryProvider.getInstance().createRootInfo("Search on Nodes " + this.name);
                this.notifySearchStarted();
                if (!this.sourcesPresorted) {
                    Collections.sort(this.dataInfoSources, sorter);
                }
                boolean bl = true;
                for (IDataInfoSource iDataInfoSource : this.dataInfoSources) {
                    if (!this.running) break;
                    try {
                        IRootInfo iRootInfo = this.doSearch(this.filter, iDataInfoSource);
                        if (bl) {
                            bl = false;
                            this.result = iRootInfo;
                            this.result.setName("Search on Nodes " + this.name);
                        } else {
                            DataInfoUtilities.mergeRoots((IRootInfo)this.result, (IRootInfo)iRootInfo);
                        }
                        this.notifySearchSuccess(iDataInfoSource, (IDataInfo)iRootInfo);
                    }
                    catch (Exception exception) {
                        if (exception instanceof QueryCancelException) continue;
                        log.error("Search error", (Throwable)exception);
                        this.notifySearchFailure(iDataInfoSource, exception);
                    }
                }
                this.notifySearchFinished();
            }
            catch (Exception exception) {
                log.error("Search Thread", (Throwable)exception);
            }
        }
    }

    @Override
    public void cancel() {
        this.running = false;
        for (IDataInfoSource iDataInfoSource : this.dataInfoSources) {
            if (!(iDataInfoSource instanceof IDataInfoNode)) continue;
            ((IDataInfoNode)iDataInfoSource).cancelQuery();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected IRootInfo doSearch(IFilter iFilter, IDataInfoSource iDataInfoSource) throws Exception {
        Object object;
        Boolean bl = (Boolean)iFilter.getModifierValue(FilterModifiers.SemanticPNMatchingRequested);
        if (bl != null && Boolean.TRUE.equals(bl) && iFilter instanceof AdvancedFilter && (object = ((AdvancedFilter)(iFilter = iFilter.cloneFilter())).getEntries()) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                VR vR;
                IAdvancedFilterEntry iAdvancedFilterEntry = (IAdvancedFilterEntry)iterator.next();
                List<ISimpleFilterEntry> list = iAdvancedFilterEntry.isEnabled() ? iAdvancedFilterEntry.getEntries() : null;
                VR vR2 = vR = list != null && !list.isEmpty() ? list.get(0).getCriterion().getVR() : null;
                if (vR == null || !vR.equals((Object)VR.PN) || !iAdvancedFilterEntry.isPerformingOnClient(iDataInfoSource.getIdentifier().isEnabled(NodeProperty.ORQueriesSupported), true)) continue;
                iFilter.putModifierValue(FilterModifiers.SemanticPNMatchingRequested, (Object)false);
                iFilter.putModifierValue(FilterUtilities.SemanticPNMatchingRequestedSystemOverride, (Object)true);
                break;
            }
        }
        if (log.isDebugEnabled()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("------ start searching --------\n");
            ((StringBuilder)object).append("Archive: ").append(iDataInfoSource).append('\n');
            ((StringBuilder)object).append("Leaf Level: ").append(iFilter.getLeafLevel()).append('\n');
            ((StringBuilder)object).append("Cut Level: ").append(iFilter.getCutLevel()).append('\n');
            ((StringBuilder)object).append("Expand Level: ").append(iFilter.getExpandLevel()).append('\n');
            ((StringBuilder)object).append("Filter: ").append(iFilter.getAsDicomObject());
            log.debug(((StringBuilder)object).toString());
        }
        object = iDataInfoSource.getDataInfo(iFilter);
        if (iFilter instanceof AdvancedFilter) {
            object = ((AdvancedFilter)iFilter).filterOnClient((IRootInfo)object, iDataInfoSource.getSearchTags() == null, iDataInfoSource.getIdentifier().isEnabled(NodeProperty.ORQueriesSupported));
        }
        if (log.isDebugEnabled()) {
            log.debug("------ searching finished ------");
        }
        return object;
    }

    private static class DataNodeSorter
    implements Comparator<IDataInfoSource> {
        private DataNodeSorter() {
        }

        @Override
        public int compare(IDataInfoSource iDataInfoSource, IDataInfoSource iDataInfoSource2) {
            if (iDataInfoSource instanceof IDataInfoNode && iDataInfoSource2 instanceof IDataInfoNode) {
                return ((IDataInfoNode)iDataInfoSource).getOrderId() - ((IDataInfoNode)iDataInfoSource2).getOrderId();
            }
            if (iDataInfoSource instanceof IDataInfoNode) {
                return 1;
            }
            if (iDataInfoSource2 instanceof IDataInfoNode) {
                return -1;
            }
            return 0;
        }
    }
}

