/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.service;

import com.agfa.integration.IntegrationFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.logging.ALogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ServiceConfiguration {
    private static final ALogger log = ALogger.getLogger(ServiceConfiguration.class);
    private static final String ROOT = "listtext.service";
    private Map<String, Properties> configuredActors = new HashMap<String, Properties>();

    public ServiceConfiguration(IConfigurationProvider iConfigurationProvider) {
        IConfigurationList iConfigurationList = iConfigurationProvider.getList("listtext.service.actors");
        for (IConfigurationProvider iConfigurationProvider2 : iConfigurationList) {
            try {
                String string = iConfigurationProvider2.getString("type");
                String[] stringArray = IntegrationFactory.getPropertiesForActor((String)string);
                if (stringArray == null) continue;
                Properties properties = null;
                properties = iConfigurationProvider2.exists("properties") ? this.readProperties(iConfigurationProvider2.getNode("properties"), stringArray, IntegrationFactory.getDefaultsForActor((String)string)) : new Properties();
                if (properties == null) continue;
                this.configuredActors.put(string, properties);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn("Incorrect actor configured", (Throwable)illegalArgumentException);
            }
        }
    }

    private Properties readProperties(IConfigurationProvider iConfigurationProvider, String[] stringArray, String[] stringArray2) {
        Properties properties = new Properties();
        int n = 0;
        while (n < stringArray.length) {
            if (!iConfigurationProvider.exists(stringArray[n])) {
                if (stringArray2[n] != null) {
                    properties.put(stringArray[n], stringArray2[n]);
                }
            } else {
                properties.put(stringArray[n], iConfigurationProvider.getString(stringArray[n]));
            }
            ++n;
        }
        return properties;
    }

    public boolean isActorActive(String string) {
        return this.configuredActors.containsKey(string);
    }

    public Properties getActorProperties(String string) {
        return this.configuredActors.get(string);
    }
}

