/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.store;

import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.export.BackgroundProcessingTask;
import com.agfa.pacs.data.shared.util.WaitCancelable;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import com.agfa.pacs.listtext.lta.store.AbstractStoreHandler;
import com.agfa.pacs.logging.ALogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class StorageHandler
extends AbstractStoreHandler
implements WaitCancelable,
PropertyChangeListener {
    private static final ALogger LOGGER = ALogger.getLogger(StorageHandler.class);
    private final BackgroundProcessingTask task;
    private final IBackgroundTask task2;
    private final ProgressStateModel psModel;

    public StorageHandler(BackgroundProcessingTask backgroundProcessingTask, IBackgroundTask iBackgroundTask, ProgressStateModel progressStateModel) {
        this.task = backgroundProcessingTask;
        this.task2 = iBackgroundTask;
        this.psModel = progressStateModel;
        this.psModel.addPropertyChangeListener(this);
    }

    public void waitUntilFinished() {
        this.task.waitUntilFinished();
    }

    public void cancel() {
        this.task2.terminate();
    }

    public boolean isRunning() {
        return this.psModel.getProgressState() != JobState.FINISHED;
    }

    public JobState getProgressState() {
        return this.psModel.getProgressState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            LOGGER.error("PropertyChangeEvent evt is null", (Throwable)new Exception());
        } else if (propertyChangeEvent.getPropertyName() == null) {
            LOGGER.error("evt.getPropertyName() returns null", (Throwable)new Exception());
        } else if (this.hasListeners() && propertyChangeEvent.getPropertyName().equals("PROGRESS_STATE_CHANGED")) {
            JobState jobState = (JobState)propertyChangeEvent.getNewValue();
            this.informListeners(jobState);
        }
    }
}

