/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.store;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.store.INewObjectListener;
import com.agfa.pacs.data.shared.store.ISendNode;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.data.shared.store.IStoreProvider;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.listtext.integration.dicomsend.DicomStoreConfigurationFactory;
import com.agfa.pacs.listtext.integration.dicomsend.IDicomStoreConfiguration;
import com.agfa.pacs.listtext.lta.deletion.DeletionUtils;
import com.agfa.pacs.listtext.lta.store.StorageHandler;
import com.agfa.pacs.listtext.lta.store.StoreUtils;
import com.agfa.pacs.listtext.lta.util.MissingStorageTarget;
import com.agfa.pacs.listtext.lta.util.SendError;
import com.agfa.pacs.logging.ALogger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.dcm4che3.data.Attributes;

public class StoreProvider
implements IStoreProvider {
    private static final ALogger log = ALogger.getLogger(StoreProvider.class);
    private List<WeakReference<INewObjectListener>> objectListeners = new Vector<WeakReference<INewObjectListener>>();

    public boolean supportsWorklists() {
        return false;
    }

    public Collection<IWorklistContext> getAvailableWorklistContexts() {
        return new ArrayList<IWorklistContext>(0);
    }

    public boolean storeObjects(IDataInfoSource iDataInfoSource, Attributes ... attributesArray) {
        return StoreUtils.storeObjects(iDataInfoSource, attributesArray);
    }

    public boolean storeObjects(ISendNode iSendNode, boolean bl, Attributes ... attributesArray) {
        return this.storeObjectsImpl(iSendNode, bl, attributesArray);
    }

    public boolean storeObjects(IStudyInfo iStudyInfo, boolean bl, Attributes ... attributesArray) {
        ISendNode iSendNode = this.inferStoreTargetNode(iStudyInfo);
        if (iSendNode == null) {
            log.error("Inferring store target node failed.");
            return false;
        }
        return this.storeObjectsImpl(iSendNode, bl, attributesArray);
    }

    public IStoreHandler store(Collection<? extends IObjectInfo> collection, ISendNode iSendNode, Collection<IWorklistContext> collection2) {
        return this.storeImpl(iSendNode, collection2, collection);
    }

    public ISendNode inferStoreTargetNode(IStudyInfo iStudyInfo) {
        IDicomStoreConfiguration iDicomStoreConfiguration = DicomStoreConfigurationFactory.getConfiguration();
        return iDicomStoreConfiguration.getPreferedNode(this.getSource(iStudyInfo));
    }

    public IStoreHandler store(Collection<? extends IObjectInfo> collection, IStudyInfo iStudyInfo, Collection<IWorklistContext> collection2) {
        ISendNode iSendNode = null;
        iSendNode = this.inferStoreTargetNode(iStudyInfo);
        if (iSendNode == null) {
            log.error("Inferring store target node failed");
            return null;
        }
        return this.storeImpl(iSendNode, collection2, collection);
    }

    public boolean deleteInstances(List<IObjectInfo> list) {
        return DeletionUtils.deleteInstances(list);
    }

    private Collection<INewObjectListener> getListeners() {
        ArrayList<INewObjectListener> arrayList = new ArrayList<INewObjectListener>();
        Iterator<WeakReference<INewObjectListener>> iterator = this.objectListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<INewObjectListener> weakReference = iterator.next();
            INewObjectListener iNewObjectListener = (INewObjectListener)weakReference.get();
            if (iNewObjectListener == null) {
                iterator.remove();
                continue;
            }
            arrayList.add(iNewObjectListener);
        }
        return arrayList;
    }

    protected IStoreHandler storeImpl(ISendNode iSendNode, Collection<IWorklistContext> collection, Collection<? extends IObjectInfo> collection2) {
        if (iSendNode == null) {
            SendError.sendErrorMessage(new MissingStorageTarget());
            log.error("Could not store object, target unknown");
            return null;
        }
        log.debug("Storing " + collection2.size() + " data objects using node " + iSendNode.toString());
        Map<IDataInfo, IDataInfoSource> map = this.updateSources(collection2, iSendNode);
        StorageHandler storageHandler = StoreUtils.store(iSendNode, new ArrayList<IObjectInfo>(collection2), this.compileStoreDescription(collection2, iSendNode));
        JobState jobState2 = storageHandler.getProgressState();
        if (jobState2.isRunning()) {
            storageHandler.addStoreListener(jobState -> {
                block4: {
                    block3: {
                        if (jobState != JobState.RETIRED && jobState != JobState.FAILED && jobState != JobState.CANCELLED) break block3;
                        for (Map.Entry entry : map.entrySet()) {
                            ((IDataInfo)entry.getKey()).setSource((IDataInfoSource)entry.getValue());
                        }
                        break block4;
                    }
                    if (jobState != JobState.FINISHED) break block4;
                    for (INewObjectListener iNewObjectListener : this.getListeners()) {
                        for (IObjectInfo iObjectInfo : collection2) {
                            iNewObjectListener.objectCreated(iObjectInfo);
                        }
                    }
                }
            });
        }
        return storageHandler;
    }

    protected boolean storeObjectsImpl(ISendNode iSendNode, boolean bl, Attributes ... attributesArray) {
        if (iSendNode == null) {
            SendError.sendErrorMessage(new MissingStorageTarget());
            log.error("Storing DICOM objects failed, target unknown.");
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Storing {} DICOM objects using node {}", (Object)attributesArray.length, (Object)iSendNode);
        }
        try {
            StoreUtils.storeObjects((IDicomNode)iSendNode, bl, attributesArray);
            return true;
        }
        catch (DicomException dicomException) {
            log.error("Storing DICOM objects failed.", (Throwable)dicomException);
            return false;
        }
    }

    private IDataInfoSource getSource(IStudyInfo iStudyInfo) {
        if (iStudyInfo != null) {
            if (iStudyInfo.getSource() != null) {
                return iStudyInfo.getSource();
            }
            IPatientInfo iPatientInfo = (IPatientInfo)iStudyInfo.getTreeParent();
            if (iPatientInfo != null) {
                return iPatientInfo.getSource();
            }
        }
        return null;
    }

    protected Map<IDataInfo, IDataInfoSource> updateSources(Collection<? extends IObjectInfo> collection, ISendNode iSendNode) {
        if (collection != null && iSendNode != null) {
            HashMap<IDataInfo, IDataInfoSource> hashMap = new HashMap<IDataInfo, IDataInfoSource>(collection.size());
            for (IDataInfo iDataInfo : collection) {
                IDataInfoSource iDataInfoSource = iDataInfo.getSource();
                hashMap.put(iDataInfo, iDataInfoSource);
                if (!StoreUtils.isUnsupportedSource(iDataInfoSource)) continue;
                log.debug("Stored object has unsupported source ('" + iDataInfoSource + "') ...attempting to resolve supported source");
                IDataInfo iDataInfo2 = iDataInfo.getTreeParent();
                iDataInfo.setSource(iDataInfo2.getSource());
                IDataInfoSource iDataInfoSource2 = StoreUtils.findSourceForTarget(iSendNode, iDataInfo2 != null ? iDataInfo2.getSource() : null);
                if (iDataInfoSource2 != null) {
                    iDataInfo.setSource(iDataInfoSource2);
                    log.debug("Source node has been set to resolved query-node '" + iDataInfoSource2.getIdentifier().getName() + "'");
                    continue;
                }
                log.warn("Unable to resolve store node " + iSendNode.getName());
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    private String compileStoreDescription(Collection<? extends IObjectInfo> collection, ISendNode iSendNode) {
        return "Storing " + collection.size() + " data objects";
    }

    public void addListener(INewObjectListener iNewObjectListener) {
        this.objectListeners.add(new WeakReference<INewObjectListener>(iNewObjectListener));
    }

    public void removeListener(INewObjectListener iNewObjectListener) {
        for (WeakReference<INewObjectListener> weakReference : this.objectListeners) {
            INewObjectListener iNewObjectListener2 = (INewObjectListener)weakReference.get();
            if (iNewObjectListener2 == null || iNewObjectListener != iNewObjectListener2) continue;
            this.objectListeners.remove(weakReference);
            break;
        }
    }
}

