/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.store;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.comm.DicomCompositeCStoreSCU;
import com.agfa.pacs.data.export.AuditProcessor;
import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.IDicomWebNode;
import com.agfa.pacs.data.shared.dicom.SimpleDicomNode;
import com.agfa.pacs.data.shared.export.BackgroundProcessingTask;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.store.ISendNode;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.data.shared.store.IStoreListener;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.integration.dicomsend.DicomStoreConfigurationFactory;
import com.agfa.pacs.listtext.integration.dicomsend.impl.DicomSendNode;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import com.agfa.pacs.listtext.lta.store.MPPSSender;
import com.agfa.pacs.listtext.lta.store.StorageHandler;
import com.agfa.pacs.listtext.lta.util.job.JobControl;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.logging.ALogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.dcm4che3.data.Attributes;

public class StoreUtils {
    private static final ALogger log = ALogger.getLogger(StoreUtils.class);
    static final String SESSION_CALLING_AET = "EESESSION";
    private static final boolean useSessionCallingAET = ConfigurationProviderFactory.getBaseConfig().getBoolean("listtext.useSpecialAETForSessions");
    private static boolean sendMPPS = ConfigurationProviderFactory.getBaseConfig().getBoolean("listtext.sendMPPS");
    private static final IDicomCache dicomCache = DicomCacheFactory.getInstance().getDicomCache();
    private static String AGILITY_STORE_ATTRIBUTES_PIPELINE = "AttributesStowRS";

    public static StorageHandler storeAttributes(IDataInfoSource iDataInfoSource, List<Attributes> list, String string) {
        return StoreUtils.storeAttributes((IDicomNode)DicomStoreConfigurationFactory.getConfiguration().getPreferedNode(iDataInfoSource), list, string);
    }

    public static StorageHandler storeAttributes(IDicomNode iDicomNode, List<Attributes> list, String string) {
        if (iDicomNode == null) {
            throw new IllegalStateException("Inferring store target node failed.");
        }
        BackgroundProcessingTask backgroundProcessingTask = new BackgroundProcessingTask(AGILITY_STORE_ATTRIBUTES_PIPELINE);
        backgroundProcessingTask.setInfo(string);
        Properties properties = new Properties();
        properties.put("DICOM_STORE_TARGET", iDicomNode);
        properties.put("SEND_IN_ONE_STOW_REQUEST", (Object)true);
        IBackgroundTask iBackgroundTask = backgroundProcessingTask.createTask(list, properties, null);
        JobControl jobControl = new JobControl(iBackgroundTask.getInfo(), iDicomNode.toString(), new Attributes[0]);
        jobControl.addTask(iBackgroundTask);
        ProgressStateModel progressStateModel = jobControl.getModel();
        Thread thread = new Thread((Runnable)jobControl, "Store new instances");
        thread.setPriority(1);
        thread.start();
        return new StorageHandler(backgroundProcessingTask, iBackgroundTask, progressStateModel);
    }

    public static StorageHandler store(ISendNode iSendNode, List<IObjectInfo> list, String string) {
        Object object;
        MPPSSender mPPSSender = null;
        ISendNode iSendNode2 = iSendNode;
        boolean bl = false;
        boolean bl2 = iSendNode instanceof IDicomWebNode;
        if (useSessionCallingAET && list.size() == 1 && !bl2 && ReferringObjectType.SESSION.match((IDataInfo)list.get(0))) {
            object = "Session storage";
            iSendNode2 = new DicomSendNode((String)object, (IDicomNode)new SimpleDicomNode(iSendNode.getHost(), iSendNode.getPort(), iSendNode.getCalledAET(), SESSION_CALLING_AET, iSendNode.isEnabled(NodeProperty.Secure), !iSendNode.isEnabled(NodeProperty.KeepAlive), (String)object));
            bl = true;
        }
        if (sendMPPS && !bl2) {
            mPPSSender = new MPPSSender((IDicomNode)iSendNode, bl);
            mPPSSender.sendMPPSProgress(DataInfoUtilities.toAttributesMerged(list));
        }
        object = new Properties();
        BackgroundProcessingTask backgroundProcessingTask = new BackgroundProcessingTask("Retrieve->Transcode->Audit->Store");
        backgroundProcessingTask.setInfo(string);
        String string2 = iSendNode2.toString();
        ((Properties)object).put("DICOM_STORE_TARGET", iSendNode2);
        ((Properties)object).put("AUDIT_EXPORT_TARGET", string2);
        ((Properties)object).put("AUDIT_OPERATION", AuditProcessor.AuditEvent.DicomSend.name());
        IBackgroundTask iBackgroundTask = backgroundProcessingTask.createTask(list, (Properties)object, null);
        JobControl jobControl = new JobControl(iBackgroundTask.getInfo(), string2, list);
        jobControl.addTask(iBackgroundTask);
        ProgressStateModel progressStateModel = jobControl.getModel();
        Map map = DataInfoUtilities.forStudyManagment(list);
        dicomCache.registerStudyUsage(map);
        progressStateModel.storeStudyUsageRegistration(map);
        Thread thread = new Thread((Runnable)jobControl, "Store new objects");
        thread.setPriority(1);
        thread.start();
        if (sendMPPS && mPPSSender != null && mPPSSender.mppsInProgressWasSent()) {
            mPPSSender.setMppsComplete(DataInfoUtilities.getLevel(list, ISeriesInfo.class));
            if (!jobControl.addTask(mPPSSender)) {
                mPPSSender.execute();
            }
        }
        return new StorageHandler(backgroundProcessingTask, iBackgroundTask, progressStateModel);
    }

    public static boolean storeObjects(IDataInfoSource iDataInfoSource, Attributes ... attributesArray) {
        if (attributesArray == null || attributesArray.length == 0) {
            log.warn("Nothing to store.");
            return true;
        }
        ISendNode iSendNode = DicomStoreConfigurationFactory.getConfiguration().getPreferedNode(iDataInfoSource);
        if (iSendNode == null) {
            log.error("Inferring store target node failed.");
            return false;
        }
        try {
            StoreUtils.storeObjects((IDicomNode)iSendNode, attributesArray);
            return true;
        }
        catch (DicomException dicomException) {
            log.error("Saving DICOM objects failed.", (Throwable)dicomException);
            return false;
        }
    }

    public static void storeObjects(IDicomNode iDicomNode, Attributes ... attributesArray) throws DicomException {
        StoreUtils.storeObjects(iDicomNode, true, attributesArray);
    }

    public static void storeObjects(IDicomNode iDicomNode, boolean bl, Attributes ... attributesArray) throws DicomException {
        long l;
        long l2;
        String string;
        List<Attributes> list;
        boolean bl2;
        block17: {
            Attributes attributes = attributesArray[0];
            bl2 = attributes.getString(524310).equals("1.2.840.10008.5.1.4.1.1.88.59") && ReferringObjectType.REJECTED_FOR_QUALITY_REASONS.match(attributes);
            boolean bl3 = iDicomNode instanceof IDicomWebNode;
            list = Arrays.asList(attributesArray);
            if (bl && !bl2) {
                Audit.getInstance().logBeginSendDICOMInstances(iDicomNode.toString(), iDicomNode.getHost(), iDicomNode.getCalledAET(), null, null, null, list);
            }
            MPPSSender mPPSSender = null;
            if (sendMPPS && !bl2 && !bl3) {
                mPPSSender = new MPPSSender(iDicomNode);
                mPPSSender.sendMPPSProgress(list);
            }
            string = "8";
            l2 = System.currentTimeMillis();
            l = Long.MIN_VALUE;
            try {
                if (bl3) {
                    StoreUtils.awaitStore(Collections.singletonList(StoreUtils.storeAttributes(iDicomNode, list, "Storing DICOM object(s)...")));
                    l = System.currentTimeMillis();
                    string = "0";
                    break block17;
                }
                DicomCompositeCStoreSCU dicomCompositeCStoreSCU = null;
                String string2 = attributesArray[0].getString(524310);
                try {
                    dicomCompositeCStoreSCU = new DicomCompositeCStoreSCU(iDicomNode, string2);
                    dicomCompositeCStoreSCU.connect();
                    Attributes[] attributesArray2 = attributesArray;
                    int n = attributesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Attributes attributes2 = attributesArray2[n2];
                        dicomCompositeCStoreSCU.store(attributes2);
                        ++n2;
                    }
                    l = System.currentTimeMillis();
                    if (sendMPPS && mPPSSender != null && mPPSSender.mppsInProgressWasSent()) {
                        mPPSSender.setMppsComplete(attributesArray);
                        mPPSSender.execute();
                    }
                    string = "0";
                }
                catch (Throwable throwable) {
                    if (dicomCompositeCStoreSCU != null) {
                        try {
                            dicomCompositeCStoreSCU.close();
                        }
                        catch (DicomException dicomException) {}
                    }
                    throw throwable;
                }
                if (dicomCompositeCStoreSCU != null) {
                    try {
                        dicomCompositeCStoreSCU.close();
                    }
                    catch (DicomException dicomException) {}
                }
            }
            catch (Throwable throwable) {
                if (bl && !bl2) {
                    Audit.getInstance().logAuditMessage(Audit.getInstance().logSendedDICOMInstances(iDicomNode.toString(), iDicomNode.getHost(), iDicomNode.getCalledAET(), null, null, null, list, "0".equals(string) ? Long.valueOf(l - l2) : null), string);
                }
                throw throwable;
            }
        }
        if (bl && !bl2) {
            Audit.getInstance().logAuditMessage(Audit.getInstance().logSendedDICOMInstances(iDicomNode.toString(), iDicomNode.getHost(), iDicomNode.getCalledAET(), null, null, null, list, "0".equals(string) ? Long.valueOf(l - l2) : null), string);
        }
    }

    public static IDicomNode findSourceDicomNode(IDataInfoSource iDataInfoSource) {
        if (iDataInfoSource != null && iDataInfoSource.getIdentifier() instanceof IDicomNode) {
            return (IDicomNode)iDataInfoSource.getIdentifier();
        }
        return null;
    }

    public static IDataInfoSource findSourceForTarget(ISendNode iSendNode) {
        return StoreUtils.findSourceForTarget(iSendNode, null);
    }

    public static IDataInfoSource findSourceForTarget(ISendNode iSendNode, IDataInfoSource iDataInfoSource) {
        String string;
        String[] stringArray = Base.getDataInfoNodes().iterator();
        while (stringArray.hasNext()) {
            string = (IDataInfoSource)stringArray.next();
            if (!StoreUtils.equalsDicomSource(iSendNode, (IDataInfoSource)string) || StoreUtils.isUnsupportedSource((IDataInfoSource)string)) continue;
            log.debug("Resolved configured search/query archive '" + string.getIdentifier().getName() + "' for send-node '" + iSendNode.getName() + "'");
            return string;
        }
        string = iSendNode.getName();
        if (string != null && (stringArray = DicomStoreConfigurationFactory.getConfiguration().resolveSourceNodes(string)) != null) {
            if (stringArray.length > 1) {
                log.debug("Cannot resolve a mapped query-node for send-node '" + string + "': Mapping is not unique!");
            } else if (stringArray.length == 1) {
                IDataInfoNode iDataInfoNode = Base.getConfiguredDataInfoNodeByName(stringArray[0]);
                if (iDataInfoNode != null) {
                    log.debug("Resolved configured search/query archive '" + iDataInfoNode.getName() + "' from query->store-nodes mapping for send-node " + string);
                    return iDataInfoNode;
                }
                log.debug("Cannot resolve configured query/search archive for mapped query-node '" + stringArray[0] + "'");
            }
        }
        if (iDataInfoSource != null && StoreUtils.equalsDicomSource(iSendNode, iDataInfoSource)) {
            log.debug("Resolved parent source '" + iDataInfoSource.getIdentifier().getName() + "' for send-node '" + iSendNode.getName() + "'");
            return iDataInfoSource;
        }
        return null;
    }

    private static boolean equalsDicomSource(ISendNode iSendNode, IDataInfoSource iDataInfoSource) {
        if (iDataInfoSource != null && iDataInfoSource.getIdentifier() != null && iDataInfoSource.getIdentifier().getPropertiesOwner() instanceof IDicomNode) {
            IDicomNode iDicomNode = (IDicomNode)iDataInfoSource.getIdentifier().getPropertiesOwner();
            if (iSendNode.getHost().equalsIgnoreCase(iDicomNode.getHost()) && iSendNode.getCalledAET().equals(iDicomNode.getCalledAET())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnsupportedSource(IDataInfoSource iDataInfoSource) {
        return iDataInfoSource == null || iDataInfoSource.getIdentifier() == null || "DICOMPS".equals(iDataInfoSource.getIdentifier().getType()) || "DICOMCACHE".equals(iDataInfoSource.getIdentifier().getType()) || "IMPAXEE".equals(iDataInfoSource.getIdentifier().getType());
    }

    public static void awaitStore(List<IStoreHandler> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(list.size());
        IStoreListener iStoreListener = jobState -> {
            log.info("Store listener status changed to: " + jobState);
            switch (jobState) {
                case FINISHED: 
                case RETIRED: 
                case FAILED: {
                    countDownLatch.countDown();
                }
            }
        };
        for (IStoreHandler iStoreHandler : list) {
            iStoreHandler.addStoreListener(iStoreListener);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            log.error("Waiting for store handlers failed.", (Throwable)interruptedException);
        }
    }
}

