/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.listtext.async.AsyncWorkerPool;
import com.agfa.pacs.listtext.lta.util.WaitingUtil;
import com.agfa.pacs.logging.ALogger;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;

public class AsyncWaitingMonitor {
    private static final ALogger LOG = ALogger.getLogger(AsyncWaitingMonitor.class);
    private final WaitingUtil.IWaitingHandler handler;
    private final long maxWaitingTime;
    private final long pollingInterval;
    private final List<WaitingRunnable> waitingRunnables;
    private volatile boolean waitingAsync;

    public AsyncWaitingMonitor(WaitingUtil.IWaitingHandler iWaitingHandler, long l) {
        this(iWaitingHandler, l, 100L);
    }

    public AsyncWaitingMonitor(WaitingUtil.IWaitingHandler iWaitingHandler, long l, long l2) {
        this.handler = iWaitingHandler;
        this.maxWaitingTime = l;
        this.pollingInterval = l2;
        this.waitingRunnables = new ArrayList<WaitingRunnable>(4);
    }

    public AsyncWaitingMonitor invokeWhenReady(Runnable runnable) {
        return this.waitOrInvoke(new WaitingRunnable(runnable, false));
    }

    public AsyncWaitingMonitor invokeOnEDTWhenReady(Runnable runnable) {
        return this.waitOrInvoke(new WaitingRunnable(runnable, true));
    }

    private AsyncWaitingMonitor waitOrInvoke(WaitingRunnable waitingRunnable) {
        if (!this.waitAsyncIfNeeded(waitingRunnable)) {
            waitingRunnable.invoke();
        }
        return this;
    }

    private synchronized boolean waitAsyncIfNeeded(WaitingRunnable waitingRunnable) {
        if (!this.handler.isReady()) {
            this.waitingRunnables.add(waitingRunnable);
            if (!this.waitingAsync) {
                this.waitingAsync = true;
                try {
                    AsyncWorkerPool.getInstance().placeTask(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = WaitingUtil.waitUntil(AsyncWaitingMonitor.this.handler, WaitingUtil.WaitingType.OTHER, AsyncWaitingMonitor.this.maxWaitingTime, AsyncWaitingMonitor.this.pollingInterval);
                            if (bl) {
                                AsyncWaitingMonitor.this.invokeRunnables();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    LOG.error(null, (Throwable)exception);
                }
            }
            return true;
        }
        return false;
    }

    private void invokeRunnables() {
        for (WaitingRunnable waitingRunnable : this.waitingRunnables) {
            waitingRunnable.invoke();
        }
    }

    private static class WaitingRunnable {
        private final Runnable runnable;
        private final boolean invokeOnEDT;

        private WaitingRunnable(Runnable runnable, boolean bl) {
            this.runnable = runnable;
            this.invokeOnEDT = bl;
        }

        public void invoke() {
            if (!this.invokeOnEDT || EventQueue.isDispatchThread()) {
                try {
                    this.runnable.run();
                }
                catch (Exception exception) {
                    LOG.error(null, (Throwable)exception);
                }
            } else {
                EventQueue.invokeLater(this.runnable);
            }
        }
    }
}

