/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;

public class BasicImportConfig {
    private static final ALogger log = ALogger.getLogger(BasicImportConfig.class);

    public static boolean isShowImportPreviewConfigured() {
        try {
            return ConfigurationProviderFactory.getConfig().getBoolean("listtext.import.showPreview");
        }
        catch (Exception exception) {
            log.warn("Reading 'show import preview' from configuration failed. Using default: true");
            return true;
        }
    }

    public static boolean isAdditionalInfosImportConfigured() {
        try {
            return ConfigurationProviderFactory.getConfig().getBoolean("listtext.import.importAdditionalInfos");
        }
        catch (Exception exception) {
            log.warn("Reading import additional infos from configuration failed. Using default: false");
            return false;
        }
    }

    public static Collection<String> getConfiguredInstitutionNames() {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (iConfigurationProvider.exists("listtext.import.institutions")) {
            IConfigurationList iConfigurationList = iConfigurationProvider.getList("listtext.import.institutions");
            for (IConfigurationProvider iConfigurationProvider2 : iConfigurationList) {
                try {
                    arrayList.add(iConfigurationProvider2.getString("name"));
                }
                catch (Exception exception) {
                    log.warn("Reading configured default institution name failed. Skipping...");
                }
            }
        }
        arrayList.sort(String.CASE_INSENSITIVE_ORDER);
        return arrayList;
    }

    public static boolean shouldImportDepartmentName() {
        try {
            IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
            return iConfigurationProvider.getBoolean("listtext.import.importDepartmentName") && BasicImportConfig.getConfiguredDepartmentName() != null;
        }
        catch (Exception exception) {
            log.warn("Reading configured import department name flag failed -> Department name not considered in imports");
            return false;
        }
    }

    public static String getConfiguredDepartmentName() {
        try {
            IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
            return iConfigurationProvider.getString("listtext.import.departmentName");
        }
        catch (Exception exception) {
            log.warn("Reading configured import department name failed -> Department name not considered in imports");
            return null;
        }
    }

    public static boolean shouldImportStudyDescription() {
        try {
            IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
            return iConfigurationProvider.getBoolean("listtext.import.importStudyDescription");
        }
        catch (Exception exception) {
            log.warn("Reading configured import study-description flag failed -> Study Description won't be considered in imports");
            return false;
        }
    }

    public static boolean shouldAppendStudyDescription() {
        try {
            IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
            return iConfigurationProvider.getBoolean("listtext.import.appendStudyDescription");
        }
        catch (Exception exception) {
            log.warn("Reading configured append study-description flag failed -> Configured study-description will be added in imports");
            return false;
        }
    }

    public static String getConfiguredStudyDescription() {
        try {
            IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
            return iConfigurationProvider.getString("listtext.import.studyDescription");
        }
        catch (Exception exception) {
            log.warn("Reading configured study-description failed -> Study-Description will be an empty string");
            return null;
        }
    }
}

