/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import sun.security.tools.keytool.CertAndKeyGen;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;

public class CertificateUtils {
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final int KEYPAIR_LENGTH = 2048;

    public static String getLocalCN() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static boolean isCertificateValid(X509Certificate x509Certificate) {
        return CertificateUtils.isCertificateValid(x509Certificate, false);
    }

    public static boolean isCertificateValid(X509Certificate x509Certificate, boolean bl) {
        try {
            x509Certificate.checkValidity();
            return !bl || StringUtils.equalsIgnoreCase((CharSequence)CertificateUtils.getLocalCN(), (CharSequence)X500Name.asX500Name(x509Certificate.getSubjectX500Principal()).getCommonName());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static CertificateInfo createSelfSignedCertificate(String string, String string2, String string3, String string4) throws Exception {
        CertificateExtensions certificateExtensions = new CertificateExtensions();
        certificateExtensions.set("SubjectAlternativeName", new SubjectAlternativeNameExtension(new GeneralNames().add(new GeneralName(new DNSName(string)))));
        X500Name x500Name = new X500Name(string, string3, string2, string4);
        CertAndKeyGen certAndKeyGen = new CertAndKeyGen("RSA", SIGNATURE_ALGORITHM, null);
        certAndKeyGen.generate(2048);
        X509Certificate x509Certificate = certAndKeyGen.getSelfCertificate(x500Name, new Date(), 94608000L, certificateExtensions);
        return new CertificateInfo(certAndKeyGen.getPrivateKey(), x509Certificate);
    }

    public static void clearKeystore(KeyStore keyStore, String ... stringArray) throws KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (stringArray != null && ArrayUtils.contains((Object[])stringArray, (Object)string)) continue;
            keyStore.deleteEntry(string);
        }
    }

    public static class CertificateInfo {
        private final PrivateKey privateKey;
        private final X509Certificate certificate;

        private CertificateInfo(PrivateKey privateKey, X509Certificate x509Certificate) {
            this.privateKey = privateKey;
            this.certificate = x509Certificate;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public Certificate getCertificate() {
            return this.certificate;
        }
    }
}

