/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import com.agfa.pacs.listtext.lta.datafinder.DataFinderFactory;
import com.agfa.pacs.listtext.lta.datafinder.IDataFinder;
import com.agfa.pacs.listtext.lta.filter.FilterHelper;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedFilter;
import com.agfa.pacs.listtext.lta.search.ISearchThread;
import com.agfa.pacs.listtext.lta.search.SearchHandler;
import com.agfa.pacs.listtext.lta.util.PerformanceUtils;
import com.agfa.pacs.listtext.lta.util.referencedobject.DefaultReferencedObjectRetriever;
import com.agfa.pacs.listtext.lta.util.referencedobject.KeyObjectParser;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public class DataFinderUtilities {
    private static final ALogger logger = ALogger.getLogger(DataFinderUtilities.class);
    private static IDataInfoNode debugNode = null;

    public static List<IStudyInfo> findStudiesReferencedInSession(IDataInfoSource iDataInfoSource, String string) {
        logger.debug("Lookup study (UID: {})", (Object)string);
        List<IStudyInfo> list = null;
        IDataInfoSource iDataInfoSource2 = null;
        IDataInfoSource iDataInfoSource3 = iDataInfoSource;
        if (debugNode != null && iDataInfoSource != null && Objects.equals(debugNode.getIdentifier(), iDataInfoSource.getIdentifier())) {
            iDataInfoSource3 = null;
        }
        for (IDataFinder iDataFinder : DataFinderFactory.getInstance().getDataFinders()) {
            list = iDataFinder.findStudy(string, DefaultReferencedObjectRetriever.getDataNodesForKOReferences(iDataInfoSource3));
            if (!CollectionUtils.isNotEmpty(list)) continue;
            iDataInfoSource2 = list.get(0).getSource();
            break;
        }
        return DataFinderUtilities.extendSearchToDebugNodeIfPresent(string, list, iDataInfoSource2);
    }

    public static List<IStudyInfo> findStudies(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        List<IStudyInfo> list = null;
        String string5 = null;
        IDataInfoSource iDataInfoSource = null;
        if (logger.isDebugEnabled()) {
            string5 = "(UID: " + string3 + ", AccNr: " + string4 + ")";
            logger.debug("Lookup study " + string5 + " ...");
        }
        for (IDataFinder iDataFinder : DataFinderFactory.getInstance().getDataFinders()) {
            list = iDataFinder.findStudies(string, string2, string3, string4, bl, bl2);
            if (!CollectionUtils.isNotEmpty(list)) continue;
            iDataInfoSource = list.get(0).getSource();
            break;
        }
        return DataFinderUtilities.extendSearchToDebugNodeIfPresent(string3, list, iDataInfoSource);
    }

    private static List<IStudyInfo> extendSearchToDebugNodeIfPresent(String string, List<IStudyInfo> list, IDataInfoSource iDataInfoSource) {
        List list2 = list;
        IDataInfoSource iDataInfoSource2 = iDataInfoSource;
        if (debugNode != null && string != null) {
            try {
                IPersistantFilter iPersistantFilter = FilterUtilities.getStudyForUID(string);
                IRootInfo iRootInfo = debugNode.getDataInfo((IFilter)iPersistantFilter);
                if (iPersistantFilter instanceof AdvancedFilter) {
                    iRootInfo = ((AdvancedFilter)iPersistantFilter).filterOnClient(iRootInfo, debugNode.getSearchTags() == null, debugNode.getIdentifier().isEnabled(NodeProperty.ORQueriesSupported));
                }
                if (list2 == null || list2.isEmpty()) {
                    list2 = DataInfoUtilities.getLevel((IDataInfo)iRootInfo, IStudyInfo.class);
                    iDataInfoSource2 = debugNode;
                } else {
                    for (IStudyInfo iStudyInfo : list2) {
                        List list3;
                        if (!Objects.equals(iStudyInfo.getStudyUID(), string) || (list3 = DataInfoUtilities.getLevel((IDataInfo)iRootInfo, ISeriesInfo.class)).isEmpty()) continue;
                        DataFinderUtilities.mergeIntoParent((IDataInfo)iStudyInfo, list3, DataFinderUtilities::mergeSeries);
                        DataFinderUtilities.updateModalitiesInStudy(iStudyInfo, list3);
                    }
                }
            }
            catch (Exception exception) {
                logger.error("Error on debug node", (Throwable)exception);
            }
        }
        if (logger.isDebugEnabled()) {
            if (CollectionUtils.isNotEmpty(list2)) {
                logger.debug("Study found: " + string + " on " + iDataInfoSource2);
            } else {
                logger.debug("Study not found " + string);
            }
        }
        return list2;
    }

    public static List<IObjectInfo> findObjects(IDataInfoSource iDataInfoSource, Collection<String> collection) {
        return DataFinderUtilities.findObjects(Collections.singletonList(iDataInfoSource), collection);
    }

    public static List<IObjectInfo> findObjects(Collection<? extends IDataInfoSource> collection, Collection<String> collection2) {
        SearchHandler searchHandler = new SearchHandler();
        for (IDataInfoSource iDataInfoSource2 : collection) {
            searchHandler.addDataInfoSource(iDataInfoSource2);
        }
        if (collection2.isEmpty()) {
            return new ArrayList<IObjectInfo>(0);
        }
        Cancelable cancelable = searchHandler.search(FilterUtilities.getInstances(collection2), null, false);
        if (cancelable instanceof ISearchThread) {
            return DataInfoUtilities.getLevel((IDataInfo)((ISearchThread)cancelable).getResult(), IObjectInfo.class);
        }
        return null;
    }

    public static List<IObjectInfo> findKOObjects(IDataInfoSource iDataInfoSource, Map<String, ReferencedSOP> map) {
        return DataFinderUtilities.findKOObjects(iDataInfoSource, map, null);
    }

    public static List<IObjectInfo> findKOObjects(IDataInfoSource iDataInfoSource, Map<String, ReferencedSOP> map, String string) {
        SearchHandler searchHandler = new SearchHandler();
        searchHandler.addDataInfoSource(iDataInfoSource);
        String string2 = iDataInfoSource.getIdentifier().getType();
        boolean bl = true;
        if (string2.equals("DICOM")) {
            bl = Boolean.parseBoolean(iDataInfoSource.getIdentifier().getPropertiesOwner().properties().getProperty("multivaluedUIDs"));
        } else if (string2.equals("DICOMPS")) {
            bl = false;
        }
        if (!bl) {
            IRootInfo iRootInfo = DataInfoUtilities.createRoot();
            for (ReferencedSOP referencedSOP : map.values()) {
                Cancelable cancelable = searchHandler.search(KeyObjectParser.getFilter(referencedSOP), null, false);
                if (!(cancelable instanceof ISearchThread)) continue;
                DataInfoUtilities.mergeRoots((IRootInfo)iRootInfo, (IRootInfo)((ISearchThread)cancelable).getResult());
            }
            return DataInfoUtilities.getLevel((IDataInfo)iRootInfo, IObjectInfo.class);
        }
        Cancelable cancelable = searchHandler.search(FilterUtilities.getInstancesByKeys(map.keySet(), string), null, false);
        if (cancelable instanceof ISearchThread) {
            return DataInfoUtilities.getLevel((IDataInfo)((ISearchThread)cancelable).getResult(), IObjectInfo.class);
        }
        return null;
    }

    public static List<IObjectInfo> findObjectsIncremental(List<? extends IDataInfoSource> list, Collection<ReferencedSOP> collection, boolean bl, String string) {
        ReferencedSOP referencedSOP22;
        if (list == null || list.isEmpty()) {
            logger.warn("No source nodes specified. Incremental search will return 0 results!");
            return Collections.emptyList();
        }
        if (collection == null || collection.isEmpty()) {
            logger.warn("No instance-uids specified. Incremental search will return 0 results!");
            return Collections.emptyList();
        }
        HashMap<String, ReferencedSOP> hashMap = new HashMap<String, ReferencedSOP>(collection.size());
        for (ReferencedSOP referencedSOP22 : collection) {
            hashMap.put(referencedSOP22.getSOPInstanceUID(), referencedSOP22);
        }
        referencedSOP22 = new ArrayList();
        IRootInfo iRootInfo = null;
        if (bl) {
            iRootInfo = DataFinderUtilities.fastSessionRetrieval(hashMap, list, string, (List<IObjectInfo>)referencedSOP22);
        }
        for (IDataInfoSource iDataInfoSource : list) {
            if (hashMap.isEmpty()) break;
            logger.debug("Incremental search for " + hashMap.size() + " instances in source node " + iDataInfoSource);
            List<IObjectInfo> list2 = DataFinderUtilities.findKOObjects(iDataInfoSource, hashMap, string);
            if (list2 == null || list2.isEmpty()) continue;
            referencedSOP22.addAll(list2);
            List list3 = DataInfoUtilities.getRoots(list2);
            if (list3 != null) {
                for (IRootInfo iRootInfo2 : list3) {
                    iRootInfo = iRootInfo == null ? iRootInfo2 : DataInfoUtilities.mergeRoots((IRootInfo)iRootInfo, (IRootInfo)iRootInfo2);
                }
            }
            for (IObjectInfo iObjectInfo : list2) {
                hashMap.remove(iObjectInfo.getSOPInstanceUID());
            }
        }
        if (!hashMap.isEmpty()) {
            logger.warn("Unable to find all instances. Missing Objects: " + hashMap.size());
        }
        return referencedSOP22;
    }

    public static void setDebugNode(IDataInfoNode iDataInfoNode) {
        debugNode = iDataInfoNode;
    }

    private static IRootInfo fastSessionRetrieval(Map<String, ReferencedSOP> map, List<? extends IDataInfoSource> list, String string, List<IObjectInfo> list2) {
        ReferencedSOP referencedSOP2;
        HashSet<SOPInstanceReference> hashSet = new HashSet<SOPInstanceReference>();
        for (ReferencedSOP referencedSOP2 : map.values()) {
            hashSet.add(referencedSOP2.getSeries().getStudyRef());
        }
        referencedSOP2 = null;
        for (IDataInfoSource iDataInfoSource : list) {
            for (SOPInstanceReference sOPInstanceReference : hashSet) {
                IDataInfo iDataInfo = FilterHelper.performSyncSearch(FilterUtilities.getStudyForUID(sOPInstanceReference.getStudyInstanceUID(), string), iDataInfoSource);
                if (iDataInfo == null) continue;
                IRootInfo iRootInfo = DataInfoUtilities.getRoot((IDataInfo)iDataInfo);
                List list3 = DataInfoUtilities.getLevel((IDataInfo)iRootInfo, IStudyInfo.class);
                if (referencedSOP2 == null) {
                    referencedSOP2 = iRootInfo;
                } else {
                    DataInfoUtilities.mergeRoots((IRootInfo)referencedSOP2, (IRootInfo)iRootInfo);
                }
                List<IObjectInfo> list4 = null;
                list4 = list3.size() == 1 ? PerformanceUtils.getObjectLevel((IStudyInfo)list3.get(0)) : DataInfoUtilities.getLevel((IDataInfo)iRootInfo, (Level)Level.Object);
                Iterator<IObjectInfo> iterator = list4.iterator();
                while (iterator.hasNext()) {
                    String string2 = iterator.next().getKey();
                    if (!map.containsKey(string2)) {
                        iterator.remove();
                        continue;
                    }
                    map.remove(string2);
                }
                list2.addAll(list4);
            }
            if (map.isEmpty()) break;
        }
        return referencedSOP2;
    }

    private static void mergeIntoParent(IDataInfo iDataInfo, List<? extends IDataInfo> list, IDataMerger iDataMerger) {
        List list2 = iDataInfo.children();
        for (IDataInfo iDataInfo3 : list) {
            Optional<IDataInfo> optional = list2.stream().filter(iDataInfo2 -> iDataInfo3.getKey().equals(iDataInfo2.getKey())).findAny();
            if (optional.isPresent()) {
                iDataMerger.merge(iDataInfo, optional.get(), iDataInfo3);
                continue;
            }
            iDataInfo.addChild(iDataInfo3);
        }
    }

    private static void mergeSeries(IDataInfo iDataInfo, IDataInfo iDataInfo2, IDataInfo iDataInfo3) {
        DataFinderUtilities.mergeIntoParent(iDataInfo2, iDataInfo3.children(), DataFinderUtilities::replaceObjectInSeries);
    }

    private static void replaceObjectInSeries(IDataInfo iDataInfo, IDataInfo iDataInfo2, IDataInfo iDataInfo3) {
        iDataInfo.removeChild(iDataInfo2);
        iDataInfo.addChild(iDataInfo3);
    }

    private static void updateModalitiesInStudy(IStudyInfo iStudyInfo, Iterable<ISeriesInfo> iterable) {
        for (ISeriesInfo iSeriesInfo : iterable) {
            String string = iSeriesInfo.getString(524384);
            if (string == null) continue;
            DataInfoUtilities.updateModalitiesInStudy((IStudyInfo)iStudyInfo, (String)string);
        }
    }

    @FunctionalInterface
    private static interface IDataMerger {
        public void merge(IDataInfo var1, IDataInfo var2, IDataInfo var3);
    }
}

