/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.listtext.lta.util.StringRepresentationComparator;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class DicomStudyStatus
implements Comparable<DicomStudyStatus> {
    public static final String COMPLETED = "COMPLETED";
    public static final String READ = "READ";
    public static final String READING = "READING";
    private final DicomStudyStatusEnum state;
    private final String value;

    private DicomStudyStatus(DicomStudyStatusEnum dicomStudyStatusEnum) {
        this.state = dicomStudyStatusEnum;
        this.value = null;
    }

    private DicomStudyStatus(String string) {
        this.state = DicomStudyStatusEnum.Other;
        this.value = string;
    }

    public DicomStudyStatusEnum getState() {
        return this.state;
    }

    public String toString() {
        if (this.state == DicomStudyStatusEnum.Other) {
            return this.value;
        }
        return Messages.getString(this.state.name());
    }

    public String getDicom() {
        if (this.state == DicomStudyStatusEnum.Other) {
            return this.value;
        }
        return this.state.getDicom();
    }

    public String getIMPAX6Code() {
        if (this.state == DicomStudyStatusEnum.Reading) {
            return "d";
        }
        if (this.state == DicomStudyStatusEnum.Read) {
            return "D";
        }
        return "N";
    }

    public static DicomStudyStatus fromIMPAX6Code2Status(String string) {
        if (string.equalsIgnoreCase("N")) {
            return new DicomStudyStatus(DicomStudyStatusEnum.Unread);
        }
        if (string.equals("d") || string.equals("t")) {
            return new DicomStudyStatus(DicomStudyStatusEnum.Reading);
        }
        if (string.equals("D") || string.equals("T") || string.equalsIgnoreCase("r")) {
            return new DicomStudyStatus(DicomStudyStatusEnum.Read);
        }
        return DicomStudyStatus.fromString(string);
    }

    public static DicomStudyStatus fromString(String string) {
        if (string == null || string.equalsIgnoreCase(COMPLETED)) {
            return new DicomStudyStatus(DicomStudyStatusEnum.Unread);
        }
        if (string.equalsIgnoreCase(READ)) {
            return new DicomStudyStatus(DicomStudyStatusEnum.Read);
        }
        if (string.equalsIgnoreCase(READING)) {
            return new DicomStudyStatus(DicomStudyStatusEnum.Reading);
        }
        return new DicomStudyStatus(string);
    }

    public static DicomStudyStatus fromDicomEnum(DicomStudyStatusEnum dicomStudyStatusEnum) {
        return new DicomStudyStatus(dicomStudyStatusEnum);
    }

    @Override
    public int compareTo(DicomStudyStatus dicomStudyStatus) {
        int n = this.state.compareTo(dicomStudyStatus.state);
        if (n == 0) {
            n = StringRepresentationComparator.INSTANCE.compare(this.value, dicomStudyStatus.value);
        }
        return n;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DicomStudyStatus && this.compareTo((DicomStudyStatus)object) == 0;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)this.state);
        hashCodeBuilder.append((Object)this.value);
        return hashCodeBuilder.toHashCode();
    }

    public static enum DicomStudyStatusEnum {
        Unread,
        Reading,
        Read,
        Other;


        public String getDicom() {
            if (this == Unread) {
                return DicomStudyStatus.COMPLETED;
            }
            if (this == Read) {
                return DicomStudyStatus.READ;
            }
            if (this == Reading) {
                return DicomStudyStatus.READING;
            }
            return null;
        }

        public String toString() {
            if (this == Other) {
                return "";
            }
            return Messages.getString(this.name());
        }
    }
}

