/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.filter.FilterLevel;
import com.agfa.pacs.data.shared.filter.FilterTag;
import com.agfa.pacs.data.shared.node.AbstractDataInfoNode;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.lta.filter.dicom.customfields.DicomCustomField;
import com.agfa.pacs.listtext.lta.filter.dicom.customfields.DicomCustomFields;
import com.agfa.pacs.listtext.lta.util.DicomFakeNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DicomTagDictionary {
    private int[][] allSearch = new int[4][];
    private int[][] allResult = new int[5][];
    private HashSet<Integer> allTags = new HashSet();
    public static final int[] OTHER_Tags = new int[]{524416, 528448, 524417, 1572885, 0x200022, 0x200024, 0x200026, 7340162, 7340163, 528446, 2304, 0x400001, 0x400002, 0x400003, 0x400244, 4194885, 0x400006, 0x400010, 0x401001, 0x380008, 3670032, 3670048, 0x380300, 3280992, 0x400020, 4198403, 3281008, 0x400007, 0x20000D, 524312};

    DicomTagDictionary() {
        ArrayList<FilterTag> arrayList;
        HashSet<FilterTag> hashSet = new HashSet<FilterTag>();
        HashSet<FilterTag> hashSet2 = new HashSet<FilterTag>();
        List<IDataInfoNode> list = Base.getDataInfoNodes();
        ArrayList<IDataInfoNode> arrayList3 = new ArrayList<IDataInfoNode>();
        arrayList3.addAll(list);
        for (IDataInfoNode dicomCustomFields2 : arrayList3) {
            List list2;
            if (!(dicomCustomFields2 instanceof AbstractDataInfoNode)) continue;
            List list3 = dicomCustomFields2.getResultTags();
            if (list3 != null) {
                this.addAllNewToList(hashSet, list3);
            }
            if ((list2 = dicomCustomFields2.getSearchTags()) == null) continue;
            this.addAllNewToList(hashSet2, list2);
        }
        DicomCustomFields dicomCustomFields = DicomCustomFields.getDefaultInstance();
        if (dicomCustomFields != null && dicomCustomFields.getSize() > 0) {
            arrayList = new ArrayList<FilterTag>();
            for (DicomCustomField dicomCustomField : dicomCustomFields.getFields()) {
                arrayList.add(new FilterTag("DICOM", FilterLevel.get((Level)dicomCustomField.getLevel()), Integer.valueOf(dicomCustomField.getTag()), dicomCustomField.getName()));
            }
            this.addAllNewToList(hashSet2, arrayList);
            this.addAllNewToList(hashSet, arrayList);
        }
        if (hashSet.isEmpty()) {
            arrayList = DicomFakeNode.getDefaultTags();
            hashSet.addAll(arrayList);
            hashSet2.addAll(arrayList);
        }
        arrayList = new ArrayList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList arrayList4 = new ArrayList();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        this.allResult[4] = new int[OTHER_Tags.length];
        int n = 0;
        while (n < OTHER_Tags.length) {
            this.allResult[4][n] = OTHER_Tags[n];
            ++n;
        }
        for (FilterTag filterTag : hashSet) {
            if (filterTag.getLevel() == FilterLevel.Patient) {
                arrayList.add((FilterTag)filterTag.getTag());
                continue;
            }
            if (filterTag.getLevel() == FilterLevel.Study) {
                arrayList2.add(filterTag.getTag());
                continue;
            }
            if (filterTag.getLevel() == FilterLevel.Series) {
                arrayList4.add(filterTag.getTag());
                continue;
            }
            arrayList5.add(filterTag.getTag());
        }
        arrayList4.add(0x20000E);
        arrayList2.add(0x20000D);
        arrayList5.add(524312);
        this.allResult[FilterLevel.Patient.getIntLevel()] = this.toArray(arrayList);
        this.allResult[FilterLevel.Study.getIntLevel()] = this.toArray(arrayList2);
        this.allResult[FilterLevel.Series.getIntLevel()] = this.toArray(arrayList4);
        this.allResult[FilterLevel.Image.getIntLevel()] = this.toArray(arrayList5);
        arrayList.clear();
        arrayList2.clear();
        arrayList4.clear();
        arrayList5.clear();
        for (FilterTag filterTag : hashSet2) {
            if (filterTag.getLevel() == FilterLevel.Patient) {
                arrayList.add((FilterTag)filterTag.getTag());
                continue;
            }
            if (filterTag.getLevel() == FilterLevel.Study) {
                arrayList2.add(filterTag.getTag());
                continue;
            }
            if (filterTag.getLevel() == FilterLevel.Series) {
                arrayList4.add(filterTag.getTag());
                continue;
            }
            arrayList5.add(filterTag.getTag());
        }
        arrayList4.add(0x20000E);
        arrayList2.add(0x20000D);
        arrayList5.add(524312);
        this.allSearch[FilterLevel.Patient.getIntLevel()] = this.toArray(arrayList);
        this.allSearch[FilterLevel.Study.getIntLevel()] = this.toArray(arrayList2);
        this.allSearch[FilterLevel.Series.getIntLevel()] = this.toArray(arrayList4);
        this.allSearch[FilterLevel.Image.getIntLevel()] = this.toArray(arrayList5);
        int[][] nArray = this.allResult;
        int n2 = this.allResult.length;
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray2;
            int[] nArray3 = nArray2 = nArray[n3];
            int n4 = nArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                int n6 = nArray3[n5];
                this.allTags.add(n6);
                ++n5;
            }
            ++n3;
        }
    }

    public FilterLevel getLevelForTag(int n) {
        try {
            DicomCustomFields dicomCustomFields2;
            IDataInfoNode iDataInfoNode = Base.getDataInfoNodes().get(0);
            List list = iDataInfoNode.getResultTags();
            for (DicomCustomFields dicomCustomFields2 : list) {
                if (dicomCustomFields2.getTag() != n) continue;
                return dicomCustomFields2.getLevel();
            }
            dicomCustomFields2 = DicomCustomFields.getDefaultInstance();
            if (dicomCustomFields2 != null && dicomCustomFields2.getSize() > 0) {
                for (DicomCustomField dicomCustomField : dicomCustomFields2.getFields()) {
                    if (n != dicomCustomField.getTag()) continue;
                    return FilterLevel.get((Level)dicomCustomField.getLevel());
                }
            }
        }
        catch (Exception exception) {}
        return FilterLevel.Patient;
    }

    private int[] toArray(ArrayList<Integer> arrayList) {
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            nArray[n] = arrayList.get(n);
            ++n;
        }
        return nArray;
    }

    private void addAllNewToList(Set<FilterTag> set, List<FilterTag> list) {
        set.addAll(list);
    }

    protected boolean contains(int[] nArray, int n) {
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            if (n == n4) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public int[][] getAllResultTags() {
        return this.allResult;
    }

    public int[][] getAllSearchTags() {
        return this.allSearch;
    }

    public boolean isSearchTag(int n) {
        int n2 = 0;
        while (n2 < this.allSearch.length) {
            int n3 = 0;
            while (n3 < this.allSearch[n2].length) {
                if (n == this.allSearch[n2][n3]) {
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    public int[] getPatientResultTags() {
        return this.allResult[FilterLevel.Patient.getIntLevel()];
    }

    public int[] getPatientSearchTags() {
        return this.allSearch[FilterLevel.Patient.getIntLevel()];
    }

    public int[] getStudyResultTags() {
        return this.allResult[FilterLevel.Study.getIntLevel()];
    }

    public int[] getStudySearchTags() {
        return this.allSearch[FilterLevel.Study.getIntLevel()];
    }

    public int[] getSeriesResultTags() {
        return this.allResult[FilterLevel.Series.getIntLevel()];
    }

    public int[] getSeriesSearchTags() {
        return this.allSearch[FilterLevel.Series.getIntLevel()];
    }

    public int[] getObjectSearchTags() {
        return this.allSearch[FilterLevel.Image.getIntLevel()];
    }

    public int[] getObjectResultTags() {
        return this.allResult[FilterLevel.Image.getIntLevel()];
    }

    public int getLevelOfSearchTag(int n) {
        if (this.contains(this.allSearch[FilterLevel.Image.getIntLevel()], n)) {
            return FilterLevel.Image.getIntLevel();
        }
        if (this.contains(this.allSearch[FilterLevel.Series.getIntLevel()], n)) {
            return FilterLevel.Series.getIntLevel();
        }
        if (this.contains(this.allSearch[FilterLevel.Study.getIntLevel()], n)) {
            return FilterLevel.Study.getIntLevel();
        }
        if (this.contains(this.allSearch[FilterLevel.Patient.getIntLevel()], n)) {
            return FilterLevel.Patient.getIntLevel();
        }
        return FilterLevel.Default.getIntLevel();
    }

    public Set<Integer> getAllTags() {
        return this.allTags;
    }
}

