/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.listtext.lta.filter.dicom.customfields.DicomCustomField;
import com.agfa.pacs.listtext.lta.filter.dicom.customfields.DicomCustomFields;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionary;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import com.agfa.pacs.listtext.lta.util.LocaleDicomTagDictionaryAccess;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Set;
import org.dcm4che3.data.Tag;
import org.dcm4che3.util.TagUtils;

public class LocaleDicomTagDictionary {
    private Hashtable<Integer, String> names = new Hashtable();
    private Hashtable<String, Integer> ids = new Hashtable();
    private static ALogger log = ALogger.getLogger(LocaleDicomTagDictionary.class);

    /*
     * WARNING - void declaration
     */
    public LocaleDicomTagDictionary() {
        void object4;
        DicomTagDictionary dicomTagDictionary = DicomTagDictionaryFactory.getDictionary();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        Object object2 = Tag.class.getFields();
        int n = ((Field[])object2).length;
        boolean n2 = false;
        while (object4 < n) {
            Field field = object2[object4];
            try {
                Integer n3 = field.getInt(null);
                if (n3 != null) {
                    hashtable.put(n3, field.getName());
                }
            }
            catch (Exception exception) {}
            ++object4;
        }
        for (Integer n4 : dicomTagDictionary.getAllTags()) {
            String string = this.getLocaleName(TagUtils.toString((int)n4));
            if (string != null) {
                this.names.put(n4, string);
                this.ids.put(string, n4);
                continue;
            }
            log.debug("Not translated dicom tag:" + Integer.toHexString(n4));
            object2 = (String)hashtable.get(n4);
            if (object2 != null) {
                this.names.put(n4, (String)object2);
                this.ids.put((String)object2, n4);
                continue;
            }
            log.warn("Could not find name for dicom tag");
        }
        DicomCustomFields dicomCustomFields = DicomCustomFields.getDefaultInstance();
        if (dicomCustomFields != null && dicomCustomFields.getSize() > 0) {
            for (DicomCustomField dicomCustomField : dicomCustomFields.getFields()) {
                if (!this.names.containsKey(dicomCustomField.getTag())) {
                    this.names.put(dicomCustomField.getTag(), dicomCustomField.getName());
                }
                if (this.ids.containsKey(dicomCustomField.getName())) continue;
                this.ids.put(dicomCustomField.getName(), dicomCustomField.getTag());
            }
        }
    }

    public String getNameForTag(int n) {
        String string = this.names.get(n);
        if (string == null) {
            try {
                string = LocaleDicomTagDictionaryAccess.getLocaleDicomName(TagUtils.toString((int)n));
            }
            catch (MissingResourceException missingResourceException) {
                log.warn("Not translated tag:" + n);
                string = null;
            }
            if (string == null) {
                return Dcm4cheUtils.getStandardNameForTag((int)n);
            }
        }
        return string;
    }

    public String getNameForTagWithPrefix(int n) {
        String string = this.names.get(n);
        if (string == null) {
            return Integer.toHexString(n);
        }
        return string;
    }

    public Integer getTagForName(String string) {
        return string != null ? this.ids.get(string) : null;
    }

    public Set<String> getAllNames() {
        return this.ids.keySet();
    }

    public Set<Integer> getAllTags() {
        return this.names.keySet();
    }

    protected boolean contains(int[] nArray, int n) {
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            if (n == n4) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private String getLocaleName(String string) {
        if (string != null) {
            try {
                return LocaleDicomTagDictionaryAccess.getLocaleDicomName(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return null;
    }
}

