/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.hap.pacs.data.ModalityConfigUtils;
import com.agfa.pacs.base.util.DicomModalityComparator;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Modality
implements DicomEnum {
    private static final ALogger log = ALogger.getLogger(Modality.class);
    private static final String CONFIG_PATH = "listtext.modalitiesXML";
    private static final List<Modality> modalities = Collections.synchronizedList(new ArrayList(64));
    public static final Modality CR = Modality.createModality("CR", CodeDictionary.AcquisitionModality.ComputedRadiography);
    public static final Modality CT = Modality.createModality("CT", CodeDictionary.AcquisitionModality.ComputedTomography);
    public static final Modality MR = Modality.createModality("MR", CodeDictionary.AcquisitionModality.MagneticResonance);
    public static final Modality NM = Modality.createModality("NM", CodeDictionary.AcquisitionModality.NuclearMedicine);
    public static final Modality US = Modality.createModality("US", CodeDictionary.AcquisitionModality.Ultrasound);
    public static final Modality OT = Modality.createModality("OT", CodeDictionary.AcquisitionModality.Other);
    public static final Modality BI = Modality.createModality("BI", CodeDictionary.AcquisitionModality.BiomagneticImaging);
    public static final Modality DG = Modality.createModality("DG", CodeDictionary.AcquisitionModality.Diaphanography);
    public static final Modality ES = Modality.createModality("ES", CodeDictionary.AcquisitionModality.Endoscopy);
    public static final Modality LS = Modality.createModality("LS", CodeDictionary.AcquisitionModality.LaserSurfaceScan);
    public static final Modality PT = Modality.createModality("PT", CodeDictionary.AcquisitionModality.PositronEmissionTomography);
    public static final Modality RG = Modality.createModality("RG", CodeDictionary.AcquisitionModality.RadiographicImaging);
    public static final Modality TG = Modality.createModality("TG", CodeDictionary.AcquisitionModality.Thermography);
    public static final Modality XA = Modality.createModality("XA", CodeDictionary.AcquisitionModality.XRayAngiography);
    public static final Modality RF = Modality.createModality("RF", CodeDictionary.AcquisitionModality.Radiofluoroscopy);
    public static final Modality RTIMAGE = Modality.createModality("RTIMAGE", CodeDictionary.AcquisitionModality.RadiotherapyImage);
    public static final Modality RTDOSE = Modality.createModality("RTDOSE", CodeDictionary.AcquisitionModality.RadiotherapyDose);
    public static final Modality RTSTRUCT = Modality.createModality("RTSTRUCT", CodeDictionary.AcquisitionModality.RadiotherapyStructureSet);
    public static final Modality RTPLAN = Modality.createModality("RTPLAN", CodeDictionary.AcquisitionModality.RadiotherapyPlan);
    public static final Modality RTRECORD = Modality.createModality("RTRECORD", CodeDictionary.AcquisitionModality.RadiotherapyTreatmentRecord);
    public static final Modality HC = Modality.createModality("HC", CodeDictionary.AcquisitionModality.HardCopy);
    public static final Modality DX = Modality.createModality("DX", CodeDictionary.AcquisitionModality.DigitalRadiography);
    public static final Modality MG = Modality.createModality("MG", CodeDictionary.AcquisitionModality.Mammography);
    public static final Modality IO = Modality.createModality("IO", CodeDictionary.AcquisitionModality.IntraOralRadiography);
    public static final Modality PX = Modality.createModality("PX", CodeDictionary.AcquisitionModality.PanoramicXRay);
    public static final Modality GM = Modality.createModality("GM", CodeDictionary.AcquisitionModality.GeneralMicroscopy);
    public static final Modality SM = Modality.createModality("SM", CodeDictionary.AcquisitionModality.SlideMicroscopy);
    public static final Modality XC = Modality.createModality("XC", CodeDictionary.AcquisitionModality.ExternalCameraPhotography);
    public static final Modality AU = Modality.createModality("AU", CodeDictionary.AcquisitionModality.Audio);
    public static final Modality ECG = Modality.createModality("ECG", CodeDictionary.AcquisitionModality.Electrocardiography);
    public static final Modality EPS = Modality.createModality("EPS", CodeDictionary.AcquisitionModality.CardiacElectrophysiology);
    public static final Modality HD = Modality.createModality("HD", CodeDictionary.AcquisitionModality.HemodynamicWaveform);
    public static final Modality IVUS = Modality.createModality("IVUS", CodeDictionary.AcquisitionModality.IntravascularUltrasound);
    public static final Modality OP = Modality.createModality("OP", CodeDictionary.AcquisitionModality.OphthalmicPhotography);
    public static final Modality SMR = Modality.createModality("SMR", CodeDictionary.AcquisitionModality.StereometricRelationship);
    public static final Modality SR = Modality.createModality("SR", CodeDictionary.AcquisitionModality.StructuredReport);
    public static final Modality PR = Modality.createModality("PR", CodeDictionary.AcquisitionModality.PresentationState);
    public static final Modality KO = Modality.createModality("KO", CodeDictionary.AcquisitionModality.KeyObjectSelection);
    public static final Modality SC = Modality.createModality("SC", CodeDictionary.AcquisitionModality.SecondaryCapture);
    public static final Modality CD = Modality.createRetiredModality("CD");
    public static final Modality DS = Modality.createRetiredModality("DS");
    public static final Modality CF = Modality.createRetiredModality("CF");
    public static final Modality DD = Modality.createRetiredModality("DD");
    public static final Modality DF = Modality.createRetiredModality("DF");
    public static final Modality VF = Modality.createRetiredModality("VF");
    public static final Modality AS = Modality.createRetiredModality("AS");
    public static final Modality CS = Modality.createRetiredModality("CS");
    public static final Modality EC = Modality.createRetiredModality("EC");
    public static final Modality LP = Modality.createRetiredModality("LP");
    public static final Modality FA = Modality.createRetiredModality("FA");
    public static final Modality CP = Modality.createRetiredModality("CP");
    public static final Modality DM = Modality.createRetiredModality("DM");
    public static final Modality FS = Modality.createRetiredModality("FS");
    public static final Modality MA = Modality.createRetiredModality("MA");
    public static final Modality MS = Modality.createRetiredModality("MS");
    public static final Modality ST = Modality.createRetiredModality("ST");
    private static List<Modality> configuredModalities = Arrays.asList(Modality.getConfiguredModalities(ConfigurationProviderFactory.getConfig()));
    private final boolean retired;
    private final String name;
    private final Code code;

    public static List<Modality> getModalities() {
        return modalities;
    }

    private Modality(String string, Code code, boolean bl) {
        this.name = string;
        this.retired = bl;
        this.code = code;
    }

    public static Modality createUserSpecifiedModality(String string) {
        return new Modality(string, null, false);
    }

    private static Modality createModality(String string, Code code) {
        Modality modality = new Modality(string, code, false);
        modalities.add(modality);
        return modality;
    }

    private static Modality createRetiredModality(String string) {
        Modality modality = new Modality(string, null, true);
        modalities.add(modality);
        return modality;
    }

    public static List<Modality> valuesConfigured() {
        return configuredModalities;
    }

    public static Modality[] valuesConfigured(IConfigurationProvider iConfigurationProvider) {
        return Modality.getConfiguredModalities(iConfigurationProvider);
    }

    public static Modality[] valuesNonRetired() {
        ArrayList<Modality> arrayList = new ArrayList<Modality>();
        for (Modality modality : modalities) {
            if (modality.isRetired()) continue;
            arrayList.add(modality);
        }
        return arrayList.toArray(new Modality[arrayList.size()]);
    }

    public static String[] dicomStringsConfigured() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Modality modality : Modality.valuesConfigured()) {
            arrayList.add(modality.dicom());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void setValuesConfigured(IConfigurationProvider iConfigurationProvider, Modality[] modalityArray) {
        Modality.setConfiguredModalities(iConfigurationProvider, modalityArray);
    }

    public static Comparator<String> createDicomComparator() {
        return new DicomModalityComparator();
    }

    public static Modality getForDicomString(String string) {
        for (Modality modality : modalities) {
            if (!modality.dicom().equalsIgnoreCase(string)) continue;
            return modality;
        }
        return null;
    }

    public String dicom() {
        return this.name;
    }

    public Code getCode() {
        return this.code;
    }

    public boolean isRetired() {
        return this.retired;
    }

    public String toLocalizedString() {
        return Messages.getString("Modality." + this.name);
    }

    public String toString() {
        return this.dicom();
    }

    private static Modality[] getConfiguredModalities(IConfigurationProvider iConfigurationProvider) {
        List<Modality> list = null;
        try {
            String string = iConfigurationProvider.getString(CONFIG_PATH);
            list = Modality.createModalities(string);
        }
        catch (Exception exception) {
            log.warn("Reading modalities from configuration failed!");
        }
        if (list == null || list.isEmpty()) {
            log.info("No modalities configured. Using defaults...");
            if (list == null) {
                list = new ArrayList<Modality>();
            }
            list.addAll(modalities);
        }
        return list.toArray(new Modality[list.size()]);
    }

    private static void setConfiguredModalities(IConfigurationProvider iConfigurationProvider, Modality[] modalityArray) {
        try {
            String string = ModalityConfigUtils.toXML((DicomEnum[])modalityArray);
            iConfigurationProvider.setText(CONFIG_PATH, string);
            configuredModalities = modalityArray != null ? Arrays.asList(modalityArray) : new ArrayList<Modality>();
        }
        catch (Exception exception) {
            log.error("Writing modalities to configuration failed!", (Throwable)exception);
        }
    }

    private static List<Modality> createModalities(String string) {
        List list = ModalityConfigUtils.fromXML((String)string);
        if (list == null) {
            return null;
        }
        ArrayList<Modality> arrayList = new ArrayList<Modality>(list.size());
        for (String string2 : list) {
            Modality modality = Modality.getForDicomString(string2);
            if (modality == null) {
                modality = Modality.createUserSpecifiedModality(string2);
            }
            arrayList.add(modality);
        }
        return arrayList;
    }
}

