/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.filter.FilterHelper;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.findcache.IFindCache;
import com.agfa.pacs.listtext.lta.findcache.WadoRSFindCache;
import com.agfa.pacs.logging.ALogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;

public class PerformanceUtils {
    private static final ALogger LOGGER = ALogger.getLogger(PerformanceUtils.class);
    private static final boolean useExternalCache = ConfigurationProviderFactory.getConfig().getBoolean("listtext.useExternalCache");
    private static final int MINIMUM_STUDY_SIZE_FOR_PREFETCHING = (int)ConfigurationProviderFactory.getConfig().getLong("listtext.minimalCachingSize");
    private static final Set<String> MODALITIES_FOR_CACHING = new HashSet<String>(Arrays.asList("CT", "MR", "PT"));
    private static ConcurrentInitializer<IFindCache> findCache = new LazyInitializer<IFindCache>(){

        protected IFindCache initialize() throws ConcurrentException {
            return new WadoRSFindCache();
        }
    };

    public static boolean isValid(IStudyInfo iStudyInfo) {
        IPersistantFilter iPersistantFilter = FilterUtilities.getStudyForUID(iStudyInfo.getStudyUID());
        List list = DataInfoUtilities.getLevel((IDataInfo)FilterHelper.performSyncSearch(iPersistantFilter, iStudyInfo.getSource()), IStudyInfo.class);
        if (list.size() > 1) {
            return false;
        }
        return PerformanceUtils.isValid(iStudyInfo, (IStudyInfo)list.get(0));
    }

    public static boolean isValid(IStudyInfo iStudyInfo, IStudyInfo iStudyInfo2) {
        int n = iStudyInfo.getInt(2101768);
        int n2 = iStudyInfo2.getInt(2101768);
        if (n2 != n) {
            LOGGER.info("Mismatch on object count {} vs {}", (Object)n, (Object)n2);
            return false;
        }
        Set set = IDWithIssuer.pidsOf((Attributes)iStudyInfo.getTreeParent().getAttributes());
        Set set2 = IDWithIssuer.pidsOf((Attributes)iStudyInfo2.getTreeParent().getAttributes());
        return CollectionUtils.containsAny((Collection)set, (Collection)set2);
    }

    public static List<IObjectInfo> getObjectLevel(IStudyInfo iStudyInfo) {
        if (useExternalCache) {
            boolean bl;
            boolean bl2 = bl = iStudyInfo.childrenAvailable() && ((IDataInfo)iStudyInfo.children().get(0)).childrenAvailable();
            if (!bl) {
                int n = iStudyInfo.getInt(2101768);
                int n2 = iStudyInfo.getInt(2101766);
                Set set = iStudyInfo.getModalitiesInStudy();
                set.retainAll(MODALITIES_FOR_CACHING);
                if (!(n <= MINIMUM_STUDY_SIZE_FOR_PREFETCHING || set.isEmpty() || iStudyInfo.childrenAvailable() && n2 != iStudyInfo.children().size())) {
                    try {
                        List<IObjectInfo> list = ((IFindCache)findCache.get()).expandStudy(iStudyInfo);
                        if (list != null) {
                            return list;
                        }
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("Find Cache problem", throwable);
                    }
                }
            }
        }
        return DataInfoUtilities.getObjectLevel((IStudyInfo)iStudyInfo);
    }
}

