/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class StudyList
implements Serializable {
    private static final long serialVersionUID = -8234613054312337939L;
    public final List<IStudyInfo> studies;
    public final List<IStudyInfo> priors;

    public StudyList(List<IStudyInfo> list, List<IStudyInfo> list2) {
        this.studies = list;
        this.priors = list2;
    }

    public StudyList(List<IStudyInfo> list) {
        this(list, Collections.emptyList());
    }

    public IPatientInfo getPatient() {
        return this.studies.get(0).getPatient();
    }

    public boolean isEmpty() {
        return this.studies.isEmpty();
    }

    public Collection<IStudyInfo> getAllAsList() {
        LinkedHashMap<String, IStudyInfo> linkedHashMap = new LinkedHashMap<String, IStudyInfo>();
        for (IStudyInfo iStudyInfo : this.priors) {
            linkedHashMap.putIfAbsent(iStudyInfo.getKey(), iStudyInfo);
        }
        for (IStudyInfo iStudyInfo : this.studies) {
            linkedHashMap.putIfAbsent(iStudyInfo.getKey(), iStudyInfo);
        }
        return linkedHashMap.values();
    }
}

