/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.integration.IScriptHelperCreator;
import com.agfa.pacs.listtext.lta.util.TestScriptUtil;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.FileUtil;
import com.agfa.pacs.tools.StreamReader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import javax.swing.JRootPane;

public class TestScriptHelper
implements IScriptHelperCreator {
    private static final ALogger log = ALogger.getLogger(TestScriptHelper.class);

    public Object createHelper() {
        return this;
    }

    public Process exec(String string, File file) {
        try {
            Process process = Runtime.getRuntime().exec(string, null, file);
            new StreamReader(process.getInputStream(), true).start();
            return process;
        }
        catch (IOException iOException) {
            log.error("Executing command '" + string + "' failed.", (Throwable)iOException);
            return null;
        }
    }

    public int executeAndWait(String string, File file) {
        Process process = this.exec(string, file);
        if (process != null) {
            try {
                return process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                log.debug("Waiting for process end interrupted.", (Throwable)interruptedException);
            }
        }
        return -1;
    }

    public void recreateDirectory(String string) {
        File file = new File(string);
        if (file.exists()) {
            FileUtil.remove((File)file);
        }
        file.mkdirs();
    }

    public String[] readUIDs(String string) {
        return TestScriptHelper.readLines(new File(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readLines(File file) {
        if (!file.exists()) {
            log.warn("File " + file.getAbsolutePath() + " does not exists");
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
                try {
                    String[] stringArray;
                    block19: {
                        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                        try {
                            while (true) {
                                String string;
                                if ((string = bufferedReader.readLine()) == null) {
                                    stringArray = arrayList.toArray(new String[arrayList.size()]);
                                    return stringArray;
                                }
                                if (string.startsWith("#") || (string = string.trim()).length() == 0) continue;
                                arrayList.add(string);
                            }
                        }
                        finally {
                            if (bufferedReader == null) break block19;
                            bufferedReader.close();
                        }
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    return stringArray;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inputStreamReader == null) throw throwable;
                    inputStreamReader.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("IO Error", (Throwable)iOException);
            return new String[0];
        }
    }

    public boolean compareImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return TestScriptUtil.compareImagesInt(bufferedImage, bufferedImage2, null, null, 0);
    }

    public void writeImage(BufferedImage bufferedImage, String string) {
        TestScriptUtil.writeImage(bufferedImage, string);
    }

    public BufferedImage readImage(String string) {
        return TestScriptUtil.readImage(string);
    }

    public boolean writeImageDifference(BufferedImage bufferedImage, BufferedImage bufferedImage2, String string) {
        return TestScriptUtil.writeImageDifference(bufferedImage, null, bufferedImage2, string, 0);
    }

    public BufferedImage createImageOfComponent(String string) {
        Window[] windowArray = Window.getWindows();
        if (windowArray != null) {
            Object object;
            Component component = null;
            Window[] windowArray2 = windowArray;
            int n = windowArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = windowArray2[n2];
                component = this.findComponentByName((Component)object, string);
                if (component != null) break;
                ++n2;
            }
            if (component != null) {
                object = new BufferedImage(component.getWidth(), component.getHeight(), 1);
                component.paint(((BufferedImage)object).getGraphics());
                return object;
            }
        }
        return null;
    }

    public Component findComponentByName(Component component, String string) {
        if (string.equals(component.getName())) {
            return component;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component2 = componentArray[n2];
                Component component3 = null;
                if (string.equals(component2.getName())) {
                    component3 = component2;
                } else if (component2 instanceof JRootPane) {
                    component3 = this.findComponentByName(((JRootPane)component2).getContentPane(), string);
                } else if (component2 instanceof Container) {
                    component3 = this.findComponentByName(component2, string);
                }
                if (component3 != null) {
                    return component3;
                }
                ++n2;
            }
        }
        return null;
    }
}

