/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.base.util.ImageUtils;
import com.agfa.pacs.listtext.lta.util.IArrayWrapper;
import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class TestScriptUtil {
    private static final ALogger log = ALogger.getLogger(TestScriptUtil.class);
    private static final String IMAGE_FORMAT = "png";
    private static final int IMAGE_TYPE = 2;

    static boolean compareImagesInt(BufferedImage bufferedImage, BufferedImage bufferedImage2, BufferedImage bufferedImage3, String string, int n) {
        log.debug("Comparing two images: " + string);
        try {
            return TestScriptUtil.compareArrays(BufferedImageWrapper.create(bufferedImage), BufferedImageWrapper.create(bufferedImage2), bufferedImage3, new BufferedImageContentChecker(n));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Comparing images failed", (Throwable)illegalArgumentException);
            return false;
        }
    }

    public static <T extends IArrayWrapper> boolean compareArrays(T t, T t2, BufferedImage bufferedImage, IArrayContentChecker<T> iArrayContentChecker) {
        int[] nArray;
        if (t == null && t2 == null) {
            return true;
        }
        if (t == null) {
            TestScriptUtil.createErrorImage("Reference image missing", bufferedImage);
            return false;
        }
        if (t2 == null) {
            TestScriptUtil.createErrorImage("Result image missing", bufferedImage);
            return false;
        }
        int n = t.getLength();
        if (t2.getLength() != n) {
            String string = "Not the same length";
            log.warn(string);
            TestScriptUtil.createErrorImage(string, bufferedImage);
            return false;
        }
        if (bufferedImage == null) {
            nArray = null;
        } else {
            nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            if (nArray.length != n) {
                log.warn("Internal length error");
                return false;
            }
        }
        return iArrayContentChecker.compare(t, t2, nArray);
    }

    public static void writeImage(BufferedImage bufferedImage, String string) {
        TestScriptUtil.writeImage(bufferedImage, TestScriptUtil.getImageFile(string));
    }

    public static void writeImage(BufferedImage bufferedImage, File file) {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            log.warn("Creating directory failed: " + file2);
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, IMAGE_FORMAT, file);
        }
        catch (IOException iOException) {
            log.error("Storing image to file failed: " + file, (Throwable)iOException);
        }
    }

    static BufferedImage readImage(String string) {
        return TestScriptUtil.readImage(TestScriptUtil.getImageFile(string));
    }

    public static BufferedImage readImage(File file) {
        BufferedImage bufferedImage;
        if (!file.exists()) {
            return null;
        }
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            log.error("Reading image from file failed: " + file, (Throwable)iOException);
            return null;
        }
        if (bufferedImage == null) {
            log.warn("Reading image from file failed: " + file);
            return null;
        }
        return ImageUtils.toType((Image)bufferedImage, (int)2);
    }

    public static File getImageFile(String string) {
        return TestScriptUtil.getFile(string, IMAGE_FORMAT);
    }

    public static File getFile(String string, String string2) {
        return new File(string + '.' + string2);
    }

    private static BufferedImage createErrorImage(String string, BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.setFont(graphics2D.getFont().deriveFont(50));
        graphics2D.drawString(string, 0, 50);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean writeImageDifference(BufferedImage bufferedImage, Iterable<BufferedImage> iterable, BufferedImage bufferedImage2, String string, int n) {
        BufferedImage bufferedImage3 = bufferedImage != null ? new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2) : new BufferedImage(350, 100, 2);
        boolean bl = TestScriptUtil.compareImagesInt(bufferedImage, bufferedImage2, bufferedImage3, string, n);
        if (bl) {
            return true;
        }
        if (iterable != null) {
            for (BufferedImage bufferedImage4 : iterable) {
                if (!TestScriptUtil.compareImagesInt(bufferedImage4, bufferedImage2, null, null, n)) continue;
                log.debug("Alternate reference image matches result image");
                return true;
            }
        }
        log.warn("Difference in images:" + string);
        TestScriptUtil.writeImage(bufferedImage3, string);
        return false;
    }

    private static class BufferedImageContentChecker
    implements IArrayContentChecker<BufferedImageWrapper> {
        private final int maxPixelDiffCount;

        BufferedImageContentChecker(int n) {
            this.maxPixelDiffCount = n;
        }

        @Override
        public boolean compare(BufferedImageWrapper bufferedImageWrapper, BufferedImageWrapper bufferedImageWrapper2, int[] nArray) {
            int[] nArray2 = bufferedImageWrapper.getData();
            int[] nArray3 = bufferedImageWrapper2.getData();
            int n = bufferedImageWrapper.getLength();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (nArray2[n3] != nArray3[n3]) {
                    if (nArray == null && ++n2 > this.maxPixelDiffCount) {
                        return false;
                    }
                    if (nArray != null) {
                        nArray[n3] = nArray2[n3] ^ nArray3[n3] | 0xFF000000;
                    }
                }
                ++n3;
            }
            int n4 = n3 = n2 <= this.maxPixelDiffCount ? 1 : 0;
            if (n3 == 0) {
                log.debug("Difference found for {} pixels (allowed: {})", (Object)n2, (Object)this.maxPixelDiffCount);
            }
            return n3 != 0;
        }
    }

    private static class BufferedImageWrapper
    implements IArrayWrapper {
        private final int[] data;

        private BufferedImageWrapper(BufferedImage bufferedImage) {
            DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
            if (!(dataBuffer instanceof DataBufferInt)) {
                throw new IllegalArgumentException("Unsupported data buffer class: " + dataBuffer.getClass());
            }
            this.data = ((DataBufferInt)dataBuffer).getData();
        }

        static BufferedImageWrapper create(BufferedImage bufferedImage) {
            if (bufferedImage == null) {
                return null;
            }
            return new BufferedImageWrapper(bufferedImage);
        }

        @Override
        public int getLength() {
            return this.data.length;
        }

        int[] getData() {
            return this.data;
        }
    }

    public static interface IArrayContentChecker<T extends IArrayWrapper> {
        public boolean compare(T var1, T var2, int[] var3);
    }
}

