/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.logging.ALogger;
import java.util.function.BooleanSupplier;

public class WaitingUtil {
    public static final long DEFAULT_POLLING_INTERVAL = 100L;
    private static final ALogger LOGGER = ALogger.getLogger(WaitingUtil.class);

    public static boolean waitUntil(IWaitingHandler iWaitingHandler, WaitingType waitingType, long l) {
        return WaitingUtil.waitUntil(iWaitingHandler, waitingType, l, 100L);
    }

    public static boolean waitUntil(IWaitingHandler iWaitingHandler, WaitingType waitingType, long l, long l2) {
        long l3 = l / l2;
        boolean bl = false;
        while (!iWaitingHandler.isReady() && (long)bl < l3) {
            WaitingUtil.sleep(waitingType, l2);
            bl += 1;
        }
        bl = iWaitingHandler.isReady();
        LOGGER.debug("Waiting for {} successful: {}", (Object)waitingType, (Object)bl);
        return bl;
    }

    public static void sleep(WaitingType waitingType, long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn("Pausing automated test for " + (Object)((Object)waitingType) + " was interrupted.", (Throwable)interruptedException);
        }
    }

    public static long getRemainingWaitingTime(long l, long l2) {
        return Math.max(l + l2 - System.currentTimeMillis(), 0L);
    }

    @FunctionalInterface
    public static interface IWaitingHandler {
        public boolean isReady();

        public static IWaitingHandler negate(BooleanSupplier booleanSupplier) {
            return () -> !booleanSupplier.getAsBoolean();
        }
    }

    public static enum WaitingType {
        DISPLAY_INIT,
        IMAGE_DISPLAY,
        HP_EVALUATION,
        HANGING_APPLICATION,
        STUDY_LOAD,
        PLUGIN_INIT,
        USER_REQUEST,
        STRUCTURED_REPORT,
        BACKGROUND_TASK,
        OTHER;

    }
}

