/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.job;

import com.agfa.pacs.background.IBackgroundProgress;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import com.agfa.pacs.thirdparty.dcm4che3.IAttributesExtensions;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.collections4.CollectionUtils;
import org.dcm4che3.data.Attributes;

public class JobControl
implements Runnable,
IBackgroundProgress,
Cancelable {
    private int taskCount = 0;
    private int currentTask = 0;
    private ProgressStateModel model;
    private Queue<IBackgroundTask> list = new LinkedList<IBackgroundTask>();

    public JobControl(String string, String string2, List<? extends IDataInfo> list) {
        this(string, string2, JobControl.getPatients(list));
    }

    public JobControl(String string, String string2, Attributes ... attributesArray) {
        this(string, null, string2, attributesArray);
    }

    public JobControl(String string, String string2, String string3, Attributes ... attributesArray) {
        this.model = new ProgressStateModel(string, string3, attributesArray);
        this.model.addCancelable(this);
        this.model.setDetailedMessage(string2);
    }

    public synchronized boolean addTask(IBackgroundTask iBackgroundTask) {
        if (this.model == null) {
            return false;
        }
        this.list.add(iBackgroundTask);
        ++this.taskCount;
        iBackgroundTask.take((IBackgroundProgress)this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.model.setState(JobState.STARTED);
        this.model.setState(JobState.PROGRESSING);
        while (!this.list.isEmpty()) {
            if (this.model.isCanceled()) break;
            IBackgroundTask iBackgroundTask = this.list.poll();
            ++this.currentTask;
            boolean bl = iBackgroundTask.execute();
            if (bl) continue;
            this.model.setState(JobState.FAILED);
            break;
        }
        if (!this.model.isCanceled() && this.model.getProgressState() != JobState.FAILED) {
            this.model.setState(JobState.FINISHED);
        }
        JobControl jobControl = this;
        synchronized (jobControl) {
            this.model = null;
        }
    }

    public void progress(double d) {
        this.progress(d, null);
    }

    public void setProgress(float f) {
        this.model.setProgress((float)(this.currentTask - 1) / (float)this.taskCount + f / (float)this.taskCount);
    }

    public void progress(double d, String string) {
        this.setProgress((float)d);
        if (string != null) {
            this.model.setStateMessage(string);
        }
    }

    public ProgressStateModel getModel() {
        return this.model;
    }

    public void cancel() {
        while (!this.list.isEmpty()) {
            this.list.poll().terminate();
        }
    }

    public boolean isRunning() {
        return this.model.getProgressState() == JobState.STARTED || this.model.getProgressState() == JobState.PROGRESSING;
    }

    public static Attributes[] getPatients(List<? extends IDataInfo> list) {
        Attributes[] attributesArray = CollectionUtils.isEmpty(list) ? new Attributes[]{} : (Attributes[])DataInfoUtilities.getLevel(list, IPatientInfo.class).stream().map(IAttributesExtensions::getAttributes).toArray(Attributes[]::new);
        return attributesArray;
    }
}

